/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.replication.test.BaseReplicationTestCase;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DeleteTestCase
extends BaseReplicationTestCase {
    private static final Log log = ExoLogger.getLogger("exo.jcr.component.ext.DeleteTestCase");

    public DeleteTestCase(RepositoryService repositoryService, String reposytoryName, String workspaceName, String userName, String password) {
        super(repositoryService, reposytoryName, workspaceName, userName, password);
        log.info("DeleteTestCase inited");
    }

    public StringBuffer delete(String repoPath, String nodeName) {
        StringBuffer sb = new StringBuffer();
        try {
            String normalizedPath = this.getNormalizePath(repoPath);
            Node needDeleteNode = (Node)this.session.getItem(normalizedPath);
            needDeleteNode.getNode(nodeName).remove();
            this.session.save();
            sb.append("ok");
        }
        catch (Exception e) {
            log.error((Object)"Can't save nt:file : ", e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer checkDelete(String repoPath, String nodeName) {
        StringBuffer sb = new StringBuffer();
        String normalizedPath = null;
        try {
            normalizedPath = this.getNormalizePath(repoPath) + "/" + nodeName;
            Node needDeleteNode = (Node)this.session.getItem(normalizedPath);
            sb.append("fail");
            log.error("The node has not been deleted : " + normalizedPath);
        }
        catch (PathNotFoundException e) {
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)("Has not checked : " + normalizedPath), e);
        }
        return sb;
    }
}

