/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.chromattic.api.DuplicateNameException;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.api.NoSuchNodeException;
import org.chromattic.api.Status;
import org.chromattic.common.JCR;
import org.chromattic.core.ChildCollectionIterator;
import org.chromattic.core.Domain;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EmbeddedContext;
import org.chromattic.core.EntityContext;
import org.chromattic.core.NameKind;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.PersistentEntityContextState;
import org.chromattic.core.ReferentCollectionIterator;
import org.chromattic.core.RemovedEntityContextState;
import org.chromattic.core.ThrowableFactory;
import org.chromattic.core.TransientEntityContextState;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.jcr.SessionWrapper;
import org.chromattic.core.jcr.type.MixinTypeInfo;
import org.chromattic.core.jcr.type.PrimaryTypeInfo;
import org.chromattic.core.mapper.ObjectMapper;
import org.chromattic.metamodel.mapping.NodeTypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainSessionImpl
extends DomainSession {
    final Domain domain;
    private Map<String, EntityContext> contexts;

    public DomainSessionImpl(Domain domain, SessionWrapper sessionWrapper) {
        super(domain, sessionWrapper);
        this.domain = domain;
        this.contexts = new HashMap<String, EntityContext>();
    }

    @Override
    protected void _setLocalName(EntityContext ctx, String localName) throws RepositoryException {
        if (ctx == null) {
            throw new NullPointerException();
        }
        switch (ctx.getStatus()) {
            case TRANSIENT: {
                ((TransientEntityContextState)ctx.state).setLocalName(localName);
                break;
            }
            case PERSISTENT: {
                Node parentNode = ctx.getNode().getParent();
                String name = ctx.getNode().getName();
                int index = name.indexOf(58);
                String prefix = index == -1 ? null : name.substring(0, index);
                this._move(ThrowableFactory.ISE, ctx, parentNode, prefix, localName);
                break;
            }
            default: {
                throw new IllegalStateException("Removed node cannot have its name updated");
            }
        }
    }

    @Override
    protected String _getLocalName(EntityContext ctx) throws RepositoryException {
        if (ctx == null) {
            throw new NullPointerException();
        }
        switch (ctx.getStatus()) {
            default: {
                return ctx.state.getLocalName();
            }
            case PERSISTENT: 
        }
        Node node = ctx.state.getNode();
        Node parentNode = node.getParent();
        String name = node.getName();
        int index = name.indexOf(58);
        String localName = index == -1 ? name : name.substring(index + 1);
        return this.domain.decodeName(parentNode, localName, NameKind.OBJECT);
    }

    @Override
    protected <E> E _findByPath(Class<E> clazz, String path) throws RepositoryException {
        Node node = this.sessionWrapper.getNode(path);
        if (node != null) {
            return this._findByNode((Class)clazz, node);
        }
        return null;
    }

    protected <O> O _findByPath(EntityContext ctx, Class<O> clazz, String relPath) throws RepositoryException {
        Node origin = ctx != null ? ctx.state.getNode() : this._getRoot();
        Node node = this.sessionWrapper.getNode(origin, relPath);
        if (node != null) {
            return this._findByNode(clazz, node);
        }
        return null;
    }

    @Override
    protected <T1 extends Throwable> void _persist(ThrowableFactory<T1> nullLocaleNameTF, EntityContext ctx, String prefix, String localName) throws T1, RepositoryException {
        if (ctx == null) {
            throw new NullPointerException("No null object context accepted");
        }
        if (localName == null) {
            String msg = "No relative path specified";
            throw nullLocaleNameTF.newThrowable(msg);
        }
        if (ctx.getStatus() != Status.TRANSIENT) {
            String msg = "Attempt to persist non transient object " + ctx;
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        log.trace("Setting context {} for insertion", (Object)ctx);
        log.trace("Adding node for context {} and node type {}", (Object)ctx, ctx.mapper);
        this._persist(this._getRoot(), prefix, localName, ctx);
    }

    @Override
    protected <T1 extends Throwable, T2 extends Throwable, T3 extends Throwable> void _persist(ThrowableFactory<T1> srcStateTF, ThrowableFactory<T2> dstStateTF, ThrowableFactory<T3> nullLocaleNameTF, ObjectContext srcCtx, String prefix, String localName, EntityContext dstCtx) throws T1, T2, T3, NullPointerException, RepositoryException {
        if (srcCtx == null) {
            String msg = "Cannot insert context " + dstCtx + " as a child of a null context";
            log.error(msg);
            throw new NullPointerException(msg);
        }
        if (dstCtx.getStatus() != Status.TRANSIENT) {
            String msg = "Attempt to insert non transient context " + dstCtx + " as child of " + srcCtx;
            log.error(msg);
            throw dstStateTF.newThrowable();
        }
        if (localName == null) {
            String msg = "Attempt to insert context " + dstCtx + " with no name to " + srcCtx;
            log.error(msg);
            throw nullLocaleNameTF.newThrowable(msg);
        }
        if (srcCtx.getStatus() != Status.PERSISTENT) {
            String msg = "Attempt to insert context " + dstCtx + " as child of non persistent context " + srcCtx;
            log.error(msg);
            throw srcStateTF.newThrowable(msg);
        }
        Node parentNode = srcCtx.getEntity().state.getNode();
        this._persist(parentNode, prefix, localName, dstCtx);
    }

    private void _persist(Node srcNode, String prefix, String localName, EntityContext dstCtx) throws RepositoryException {
        Node previousNode;
        ObjectMapper<EntityContext> mapper = dstCtx.mapper;
        localName = this.domain.encodeName(srcNode, localName, NameKind.OBJECT);
        String name = JCR.qualify((String)prefix, (String)localName);
        NameConflictResolution onDuplicate = NameConflictResolution.FAIL;
        NodeType parentNodeType = srcNode.getPrimaryNodeType();
        ObjectMapper parentTypeMapper = this.domain.getTypeMapper(parentNodeType.getName());
        if (parentTypeMapper != null) {
            onDuplicate = parentTypeMapper.getOnDuplicate();
        }
        if ((previousNode = this.sessionWrapper.getNode(srcNode, name)) != null) {
            log.trace("Found existing child with same name {}", (Object)name);
            if (onDuplicate == NameConflictResolution.FAIL) {
                String msg = "Attempt to insert context " + dstCtx + " as an existing child with name " + name + " child of node " + srcNode.getPath();
                log.error(msg);
                throw new DuplicateNameException(msg);
            }
            log.trace("About to remove same name {} child with id {}", (Object)previousNode.getPath(), (Object)previousNode.getName());
            this.remove(previousNode);
        }
        String primaryNodeTypeName = mapper.getNodeTypeName();
        log.trace("Setting context {} for insertion", (Object)dstCtx);
        log.trace("Adding node for context {} and node type {} as child of node {}", new Object[]{dstCtx, primaryNodeTypeName, srcNode.getPath()});
        Node dstNode = this.sessionWrapper.addNode(srcNode, name, primaryNodeTypeName, Collections.<String>emptyList());
        if (!this.domain.nodeInfoManager.isReferenceable(dstNode)) {
            dstNode.addMixin("mix:referenceable");
        }
        this.nodeAdded(dstNode, dstCtx);
        log.trace("Added context {} for path {}", new Object[]{dstCtx, dstCtx.getId(), dstNode.getPath()});
    }

    @Override
    protected EntityContext _copy(EntityContext srcCtx, String prefix, String localName) throws RepositoryException {
        return this._copy(this.getRoot(), srcCtx, JCR.qualify((String)prefix, (String)localName));
    }

    @Override
    protected EntityContext _copy(EntityContext parentCtx, EntityContext srcCtx, String prefix, String localName) throws RepositoryException {
        if (parentCtx == null) {
            throw new NullPointerException();
        }
        if (parentCtx.getStatus() == Status.PERSISTENT) {
            throw new IllegalArgumentException("Parent object is not persistent");
        }
        return this._copy(parentCtx.getNode(), srcCtx, JCR.qualify((String)prefix, (String)localName));
    }

    private EntityContext _copy(Node parentNode, EntityContext srcCtx, String name) throws RepositoryException {
        String localName;
        String prefix;
        if (srcCtx == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (srcCtx.getStatus() != Status.PERSISTENT) {
            throw new IllegalArgumentException("Copied object is not persistent");
        }
        EntityContext dstCtx = (EntityContext)this._create(srcCtx.mapper.getObjectClass(), null);
        int index = name.indexOf(58);
        if (index == -1) {
            prefix = null;
            localName = name;
        } else {
            prefix = name.substring(0, index);
            localName = name.substring(index + 1);
        }
        this._persist(parentNode, prefix, localName, dstCtx);
        Node dstNode = dstCtx.getNode();
        for (NodeType mixinNodeType : srcCtx.getNode().getMixinNodeTypes()) {
            dstNode.addMixin(mixinNodeType.getName());
        }
        Iterator<Property> i = this.sessionWrapper.getProperties(srcCtx.getNode());
        while (i.hasNext()) {
            Property p = i.next();
            PropertyDefinition def = p.getDefinition();
            if (def.isProtected()) continue;
            if (def.isMultiple()) {
                Value[] values = p.getValues();
                dstNode.setProperty(p.getName(), values);
                continue;
            }
            Value value = p.getValue();
            dstNode.setProperty(p.getName(), value);
        }
        i = this.sessionWrapper.getChildren(srcCtx.getNode());
        while (i.hasNext()) {
            Node n = (Node)i.next();
            EntityContext c = this._getEntity(n);
            if (c == null) {
                throw new UnsupportedOperationException();
            }
            this._copy(dstNode, c, n.getName());
        }
        return dstCtx;
    }

    @Override
    protected void _addMixin(EntityContext entityCtx, EmbeddedContext mixinCtx) throws RepositoryException {
        if (entityCtx == null) {
            throw new NullPointerException();
        }
        if (mixinCtx == null) {
            throw new NullPointerException();
        }
        if (mixinCtx.relatedEntity != null) {
            if (mixinCtx.relatedEntity != entityCtx) {
                throw new IllegalArgumentException();
            }
        } else {
            EmbeddedContext previousMixinCtx = (EmbeddedContext)entityCtx.getAttribute(mixinCtx.mapper);
            if (previousMixinCtx != null) {
                if (previousMixinCtx != mixinCtx) {
                    throw new IllegalStateException();
                }
            } else {
                String mixinTypeName = mixinCtx.mapper.getNodeTypeName();
                Node node = entityCtx.state.getNode();
                if (!this.sessionWrapper.canAddMixin(node, mixinTypeName)) {
                    throw new IllegalArgumentException("Cannot add mixin " + mixinCtx + " to context " + entityCtx);
                }
                this.sessionWrapper.addMixin(node, mixinTypeName);
                NodeType mixinType = this.sessionWrapper.getNodeType(mixinTypeName);
                MixinTypeInfo mixinTypeInfo = this.domain.nodeInfoManager.getMixinTypeInfo(mixinType);
                entityCtx.setAttribute(mixinCtx.mapper, mixinCtx);
                mixinCtx.relatedEntity = entityCtx;
                mixinCtx.typeInfo = mixinTypeInfo;
            }
        }
    }

    @Override
    protected void _removeMixin(EntityContext entityCtx, Class<?> mixinType) throws RepositoryException {
        if (entityCtx == null) {
            throw new NullPointerException();
        }
        if (mixinType == null) {
            throw new NullPointerException();
        }
        ObjectMapper mapper = this.domain.getTypeMapper(mixinType);
        if (mapper != null) {
            String mixinTypeName = mapper.getNodeTypeName();
            Node node = entityCtx.state.getNode();
            this.sessionWrapper.removeMixin(node, mixinTypeName);
            EmbeddedContext mixinCtx = (EmbeddedContext)entityCtx.setAttribute(mapper, null);
            if (mixinCtx != null) {
                mixinCtx.relatedEntity = null;
            }
        }
    }

    @Override
    protected EmbeddedContext _getEmbedded(EntityContext entityCtx, Class<?> embeddedType) throws RepositoryException {
        if (entityCtx == null) {
            throw new NullPointerException();
        }
        if (embeddedType == null) {
            throw new NullPointerException();
        }
        ObjectMapper mapper = this.domain.getTypeMapper(embeddedType);
        EmbeddedContext embeddedCtx = null;
        if (mapper != null && (embeddedCtx = (EmbeddedContext)entityCtx.getAttribute(mapper)) == null) {
            Node node = entityCtx.state.getNode();
            if (mapper.getKind() == NodeTypeKind.MIXIN) {
                String mixinTypeName = mapper.getNodeTypeName();
                if (this.sessionWrapper.haxMixin(node, mixinTypeName)) {
                    NodeType mixinType = this.sessionWrapper.getNodeType(mixinTypeName);
                    MixinTypeInfo mixinTypeInfo = this.domain.nodeInfoManager.getMixinTypeInfo(mixinType);
                    embeddedCtx = new EmbeddedContext(mapper, this);
                    entityCtx.setAttribute(embeddedCtx.mapper, embeddedCtx);
                    embeddedCtx.relatedEntity = entityCtx;
                    embeddedCtx.typeInfo = mixinTypeInfo;
                }
            } else {
                PrimaryTypeInfo typeInfo = entityCtx.state.getTypeInfo();
                PrimaryTypeInfo superTI = (PrimaryTypeInfo)typeInfo.getSuperType(mapper.getNodeTypeName());
                if (superTI != null) {
                    embeddedCtx = new EmbeddedContext(mapper, this);
                    entityCtx.setAttribute(embeddedCtx.mapper, embeddedCtx);
                    embeddedCtx.relatedEntity = entityCtx;
                    embeddedCtx.typeInfo = superTI;
                }
            }
        }
        return embeddedCtx;
    }

    @Override
    protected <T1 extends Throwable, T2 extends Throwable> void _move(ThrowableFactory<T1> srcStateTF, ThrowableFactory<T2> dstStateTF, EntityContext srcCtx, ObjectContext dstCtx, String dstPrefix, String dstLocalName) throws T1, T2, NullPointerException, RepositoryException {
        if (dstCtx == null) {
            String msg = "Cannot move to null context";
            log.error(msg);
            throw new NullPointerException(msg);
        }
        if (dstCtx.getStatus() != Status.PERSISTENT) {
            String msg = "Attempt to move child " + srcCtx + " to a non persistent context " + dstCtx;
            log.error(msg);
            throw dstStateTF.newThrowable(msg);
        }
        Node dstNode = dstCtx.getEntity().state.getNode();
        this._move(srcStateTF, srcCtx, dstNode, dstPrefix, dstLocalName);
    }

    private <T1 extends Throwable> void _move(ThrowableFactory<T1> srcStateTF, EntityContext srcCtx, Node dstNode, String dstPrefix, String dstLocalName) throws T1, NullPointerException, RepositoryException {
        Node previousNode;
        if (srcCtx == null) {
            String msg = "Cannot move null context";
            log.error(msg);
            throw new NullPointerException(msg);
        }
        if (srcCtx.getStatus() != Status.PERSISTENT) {
            String msg = "Attempt to move non persistent context " + srcCtx + " as child of " + dstNode.getPath();
            log.error(msg);
            throw srcStateTF.newThrowable(msg);
        }
        dstLocalName = this.domain.encodeName(dstNode, dstLocalName, NameKind.OBJECT);
        String dstName = JCR.qualify((String)dstPrefix, (String)dstLocalName);
        Node srcNode = srcCtx.state.getNode();
        NameConflictResolution onDuplicate = NameConflictResolution.FAIL;
        NodeType parentNodeType = dstNode.getPrimaryNodeType();
        ObjectMapper parentTypeMapper = this.domain.getTypeMapper(parentNodeType.getName());
        if (parentTypeMapper != null) {
            onDuplicate = parentTypeMapper.getOnDuplicate();
        }
        if ((previousNode = this.sessionWrapper.getNode(dstNode, dstName)) != null) {
            log.trace("Found existing child with same name {}", (Object)dstName);
            if (srcNode.getParent() != dstNode) {
                if (onDuplicate == NameConflictResolution.FAIL) {
                    String msg = "Attempt to move context " + dstNode.getPath() + " as an existing child with name " + dstName + " child of node " + dstNode.getPath();
                    log.error(msg);
                    throw new DuplicateNameException(msg);
                }
                log.trace("About to remove same name {} child with id {}", (Object)previousNode.getPath(), (Object)previousNode.getName());
                throw new UnsupportedOperationException("Do that properly");
            }
        } else {
            this.sessionWrapper.move(srcNode, dstNode, dstName);
        }
    }

    @Override
    protected void _orderBefore(ObjectContext parentCtx, EntityContext srcCtx, EntityContext dstCtx) throws RepositoryException {
        if (parentCtx == null) {
            throw new NullPointerException();
        }
        if (srcCtx == null) {
            throw new NullPointerException();
        }
        Node parentNode = parentCtx.getEntity().state.getNode();
        Node srcNode = srcCtx.state.getNode();
        Node dstNode = dstCtx != null ? dstCtx.state.getNode() : null;
        this.sessionWrapper.orderBefore(parentNode, srcNode, dstNode);
    }

    @Override
    protected ObjectContext _create(Class<?> clazz, String localName) throws NullPointerException, IllegalArgumentException, RepositoryException {
        ObjectContext octx;
        if (clazz == null) {
            throw new NullPointerException();
        }
        ObjectMapper typeMapper = this.domain.getTypeMapper(clazz);
        if (typeMapper == null) {
            throw new IllegalArgumentException("The type " + clazz.getName() + " is not mapped");
        }
        if (typeMapper.getKind() == NodeTypeKind.PRIMARY && typeMapper.isAbstract()) {
            throw new IllegalArgumentException("The type " + clazz.getName() + " is abstract");
        }
        TransientEntityContextState state = new TransientEntityContextState(this);
        if (typeMapper.getKind() == NodeTypeKind.PRIMARY) {
            EntityContext ctx = new EntityContext(typeMapper, state);
            if (localName != null) {
                ctx.setLocalName(localName);
            }
            this.broadcaster.created(ctx.getObject());
            octx = ctx;
        } else {
            if (localName != null) {
                throw new IllegalArgumentException("Cannot create a mixin type with a name");
            }
            octx = new EmbeddedContext(typeMapper, this);
        }
        return octx;
    }

    protected <O> O _findById(Class<O> clazz, String id) throws RepositoryException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (id == null) {
            throw new NullPointerException();
        }
        log.trace("About to load node with id {} and class {}", (Object)id, (Object)clazz.getName());
        Node node = this.sessionWrapper.getNodeByUUID(id);
        if (node != null) {
            return this._findByNode(clazz, node);
        }
        log.trace("Could not find node with id {}", (Object)id, (Object)clazz.getName());
        return null;
    }

    protected <O> O _findByNode(Class<O> clazz, Node node) throws RepositoryException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this._getEntity(node);
        if (ctx == null) {
            return null;
        }
        return this.cast(ctx, clazz);
    }

    @Override
    protected EntityContext _getEntity(Node node) throws RepositoryException {
        if (node == null) {
            throw new NullPointerException();
        }
        if (!this.domain.nodeInfoManager.isReferenceable(node)) {
            log.trace("Cannot map non referenceable node {} to a chromattic object", (Object)node.getPath());
            return null;
        }
        return this.nodeRead(node);
    }

    @Override
    protected void _save() throws RepositoryException {
        this.sessionWrapper.save();
    }

    @Override
    protected void _remove(EntityContext context) throws RepositoryException {
        if (context == null) {
            throw new NullPointerException();
        }
        switch (context.state.getStatus()) {
            case TRANSIENT: {
                throw new IllegalStateException("Cannot remove transient node");
            }
            case PERSISTENT: {
                Node node = context.state.getNode();
                this.remove(node);
                break;
            }
            case REMOVED: {
                throw new IllegalStateException("Cannot remove removed node");
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void remove(Node node) throws RepositoryException {
        LinkedList<Removed> removeds = new LinkedList<Removed>();
        String pathToRemove = node.getPath();
        for (Map.Entry<String, EntityContext> ctxEntry : this.contexts.entrySet()) {
            EntityContext ctx = ctxEntry.getValue();
            Node ctxNode = ctx.state.getNode();
            if (!ctxNode.getPath().startsWith(pathToRemove)) continue;
            removeds.add(new Removed(ctx.getId(), ctx.getPath(), ctx.getLocalName(), ctx));
        }
        this.sessionWrapper.remove(node);
        Collection<EntityContext> ctxs = this.contexts.values();
        for (Removed removed : removeds) {
            String path = removed.path;
            log.trace("Removing context for path {}", (Object)path);
            ((Removed)removed).ctx.state = new RemovedEntityContextState(this, path, removed.localName, removed.ctx.getTypeInfo());
            ctxs.remove(removed.ctx);
            this.broadcaster.removed(removed.id, removed.path, removed.localName, removed.ctx.getObject());
            log.trace("Removed context {} for path {}", (Object)removed.ctx, (Object)path);
        }
    }

    @Override
    protected EntityContext _getReferenced(ObjectContext referentCtx, String name, LinkType linkType) throws RepositoryException {
        if (referentCtx.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException();
        }
        Node referent = referentCtx.getEntity().state.getNode();
        Node referenced = this.sessionWrapper.getReferenced(referent, name, linkType);
        if (referenced != null) {
            return this._getEntity(referenced);
        }
        return null;
    }

    @Override
    protected boolean _setReferenced(ObjectContext referentCtx, String name, EntityContext referencedCtx, LinkType linkType) throws RepositoryException {
        if (referentCtx.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException("Cannot create a relationship with a non persisted context " + this);
        }
        Node referent = referentCtx.getEntity().state.getNode();
        if (referencedCtx != null) {
            if (referencedCtx.getStatus() != Status.PERSISTENT) {
                throw new IllegalStateException();
            }
            Node referenced = referencedCtx.state.getNode();
            Node previouslyReferenced = this.sessionWrapper.setReferenced(referent, name, referenced, linkType);
            if (previouslyReferenced != null) {
                String previousReferencedId = previouslyReferenced.getUUID();
                String referencedId = referenced.getUUID();
                return !referencedId.equals(previousReferencedId);
            }
            return true;
        }
        return null != this.sessionWrapper.setReferenced(referent, name, null, linkType);
    }

    @Override
    protected <T> Iterator<T> _getReferents(EntityContext referencedCtx, String name, Class<T> filterClass, LinkType linkType) throws RepositoryException {
        Node referenced = referencedCtx.getEntity().state.getNode();
        Iterator<Node> referents = this.sessionWrapper.getReferents(referenced, name, linkType);
        return new ReferentCollectionIterator<T>(this, referents, filterClass, name);
    }

    @Override
    protected void _removeChild(ObjectContext ctx, String prefix, String localName) throws RepositoryException {
        localName = this.domain.encodeName(ctx, localName, NameKind.OBJECT);
        String name = JCR.qualify((String)prefix, (String)localName);
        Node node = ctx.getEntity().state.getNode();
        Node childNode = this.sessionWrapper.getNode(node, name);
        if (childNode != null) {
            this.remove(childNode);
        }
    }

    @Override
    protected EntityContext _getChild(ObjectContext ctx, String prefix, String localName) throws RepositoryException {
        localName = this.domain.encodeName(ctx, localName, NameKind.OBJECT);
        String name = JCR.qualify((String)prefix, (String)localName);
        Node node = ctx.getEntity().state.getNode();
        log.trace("About to load the name child {} of context {}", (Object)name, (Object)this);
        Node child = this.sessionWrapper.getChild(node, name);
        if (child != null) {
            log.trace("Loaded named child {} of context {} with path {}", new Object[]{name, this, child.getPath()});
            return this._getEntity(child);
        }
        log.trace("No child named {} to load for context {}", (Object)name, (Object)this);
        return null;
    }

    @Override
    protected <T> Iterator<T> _getChildren(ObjectContext ctx, Class<T> filterClass) throws RepositoryException {
        Node node = ctx.getEntity().state.getNode();
        Iterator<Node> iterator = this.sessionWrapper.getChildren(node);
        return new ChildCollectionIterator<T>(this, iterator, filterClass);
    }

    @Override
    protected EntityContext _getParent(EntityContext ctx) throws RepositoryException {
        if (ctx.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException();
        }
        Node node = ctx.state.getNode();
        Node parent = this.sessionWrapper.getParent(node);
        return this._getEntity(parent);
    }

    @Override
    protected Node _getRoot() throws RepositoryException {
        Session session = this.sessionWrapper.getSession();
        List<String> pathSegments = this.domain.rootNodePathSegments;
        Node current = session.getRootNode();
        String rootNodeType = this.domain.rootNodeType;
        boolean created = false;
        if (!pathSegments.isEmpty()) {
            for (int i = 0; i < pathSegments.size(); ++i) {
                String pathSegment = pathSegments.get(i);
                if (current.hasNode(pathSegment)) {
                    current = current.getNode(pathSegment);
                    continue;
                }
                if (this.domain.rootCreateMode == Domain.NO_CREATE_MODE) {
                    throw new NoSuchNodeException("No existing root node " + this.domain.rootNodePath);
                }
                current = rootNodeType != null ? current.addNode(pathSegment, rootNodeType) : current.addNode(pathSegment);
                created = true;
            }
        }
        if (created && this.domain.rootCreateMode == Domain.CREATE_MODE) {
            Node toSave = current;
            while (toSave.isNew()) {
                toSave = toSave.getParent();
            }
            toSave.save();
        }
        return current;
    }

    private <O> O cast(EntityContext ctx, Class<O> clazz) {
        Object object = ctx.object;
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        String msg = "Could not cast context " + ctx + " with class " + object.getClass().getName() + " to class " + clazz.getName();
        throw new ClassCastException(msg);
    }

    private EntityContext nodeRead(Node node) throws RepositoryException {
        NodeType nodeType = node.getPrimaryNodeType();
        String nodeTypeName = nodeType.getName();
        ObjectMapper mapper = this.domain.getTypeMapper(nodeTypeName);
        if (mapper != null) {
            EntityContext ctx = this.contexts.get(node.getUUID());
            if (ctx == null) {
                ctx = new EntityContext(mapper, new PersistentEntityContextState(node, this));
                log.trace("Inserted context {} loaded from node path {}", (Object)ctx, (Object)node.getPath());
                this.contexts.put(node.getUUID(), ctx);
                this.broadcaster.loaded(ctx, ctx.getObject());
            } else {
                log.trace("Context {} is already present for path ", (Object)ctx, (Object)node.getPath());
            }
            return ctx;
        }
        log.trace("Could not find mapper for node type {}", (Object)nodeTypeName);
        return null;
    }

    private void nodeAdded(Node node, EntityContext ctx) throws RepositoryException {
        NodeType nodeType = node.getPrimaryNodeType();
        String nodeTypeName = nodeType.getName();
        ObjectMapper mapper = this.domain.getTypeMapper(nodeTypeName);
        if (mapper != null) {
            if (this.contexts.containsKey(node.getUUID())) {
                String msg = "Attempt to replace an existing context " + ctx + " with path " + node.getPath();
                log.error(msg);
                throw new AssertionError((Object)msg);
            }
            log.trace("Inserted context {} for path {}", (Object)ctx, (Object)node.getPath());
            this.contexts.put(node.getUUID(), ctx);
            ctx.state = new PersistentEntityContextState(node, this);
            this.broadcaster.added(ctx, ctx.getObject());
        } else {
            log.trace("Could not find mapper for node type {}", (Object)nodeTypeName);
        }
    }

    @Override
    public void _close() {
        this.sessionWrapper.close();
    }

    private static class Removed {
        private final String id;
        private final String path;
        private final String localName;
        private final EntityContext ctx;

        private Removed(String id, String path, String localName, EntityContext ctx) {
            this.id = id;
            this.path = path;
            this.localName = localName;
            this.ctx = ctx;
        }
    }
}

