/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.chromattic.api.Status;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.common.logging.Logger;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EmbeddedContext;
import org.chromattic.core.EntityContextState;
import org.chromattic.core.NameKind;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.jcr.type.PrimaryTypeInfo;
import org.chromattic.core.mapper.ObjectMapper;
import org.chromattic.metamodel.mapping.NodeAttributeType;
import org.chromattic.spi.instrument.MethodHandler;
import org.chromattic.spi.instrument.ProxyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityContext
extends ObjectContext<EntityContext> {
    private static final Logger log = Logger.getLogger(EntityContext.class);
    final ObjectMapper<EntityContext> mapper;
    final Object object;
    EntityContextState state;
    private Map<Object, Object> attributes;

    EntityContext(ObjectMapper<EntityContext> mapper, EntityContextState state) throws RepositoryException {
        ProxyType<?> pt = state.getSession().domain.getProxyType(mapper.getObjectClass());
        Object object = pt.createProxy((MethodHandler)this);
        this.state = null;
        this.mapper = mapper;
        this.object = object;
        this.state = state;
        this.attributes = null;
    }

    public Object getAttribute(Object key) {
        if (key == null) {
            throw new AssertionError((Object)"Should not provide a null key");
        }
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public Object setAttribute(Object key, Object value) {
        if (key == null) {
            throw new AssertionError((Object)"Should not provide a null key");
        }
        if (value == null) {
            if (this.attributes != null) {
                return this.attributes.remove(key);
            }
            return null;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>();
        }
        return this.attributes.put(key, value);
    }

    public Node getNode() {
        return this.state.getNode();
    }

    @Override
    public DomainSession getSession() {
        return this.state.getSession();
    }

    @Override
    public Status getStatus() {
        return this.state.getStatus();
    }

    @Override
    public ObjectMapper<EntityContext> getMapper() {
        return this.mapper;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public EntityContext getEntity() {
        return this;
    }

    @Override
    public PrimaryTypeInfo getTypeInfo() {
        EntityContextState state = this.getEntity().state;
        return state.getTypeInfo();
    }

    public String decodeName(String name, NameKind nameKind) {
        try {
            return this.state.getSession().getDomain().decodeName(this, name, nameKind);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public String encodeName(String name, NameKind nameKind) {
        try {
            return this.state.getSession().getDomain().encodeName(this, name, nameKind);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public <T> T adapt(Class<T> adaptedClass) {
        if (adaptedClass.isInstance(this.object)) {
            return adaptedClass.cast(this.object);
        }
        EmbeddedContext embeddedCtx = this.getEmbedded(adaptedClass);
        if (embeddedCtx != null) {
            return adaptedClass.cast(embeddedCtx.getObject());
        }
        return null;
    }

    public void addMixin(EmbeddedContext mixinCtx) {
        this.state.getSession().addMixin(this, mixinCtx);
    }

    public void removeMixin(Class<?> mixinType) {
        this.state.getSession().removeMixin(this, mixinType);
    }

    public EmbeddedContext getEmbedded(Class<?> embeddedType) {
        return this.state.getSession().getEmbedded(this, embeddedType);
    }

    public String getAttribute(NodeAttributeType type) {
        DomainSession session = this.state.getSession();
        switch (type) {
            case NAME: {
                return session.getLocalName(this);
            }
            case ID: {
                return this.state.getId();
            }
            case PATH: {
                return this.state.getPath();
            }
            case WORKSPACE_NAME: {
                return session.sessionWrapper.getSession().getWorkspace().getName();
            }
        }
        throw new AssertionError();
    }

    public void remove() {
        this.state.getSession().remove(this);
    }

    public <T> Iterator<T> getReferents(String name, Class<T> filterClass, LinkType linkType) {
        return this.state.getSession().getReferents(this, name, filterClass, linkType);
    }

    public String getLocalName() {
        return this.getAttribute(NodeAttributeType.NAME);
    }

    public String getId() {
        return this.getAttribute(NodeAttributeType.ID);
    }

    public String getPath() {
        return this.getAttribute(NodeAttributeType.PATH);
    }

    public void setLocalName(String name) {
        this.state.getSession().setLocalName(this, name);
    }

    public EntityContext getReferenced(String name, LinkType linkType) {
        return this.state.getSession().getReferenced(this, name, linkType);
    }

    public void setReferenced(String name, EntityContext referencedCtx, LinkType linkType) {
        DomainSession session = this.state.getSession();
        session.setReferenced(this, name, referencedCtx, linkType);
    }

    public boolean addReference(String name, EntityContext referentCtx, LinkType linkType) {
        DomainSession session = this.state.getSession();
        return session.setReferenced(referentCtx, name, this, linkType);
    }

    public EntityContext getParent() {
        return this.state.getSession().getParent(this);
    }

    public String toString() {
        return "EntityContext[state=" + this.state + ",mapper=" + this.mapper + "]";
    }
}

