/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.contact.service.impl.JCRDataStorage;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;

public class NewMembershipListener
extends MembershipEventListener {
    private static final Log log = ExoLogger.getExoLogger(NewMembershipListener.class);
    private ContactService cservice_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private RepositoryService reposervice_;

    public NewMembershipListener(ContactService cservice, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService rservice) throws Exception {
        this.cservice_ = cservice;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.reposervice_ = rservice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(Membership m, boolean isNew) throws Exception {
        String username = m.getUserName();
        String groupId = m.getGroupId();
        this.cservice_.addUserContactInAddressBook(username, groupId);
        JCRDataStorage storage_ = new JCRDataStorage(this.nodeHierarchyCreator_, this.reposervice_);
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        try {
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(DataStorage.USERS_PATH);
            Contact contact = this.cservice_.getPublicContact(username);
            QueryManager qm = this.getSession(systemSession).getWorkspace().getQueryManager();
            LinkedHashMap<String, String> groups = new LinkedHashMap<String, String>();
            for (String group : contact.getAddressBookIds()) {
                groups.put(group, group);
            }
            groups.put(groupId, groupId);
            contact.setAddressBookIds(groups.keySet().toArray(new String[0]));
            this.cservice_.saveContact(username, contact, false);
            StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contactGroup)[@exo:viewPermissionGroups='").append(groupId + "']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator nodes = result.getNodes();
            List<String> to = Arrays.asList(username);
            while (nodes.hasNext()) {
                Node address = nodes.nextNode();
                String from = address.getProperty("exo:sharedUserId").getString();
                String addressBookId = address.getProperty("exo:id").getString();
                storage_.shareAddressBook(from, addressBookId, to);
            }
            queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:viewPermissionGroups='").append(groupId + "']");
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            nodes = result.getNodes();
            while (nodes.hasNext()) {
                Node contactNode = nodes.nextNode();
                String split = "/";
                String temp = contactNode.getPath().split(usersPath)[1];
                String userId = temp.split(split)[1];
                String[] addressBookIds = new String[]{contactNode.getProperty("exo:id").getString()};
                storage_.shareContact(userId, addressBookIds, to);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception in method postSave", (Throwable)e);
            }
        }
        finally {
            systemSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDelete(Membership m) throws Exception {
        Contact contact = this.cservice_.getPublicContact(m.getUserName());
        LinkedHashMap<String, String> groupIds = new LinkedHashMap<String, String>();
        for (String group : contact.getAddressBookIds()) {
            groupIds.put(group, group);
        }
        groupIds.remove(m.getGroupId());
        contact.setAddressBookIds(groupIds.keySet().toArray(new String[0]));
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        try {
            this.cservice_.saveContact(m.getUserName(), contact, false);
            JCRDataStorage storage_ = new JCRDataStorage(this.nodeHierarchyCreator_, this.reposervice_);
            String usersPath = this.nodeHierarchyCreator_.getJcrPath(DataStorage.USERS_PATH);
            QueryManager qm = this.getSession(systemSession).getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contactGroup)[@exo:viewPermissionGroups='").append(m.getGroupId() + "']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator nodes = result.getNodes();
            while (nodes.hasNext()) {
                Node address = nodes.nextNode();
                storage_.unshareAddressBook(address.getProperty("exo:sharedUserId").getString(), address.getProperty("exo:id").getString(), m.getUserName());
                for (Value groupShared : address.getProperty("exo:viewPermissionGroups").getValues()) {
                    if (!groupIds.keySet().contains(groupShared.getString())) continue;
                    ArrayList<String> reciever = new ArrayList<String>();
                    reciever.add(m.getUserName());
                    storage_.shareAddressBook(address.getProperty("exo:sharedUserId").getString(), address.getProperty("exo:id").getString(), reciever);
                }
            }
            queryString = new StringBuffer("/jcr:root" + usersPath + "//element(*,exo:contact)[@exo:viewPermissionGroups='").append(m.getGroupId() + "']");
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            nodes = result.getNodes();
            while (nodes.hasNext()) {
                Node contactNode = nodes.nextNode();
                String split = "/";
                String temp = contactNode.getPath().split(usersPath)[1];
                String userId = temp.split(split)[1];
                storage_.removeUserShareContact(userId, contactNode.getProperty("exo:id").getString(), m.getUserName());
                for (Value groupShared : contactNode.getProperty("exo:viewPermissionGroups").getValues()) {
                    if (!groupIds.keySet().contains(groupShared.getString())) continue;
                    ArrayList<String> reciever = new ArrayList<String>();
                    reciever.add(m.getUserName());
                    storage_.shareContact(userId, new String[]{contactNode.getProperty("exo:id").getString()}, reciever);
                }
            }
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception in method preDelete", (Throwable)ex);
            }
        }
        finally {
            systemSession.close();
        }
    }

    private Session getSession(SessionProvider sprovider) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository currentRepo = repositoryService.getCurrentRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }
}

