/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.commands.DataCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.EvictCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.base.CommandInterceptor;

public class EvictionInterceptor
extends CommandInterceptor {
    protected RegionManager regionManager;
    private DataContainer dataContainer;

    @Inject
    public void initialize(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Inject
    void setRegionManager(RegionManager regionManager) {
        this.regionManager = regionManager;
    }

    public Object visitEvictFqnCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        Region r;
        boolean nodeIsNowAbsent;
        Fqn fqn = command.getFqn();
        Object retVal = this.invokeNextInterceptor(ctx, command);
        boolean bl = nodeIsNowAbsent = retVal != null && (Boolean)retVal != false;
        if (!nodeIsNowAbsent && fqn != null && (r = this.getRegion(fqn)) != null) {
            this.registerEvictionEventToRegionManager(fqn, EvictionEvent.Type.ADD_NODE_EVENT, 0, r, null, null);
        }
        return retVal;
    }

    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.visitPutKeyValueCommand(ctx, command);
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Region r;
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (command.getFqn() != null && command.getKey() != null && (r = this.getRegion(command.getFqn())) != null) {
            boolean isTransactional;
            boolean bl = isTransactional = ctx.getTransactionContext() != null;
            if (isTransactional) {
                this.registerEvictionEventToRegionManager(command.getFqn(), EvictionEvent.Type.ADD_ELEMENT_EVENT, 1, r, command, ctx.getTransactionContext().getTransaction());
            } else {
                this.registerEvictionEventToRegionManager(command.getFqn(), EvictionEvent.Type.ADD_ELEMENT_EVENT, 1, r, null, null);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        Region r;
        Object retVal = this.invokeNextInterceptor(ctx, command);
        Fqn fqn = command.getFqn();
        if (fqn != null && (r = this.getRegion(fqn)) != null) {
            if (command.getData() == null) {
                if (this.trace) {
                    this.log.trace((Object)("Putting null data under fqn " + fqn + "."));
                }
            } else {
                boolean isTransactional;
                int size;
                Map map = command.getData();
                synchronized (map) {
                    size = command.getData().size();
                }
                boolean bl = isTransactional = ctx.getTransactionContext() != null;
                if (isTransactional) {
                    this.registerEvictionEventToRegionManager(fqn, EvictionEvent.Type.ADD_NODE_EVENT, size, r, command, ctx.getTransactionContext().getTransaction());
                } else {
                    this.registerEvictionEventToRegionManager(fqn, EvictionEvent.Type.ADD_NODE_EVENT, size, r, null, null);
                }
            }
        }
        return retVal;
    }

    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (retVal == null) {
            if (this.trace) {
                this.log.trace((Object)"No event added. Element does not exist");
            }
        } else {
            Region r;
            Fqn fqn = command.getFqn();
            if (fqn != null && command.getKey() != null && (r = this.getRegion(fqn)) != null) {
                this.registerEvictionEventToRegionManager(fqn, EvictionEvent.Type.REMOVE_ELEMENT_EVENT, 1, r, null, null);
            }
        }
        return retVal;
    }

    public Object visitGetNodeCommand(InvocationContext ctx, GetNodeCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.handleGetNodeOrDataCommands(retVal, command.getFqn());
    }

    private Object handleGetNodeOrDataCommands(Object retVal, Fqn fqn) {
        Region r;
        if (retVal == null) {
            if (this.trace) {
                this.log.trace((Object)"No event added. Node does not exist");
            }
        } else if (fqn != null && (r = this.getRegion(fqn)) != null) {
            this.registerEvictionEventToRegionManager(fqn, EvictionEvent.Type.VISIT_NODE_EVENT, 0, r, null, null);
        }
        return retVal;
    }

    public Object visitGetDataMapCommand(InvocationContext ctx, GetDataMapCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.handleGetNodeOrDataCommands(retVal, command.getFqn());
    }

    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Region r;
        Object retVal = this.invokeNextInterceptor(ctx, command);
        Fqn fqn = command.getFqn();
        if (retVal == null) {
            if (this.trace) {
                this.log.trace((Object)"No event added. Element does not exist");
            }
        } else if (fqn != null && command.getKey() != null && (r = this.getRegion(fqn)) != null) {
            this.registerEvictionEventToRegionManager(fqn, EvictionEvent.Type.VISIT_NODE_EVENT, 0, r, null, null);
        }
        return retVal;
    }

    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        Region r;
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (command.getFqn() != null && (r = this.getRegion(command.getFqn())) != null) {
            this.registerEvictionEventToRegionManager(command.getFqn(), EvictionEvent.Type.REMOVE_NODE_EVENT, 0, r, null, null);
        }
        return retVal;
    }

    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        Region r;
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (command.getFqn() != null && (r = this.getRegion(command.getFqn())) != null) {
            this.registerEvictionEventToRegionManager(command.getFqn(), EvictionEvent.Type.REMOVE_NODE_EVENT, 0, r, null, null);
        }
        return retVal;
    }

    private void registerEvictionEventToRegionManager(Fqn fqn, EvictionEvent.Type type, int elementDifference, Region region, DataCommand command, Transaction tx) {
        if (this.dataContainer.isResident(fqn)) {
            if (this.trace) {
                this.log.trace((Object)("Ignoring Fqn " + fqn + " as it is marked as resident"));
            }
            return;
        }
        region.registerEvictionEvent(fqn, type, elementDifference, command, tx);
        if (this.trace) {
            this.log.trace((Object)("Registering event " + (Object)((Object)type) + " on node " + fqn));
        }
    }

    protected Region getRegion(Fqn fqn) {
        return this.regionManager.getRegion(fqn, Region.Type.EVICTION, false);
    }
}

