/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.NonManagedConnectionFactory;

public class C3p0ConnectionFactory
extends NonManagedConnectionFactory {
    private static final Log log = LogFactory.getLog(C3p0ConnectionFactory.class);
    private static final boolean trace = log.isTraceEnabled();
    private PooledDataSource ds;
    private Properties config = new Properties();

    public void setConfig(AdjListJDBCCacheLoaderConfig config) {
        super.setConfig(config);
        this.writeProps(config.getProperties());
        this.writeProps(System.getProperties());
        if (trace) {
            log.trace((Object)("Using props: " + this.config));
        }
    }

    private void writeProps(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String property = (String)e.nextElement();
            if (!property.startsWith("c3p0.")) continue;
            String newName = property.substring("c3p0.".length());
            this.config.put(newName, properties.get(property));
        }
    }

    public void start() throws Exception {
        super.start();
        DataSource unpooled = DataSources.unpooledDataSource((String)this.getUrl(), (String)this.getUsr(), (String)this.getPwd());
        this.ds = (PooledDataSource)DataSources.pooledDataSource((DataSource)unpooled, (Properties)this.config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pooled datasource(url=" + this.getUrl() + ",usr=" + this.getUsr() + ",pwd=" + this.getPwd() + ") started."));
        }
    }

    public Connection checkoutConnection() throws SQLException {
        if (trace) {
            log.trace((Object)("DataSource before checkout (NumBusyConnectionsAllUsers) : " + this.ds.getNumBusyConnectionsAllUsers()));
            log.trace((Object)("DataSource before checkout (NumConnectionsAllUsers) : " + this.ds.getNumConnectionsAllUsers()));
        }
        Connection connection = this.ds.getConnection();
        if (trace) {
            log.trace((Object)("DataSource after checkout (NumBusyConnectionsAllUsers) : " + this.ds.getNumBusyConnectionsAllUsers()));
            log.trace((Object)("DataSource after checkout (NumConnectionsAllUsers) : " + this.ds.getNumConnectionsAllUsers()));
            log.trace((Object)("Connection checked out: " + connection));
        }
        return connection;
    }

    public void stop() {
        try {
            DataSources.destroy((DataSource)this.ds);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Pooled datasource destroyed.");
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)("Could not destroy C3P0 connection pool: " + this.ds), (Throwable)sqle);
        }
    }

    protected DataSource getDataSource() {
        return this.ds;
    }
}

