/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.filter.FilterConfig;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.portlet.container.PortletApplication;
import org.gatein.pc.portlet.container.PortletApplicationContext;
import org.gatein.pc.portlet.container.PortletContainer;
import org.gatein.pc.portlet.container.PortletFilter;
import org.gatein.pc.portlet.container.PortletInitializationException;
import org.gatein.pc.portlet.container.object.PortletApplicationObject;
import org.gatein.pc.portlet.impl.info.ContainerFilterInfo;
import org.gatein.pc.portlet.impl.info.ContainerListenerInfo;
import org.gatein.pc.portlet.impl.info.ContainerPortletApplicationInfo;
import org.gatein.pc.portlet.impl.jsr168.ClassInstanceLifeCycle;
import org.gatein.pc.portlet.impl.jsr168.api.FilterConfigImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletContextImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletURLGenerationListenerChain;

public class PortletApplicationImpl
implements PortletApplicationObject {
    protected final ContainerPortletApplicationInfo info;
    protected final Logger log;
    protected PortletApplicationContext context;
    protected LinkedHashMap<String, PortletContainer> portlets;
    protected PortletContextImpl portletContext;
    protected PortletURLGenerationListener urlListener;

    public PortletApplicationImpl(ContainerPortletApplicationInfo info) {
        this.info = info;
        this.portlets = new LinkedHashMap();
        this.log = LoggerFactory.getLogger((String)(PortletApplication.class.getName() + "." + info.getId().replace('.', '_')));
    }

    @Override
    public void setContext(PortletApplicationContext context) {
        this.context = context;
    }

    @Override
    public String getId() {
        return this.info.getId();
    }

    @Override
    public void addPortletFilter(PortletFilter filter) {
    }

    @Override
    public void removePortletFilter(PortletFilter filter) {
    }

    public ContainerPortletApplicationInfo getInfo() {
        return this.info;
    }

    @Override
    public void addPortletContainer(PortletContainer container) {
        this.portlets.put(container.getId(), container);
    }

    @Override
    public void removePortletContainer(PortletContainer container) {
        this.portlets.remove(container.getId());
    }

    @Override
    public void start() throws Exception {
        PortletContextImpl portletContext = new PortletContextImpl(this.context.getServletContext());
        List listeners = Collections.emptyList();
        for (ContainerListenerInfo listenerInfo : this.info.getListeners()) {
            try {
                String className = listenerInfo.getClassName();
                ClassInstanceLifeCycle<PortletURLGenerationListener> lifeCycle = new ClassInstanceLifeCycle<PortletURLGenerationListener>(this.log, PortletURLGenerationListener.class, this.context.getClassLoader(), className, "listener");
                lifeCycle.create();
                if (listeners.size() == 0) {
                    listeners = new LinkedList();
                }
                listeners.add(lifeCycle.getInstance());
            }
            catch (PortletInitializationException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.portletContext = portletContext;
        this.urlListener = listeners.size() == 0 ? null : new PortletURLGenerationListenerChain(Collections.unmodifiableList(listeners));
    }

    @Override
    public void stop() {
        this.portletContext = null;
        this.urlListener = null;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public <T> T getListener(Class<T> type) {
        if (type == PortletURLGenerationListener.class) {
            return type.cast(this.urlListener);
        }
        return null;
    }

    public Set<PortletContainer> getPortletContainers() {
        return new HashSet<PortletContainer>(this.portlets.values());
    }

    @Override
    public PortletContainer getPortletContainer(String name) {
        return this.portlets.get(name);
    }

    @Override
    public PortletApplicationContext getContext() {
        return this.context;
    }

    public String toString() {
        return "PortletApplication[" + this.getId() + "]";
    }

    static class FilterLifecycle
    extends ClassInstanceLifeCycle<javax.portlet.filter.PortletFilter> {
        private final ContainerFilterInfo info;
        private final PortletContext portletContext;

        FilterLifecycle(Logger log, ClassLoader classLoader, String className, String type, ContainerFilterInfo info, PortletContext portletContext) {
            super(log, javax.portlet.filter.PortletFilter.class, classLoader, className, type);
            this.info = info;
            this.portletContext = portletContext;
        }

        @Override
        public void start(javax.portlet.filter.PortletFilter instance) throws Exception {
            FilterConfigImpl config = new FilterConfigImpl(this.info, this.portletContext);
            instance.init((FilterConfig)config);
        }

        @Override
        public void stop(javax.portlet.filter.PortletFilter instance) {
            instance.destroy();
        }
    }
}

