/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.NullOutputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalParser
implements Parser {
    private Set<MediaType> supportedTypes = Collections.emptySet();
    private String command = "cat";

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.getSupportedTypes();
    }

    public Set<MediaType> getSupportedTypes() {
        return this.supportedTypes;
    }

    public void setSupportedTypes(Set<MediaType> supportedTypes) {
        this.supportedTypes = Collections.unmodifiableSet(new HashSet<MediaType>(supportedTypes));
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        Process process = Runtime.getRuntime().exec(this.command);
        try {
            this.sendInput(process, stream);
            this.ignoreError(process);
            this.extractOutput(process, xhtml);
        }
        finally {
            try {
                process.waitFor();
            }
            catch (InterruptedException ignore) {}
        }
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractOutput(Process process, XHTMLContentHandler xhtml) throws SAXException, IOException {
        InputStreamReader reader = new InputStreamReader(process.getInputStream());
        try {
            xhtml.startDocument();
            xhtml.startElement("p");
            char[] buffer = new char[1024];
            int n = reader.read(buffer);
            while (n != -1) {
                xhtml.characters(buffer, 0, n);
                n = reader.read(buffer);
            }
            xhtml.endElement("p");
            xhtml.endDocument();
        }
        finally {
            ((Reader)reader).close();
        }
    }

    private void sendInput(final Process process, final InputStream stream) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                OutputStream stdin = process.getOutputStream();
                try {
                    IOUtils.copy(stream, stdin);
                }
                catch (IOException iOException) {
                }
                finally {
                    IOUtils.closeQuietly(stdin);
                }
            }
        }.start();
    }

    private void ignoreError(final Process process) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                InputStream error = process.getErrorStream();
                try {
                    IOUtils.copy(error, (OutputStream)new NullOutputStream());
                }
                catch (IOException iOException) {
                }
                finally {
                    IOUtils.closeQuietly(error);
                }
            }
        }.start();
    }
}

