/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.core;

import java.util.Hashtable;
import javax.management.ObjectName;
import org.apache.jk.core.JkHandler;

public class WorkerEnv {
    Hashtable properties;
    public static final int ENDPOINT_NOTE = 0;
    public static final int REQUEST_NOTE = 1;
    public static final int SSL_CERT_NOTE = 16;
    int[] noteId = new int[4];
    String[][] noteName = new String[4][];
    private Object[] notes = new Object[32];
    Hashtable handlersMap = new Hashtable();
    JkHandler[] handlersTable = new JkHandler[20];
    int handlerCount = 0;
    String home;
    int localId = 0;

    public WorkerEnv() {
        for (int i = 0; i < this.noteId.length; ++i) {
            this.noteId[i] = 7;
            this.noteName[i] = new String[20];
        }
    }

    public void setLocalId(int id) {
        this.localId = id;
    }

    public int getLocalId() {
        return this.localId;
    }

    public void setJkHome(String s) {
        this.home = s;
    }

    public String getJkHome() {
        return this.home;
    }

    public final Object getNote(int i) {
        return this.notes[i];
    }

    public final void setNote(int i, Object o) {
        this.notes[i] = o;
    }

    public int getNoteId(int type, String name) {
        for (int i = 0; i < this.noteId[type]; ++i) {
            if (!name.equals(this.noteName[type][i])) continue;
            return i;
        }
        int n = type;
        int n2 = this.noteId[n];
        this.noteId[n] = n2 + 1;
        int id = n2;
        this.noteName[type][id] = name;
        return id;
    }

    public void addHandler(String name, JkHandler w) {
        JkHandler oldH = this.getHandler(name);
        if (oldH == w) {
            return;
        }
        w.setWorkerEnv(this);
        w.setName(name);
        this.handlersMap.put(name, w);
        if (this.handlerCount > this.handlersTable.length) {
            JkHandler[] newT = new JkHandler[2 * this.handlersTable.length];
            System.arraycopy(this.handlersTable, 0, newT, 0, this.handlersTable.length);
            this.handlersTable = newT;
        }
        if (oldH == null) {
            this.handlersTable[this.handlerCount] = w;
            w.setId(this.handlerCount);
            ++this.handlerCount;
        } else {
            this.handlersTable[oldH.getId()] = w;
            w.setId(oldH.getId());
        }
        for (int i = 0; i < this.handlerCount; ++i) {
            this.handlersTable[i].addHandlerCallback(w);
        }
    }

    public final JkHandler getHandler(String name) {
        return (JkHandler)this.handlersMap.get(name);
    }

    public final JkHandler getHandler(int id) {
        return this.handlersTable[id];
    }

    public final int getHandlerCount() {
        return this.handlerCount;
    }

    public ObjectName[] getHandlersObjectName() {
        ObjectName[] onames = new ObjectName[this.handlerCount];
        for (int i = 0; i < this.handlerCount; ++i) {
            onames[i] = this.handlersTable[i].getObjectName();
        }
        return onames;
    }
}

