/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

@Serialized
public class UsernameValidator
implements Validator {
    private Integer min = 3;
    private Integer max = 30;

    public UsernameValidator(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        if (uiInput.getValue() == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        UIComponent uiComponent = (UIComponent)uiInput;
        UIForm uiForm = (UIForm)uiComponent.getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getId() + ".label." + uiInput.getName();
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        char[] buff = ((String)uiInput.getValue()).toCharArray();
        if (buff.length < this.min || buff.length > this.max) {
            Object[] args = new Object[]{label, this.min.toString(), this.max.toString()};
            throw new MessageException(new ApplicationMessage("StringLengthValidator.msg.length-invalid", args, 1));
        }
        if (!this.isAlphabet(buff[0])) {
            Object[] args = new Object[]{label};
            throw new MessageException(new ApplicationMessage("FirstCharacterNameValidator.msg", args, 1));
        }
        if (!this.isAlphabetOrDigit(buff[buff.length - 1])) {
            Object[] args = new Object[]{label, Character.valueOf(buff[buff.length - 1])};
            throw new MessageException(new ApplicationMessage("LastCharacterUsernameValidator.msg", args, 1));
        }
        for (int i = 1; i < buff.length - 1; ++i) {
            char c = buff[i];
            if (this.isAlphabetOrDigit(c)) continue;
            if (this.isSymbol(c)) {
                char next = buff[i + 1];
                if (this.isSymbol(next)) {
                    Object[] args = new Object[]{label, Character.valueOf(buff[i]), Character.valueOf(buff[i + 1])};
                    throw new MessageException(new ApplicationMessage("ConsecutiveSymbolValidator.msg", args, 1));
                }
                if (this.isAlphabetOrDigit(next)) continue;
                Object[] args = new Object[]{label};
                throw new MessageException(new ApplicationMessage("UsernameValidator.msg.Invalid-char", args, 1));
            }
            Object[] args = new Object[]{label};
            throw new MessageException(new ApplicationMessage("UsernameValidator.msg.Invalid-char", args, 1));
        }
    }

    private boolean isAlphabet(char c) {
        return c >= 'a' && c <= 'z';
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isSymbol(char c) {
        return c == '_' || c == '.';
    }

    private boolean isAlphabetOrDigit(char c) {
        return this.isAlphabet(c) || this.isDigit(c);
    }
}

