/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import com.google.common.base.Preconditions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashUtil {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    private HashUtil() {
    }

    public static String checksum(byte[] data) {
        byte[] hashBytes = HashUtil.getMessageDigest().digest((byte[])Preconditions.checkNotNull((Object)data));
        char[] hex = new char[2 * hashBytes.length];
        int offset = 0;
        for (byte b : hashBytes) {
            hex[offset++] = HEX_CHARS[(b & 0xF0) >>> 4];
            hex[offset++] = HEX_CHARS[b & 0xF];
        }
        return new String(hex);
    }

    public static String rawChecksum(byte[] data) {
        return new String(HashUtil.getMessageDigest().digest((byte[])Preconditions.checkNotNull((Object)data)));
    }

    private static MessageDigest getMessageDigest() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noMD5) {
            try {
                md = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSha) {
                throw new RuntimeException("No suitable MessageDigest found!", noSha);
            }
        }
        return md;
    }
}

