/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.config.ConfigContributor;
import org.apache.shindig.gadgets.config.CoreUtilConfigContributor;
import org.apache.shindig.gadgets.config.OsapiServicesConfigContributor;
import org.apache.shindig.gadgets.config.ShindigAuthConfigContributor;
import org.apache.shindig.gadgets.config.XhrwrapperConfigContributor;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.InvalidationHandler;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.preload.PreloadModule;
import org.apache.shindig.gadgets.render.RenderModule;
import org.apache.shindig.gadgets.rewrite.RewriteModule;
import org.apache.shindig.gadgets.servlet.GadgetsHandler;
import org.apache.shindig.gadgets.servlet.HttpRequestHandler;
import org.apache.shindig.gadgets.templates.TemplateModule;
import org.apache.shindig.gadgets.uri.UriModule;
import org.apache.shindig.gadgets.variables.SubstituterModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGuiceModule
extends AbstractModule {
    public static final ThreadFactory DAEMON_THREAD_FACTORY = new ThreadFactory(){
        private final ThreadFactory factory = Executors.defaultThreadFactory();

        public Thread newThread(Runnable r) {
            Thread t = this.factory.newThread(r);
            t.setDaemon(true);
            return t;
        }
    };

    protected void configure() {
        final ExecutorService service = Executors.newCachedThreadPool(DAEMON_THREAD_FACTORY);
        this.bind(ExecutorService.class).toInstance((Object)service);
        this.bind(ExecutorService.class).annotatedWith((Annotation)Names.named((String)"shindig.concat.executor")).toInstance((Object)service);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                service.shutdownNow();
            }
        });
        this.install((Module)new ParseModule());
        this.install((Module)new PreloadModule());
        this.install((Module)new RenderModule());
        this.install((Module)new RewriteModule());
        this.install((Module)new SubstituterModule());
        this.install((Module)new TemplateModule());
        this.install((Module)new UriModule());
        this.requestStaticInjection(new Class[]{HttpResponse.class});
        this.registerGadgetHandlers();
        this.registerConfigContributors();
        this.registerFeatureHandlers();
    }

    protected void registerGadgetHandlers() {
        Multibinder handlerBinder = Multibinder.newSetBinder((Binder)this.binder(), Object.class, (Annotation)Names.named((String)"org.apache.shindig.handlers"));
        handlerBinder.addBinding().to(InvalidationHandler.class);
        handlerBinder.addBinding().to(HttpRequestHandler.class);
        handlerBinder.addBinding().to(GadgetsHandler.class);
    }

    protected void registerConfigContributors() {
        MapBinder configBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, ConfigContributor.class);
        configBinder.addBinding((Object)"core.util").to(CoreUtilConfigContributor.class);
        configBinder.addBinding((Object)"osapi").to(OsapiServicesConfigContributor.class);
        configBinder.addBinding((Object)"shindig.auth").to(ShindigAuthConfigContributor.class);
        configBinder.addBinding((Object)"shindig.xhrwrapper").to(XhrwrapperConfigContributor.class);
    }

    protected void registerFeatureHandlers() {
        Multibinder.newSetBinder((Binder)this.binder(), String.class, (Annotation)Names.named((String)"org.apache.shindig.features-extended"));
    }

    @Provides
    @Singleton
    @Named(value="org.apache.shindig.features")
    protected List<String> defaultFeatures(@Named(value="shindig.features.default") String features, @Named(value="org.apache.shindig.features-extended") Set<String> extended) {
        return ImmutableList.builder().addAll(extended).add((Object[])StringUtils.split((String)features, (char)',')).build();
    }
}

