/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.ancillary.linter.ErrorReporter;
import com.google.caja.ancillary.linter.FileContent;
import com.google.caja.ancillary.linter.LexicalScope;
import com.google.caja.ancillary.linter.LinterMessageType;
import com.google.caja.ancillary.linter.LiveSet;
import com.google.caja.ancillary.linter.NodeBuckets;
import com.google.caja.ancillary.linter.ScopeAnalyzer;
import com.google.caja.ancillary.linter.SymbolTable;
import com.google.caja.ancillary.linter.VariableLiveness;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParserBase;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.BreakStmt;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.ContinueStmt;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.ForEachLoop;
import com.google.caja.parser.js.ForLoop;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.LabeledStatement;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.Loop;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.OperatorCategory;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.ThrowStmt;
import com.google.caja.parser.js.WithStmt;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.tools.BuildCommand;
import com.google.caja.util.Charsets;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Linter
implements BuildCommand {
    private final Environment env;
    private final Set<String> ignores;
    public static final Environment BROWSER_ENVIRONMENT = new Environment(Sets.newLinkedHashSet("window", "document", "setTimeout", "setInterval", "location", "XMLHttpRequest", "clearInterval", "clearTimeout", "navigator", "event", "alert", "confirm", "prompt", "this", "JSON"));

    public Linter() {
        this(new Environment(Sets.<String>newHashSet()), Collections.emptySet());
    }

    public Linter(Environment env, Set<String> ignores) {
        this.env = env;
        this.ignores = ignores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean build(List<File> inputs, List<File> dependencies, File output) throws IOException {
        boolean result;
        MessageContext mc = new MessageContext();
        Map<InputSource, CharSequence> contentMap = Maps.newLinkedHashMap();
        SimpleMessageQueue mq = new SimpleMessageQueue();
        List<LintJob> lintJobs = Linter.parseInputs(inputs, contentMap, mc, mq);
        Linter.lint(lintJobs, this.env, mq);
        if (!this.ignores.isEmpty()) {
            Iterator<Message> it = mq.getMessages().iterator();
            while (it.hasNext()) {
                if (!this.ignores.contains(it.next().getMessageType().name())) continue;
                it.remove();
            }
        }
        if (output.getName().endsWith(".stamp") || output.getName().endsWith(".tstamp")) {
            if (ErrorReporter.reportErrors(contentMap, mc, mq, System.out).compareTo(MessageLevel.WARNING) < 0) {
                new FileOutputStream(output).close();
                return true;
            }
            return false;
        }
        OutputStreamWriter reportOut = new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charsets.UTF_8);
        try {
            result = ErrorReporter.reportErrors(contentMap, mc, mq, reportOut).compareTo(MessageLevel.WARNING) < 0;
        }
        finally {
            try {
                ((Writer)reportOut).close();
            }
            catch (IOException ex) {
                result = false;
            }
        }
        return result;
    }

    private static List<LintJob> parseInputs(List<File> inputs, Map<InputSource, CharSequence> contents, MessageContext mc, MessageQueue mq) throws IOException {
        List<LintJob> compUnits = Lists.newArrayList();
        for (File inp : inputs) {
            InputSource src = new InputSource(inp.toURI());
            mc.addInputSource(src);
            CharProducer cp = CharProducer.Factory.create((Reader)new InputStreamReader((InputStream)new FileInputStream(inp), "UTF-8"), src);
            contents.put(src, new FileContent(cp));
            JsTokenQueue tq = new JsTokenQueue(new JsLexer(cp), src);
            try {
                if (tq.isEmpty()) continue;
                Parser p = new Parser(tq, mq);
                compUnits.add(Linter.makeLintJob(p.parse(), mq));
            }
            catch (ParseException ex) {
                ex.toMessageQueue(mq);
            }
        }
        return compUnits;
    }

    public static LintJob makeLintJob(Block program, MessageQueue mq) {
        InputSource src = program.getFilePosition().source();
        List<Token<?>> tokens = program.getComments();
        return new LintJob(src, Linter.parseIdentifierListFromComment("requires", tokens, mq), Linter.parseIdentifierListFromComment("provides", tokens, mq), Linter.parseIdentifierListFromComment("overrides", tokens, mq), program);
    }

    public static void lint(List<LintJob> jobs, Environment env, MessageQueue mq) {
        for (LintJob job : jobs) {
            Linter.lint(AncestorChain.instance(job.program), env, job.provides, job.requires, job.overrides, mq);
        }
        Map<String, InputSource> providedBy = Maps.newHashMap();
        for (LintJob job : jobs) {
            for (String symbolName : job.provides) {
                InputSource originallyDefinedIn = providedBy.put(symbolName, job.src);
                if (originallyDefinedIn == null) continue;
                mq.addMessage((MessageTypeInt)LinterMessageType.MULTIPLY_PROVIDED_SYMBOL, job.src, originallyDefinedIn, MessagePart.Factory.valueOf(symbolName));
            }
        }
    }

    private static void lint(AncestorChain<?> ac, final Environment env, Set<String> provides, final Set<String> requires, final Set<String> overrides, MessageQueue mq) {
        ScopeAnalyzer sa = new ScopeAnalyzer(){

            @Override
            protected boolean introducesScope(AncestorChain<?> ac) {
                if (super.introducesScope(ac)) {
                    return true;
                }
                return this.isLoopy(ac);
            }

            @Override
            protected void initScope(LexicalScope scope) {
                super.initScope(scope);
                if (scope.isFunctionScope()) {
                    FunctionConstructor fc = (FunctionConstructor)scope.root.cast(FunctionConstructor.class).node;
                    if (fc.getIdentifierName() != null && scope.root.parent != null && !(scope.root.parent.node instanceof FunctionDeclaration)) {
                        LexicalScope containing = scope.parent;
                        while (containing.parent != null && (this.hoist(scope.root, containing) || this.isLoopy(containing.root))) {
                            containing = containing.parent;
                        }
                        containing.symbols.declare(fc.getIdentifierName(), scope.root);
                    }
                } else if (scope.isGlobal()) {
                    for (String symbolName : Sets.union(env.outers, Sets.union(requires, overrides))) {
                        if (scope.symbols.getSymbol(symbolName) != null) continue;
                        scope.symbols.declare(symbolName, scope.root);
                    }
                }
            }

            boolean isLoopy(AncestorChain<?> ac) {
                Object node = ac.node;
                return node instanceof ForEachLoop || node instanceof Loop;
            }
        };
        List<LexicalScope> scopes = sa.computeLexicalScopes(ac);
        LexicalScope globalScope = scopes.get(0);
        VariableLiveness.LiveCalc lc = VariableLiveness.calculateLiveness(ac.node);
        NodeBuckets buckets = NodeBuckets.maker().with(ExpressionStmt.class).with(LabeledStatement.class).under(globalScope.root);
        Linter.checkDeclarations(scopes, overrides, mq);
        Linter.checkLabels(lc, buckets, mq);
        Linter.checkUses(scopes, lc.vars, sa, provides, requires, overrides, mq);
        Linter.checkSideEffects(buckets, mq);
        Linter.checkDeadCode(buckets, mq);
    }

    private static void checkDeclarations(List<LexicalScope> scopes, Set<String> overrides, MessageQueue mq) {
        for (LexicalScope scope : scopes) {
            block1: for (String symbolName : scope.symbols.symbolNames()) {
                Collection<AncestorChain<?>> declarations = scope.symbols.getSymbol(symbolName).getDeclarations();
                if (declarations.size() != 1) {
                    Iterator<AncestorChain<?>> it = declarations.iterator();
                    AncestorChain<?> original = it.next();
                    if (!scope.isGlobal() || !overrides.contains(symbolName)) {
                        while (it.hasNext()) {
                            AncestorChain<?> redefinition = it.next();
                            mq.addMessage((MessageTypeInt)MessageType.SYMBOL_REDEFINED, redefinition.node.getFilePosition(), MessagePart.Factory.valueOf(symbolName), original.node.getFilePosition());
                        }
                    }
                }
                if (scope.isFunctionScope()) continue;
                LexicalScope p = scope;
                while ((p = p.parent) != null) {
                    SymbolTable.Symbol masked = p.symbols.getSymbol(symbolName);
                    if (masked != null) {
                        AncestorChain<?> firstMasked = masked.getDeclarations().iterator().next();
                        mq.addMessage((MessageTypeInt)MessageType.MASKING_SYMBOL, scope.isCatchScope() ? MessageLevel.WARNING : MessageLevel.ERROR, declarations.iterator().next().node.getFilePosition(), MessagePart.Factory.valueOf(symbolName), firstMasked.node.getFilePosition());
                    }
                    if (!p.isFunctionScope()) continue;
                    continue block1;
                }
            }
        }
    }

    private static void checkLabels(VariableLiveness.LiveCalc lc, NodeBuckets buckets, MessageQueue mq) {
        String label;
        for (Statement statement : lc.exits.liveExits()) {
            if (statement instanceof BreakStmt || statement instanceof ContinueStmt) {
                label = (String)statement.getValue();
                if ("".equals(label)) {
                    label = "<default>";
                }
                mq.addMessage((MessageTypeInt)LinterMessageType.LABEL_DOES_NOT_MATCH_LOOP, statement.getFilePosition(), MessagePart.Factory.valueOf(label));
                continue;
            }
            if (statement instanceof ReturnStmt) {
                mq.addMessage((MessageTypeInt)LinterMessageType.RETURN_OUTSIDE_FUNCTION, statement.getFilePosition());
                continue;
            }
            if (!(statement instanceof ThrowStmt)) continue;
            mq.addMessage((MessageTypeInt)LinterMessageType.UNCAUGHT_THROW_DURING_INIT, statement.getFilePosition());
        }
        block1: for (AncestorChain<? extends ParseTreeNode> ancestorChain : buckets.get(LabeledStatement.class)) {
            label = ((LabeledStatement)ancestorChain.node).getLabel();
            if ("".equals(label)) continue;
            AncestorChain<? extends ParseTreeNode> p = ancestorChain;
            while ((p = p.parent) != null) {
                if (!(p.node instanceof LabeledStatement) || !label.equals(((LabeledStatement)p.cast(LabeledStatement.class).node).getLabel())) continue;
                mq.addMessage((MessageTypeInt)LinterMessageType.DUPLICATE_LABEL, ((LabeledStatement)ancestorChain.node).getFilePosition(), MessagePart.Factory.valueOf(label), p.node.getFilePosition());
                continue block1;
            }
        }
    }

    private static void checkUses(List<LexicalScope> scopes, LiveSet liveAtEnd, ScopeAnalyzer sa, Set<String> provides, Set<String> requires, Set<String> overrides, MessageQueue mq) {
        AncestorChain<?> root;
        LexicalScope globalScope = scopes.get(0);
        Map<Pair<LexicalScope, String>, LexicalScope> banned = Maps.newHashMap();
        for (LexicalScope scope : scopes) {
            if (scope.isFunctionScope() || scope.isCatchScope() || scope.isWithScope()) continue;
            LexicalScope p = scope;
            while (!p.isFunctionScope() && (p = p.parent) != null) {
                for (String symbolName : scope.symbols.symbolNames()) {
                    Pair<LexicalScope, String> symbol = Pair.pair(p, symbolName);
                    if (banned.containsKey(symbol) || p.symbols.getSymbol(symbolName) != null) continue;
                    banned.put(symbol, scope);
                }
            }
        }
        Set<String> undeclaredGlobals = Sets.newHashSet();
        Map<String, ScopeAnalyzer.Use> globalsRead = Maps.newHashMap();
        Map globalsSet = Maps.newHashMap();
        Map globalsModified = Maps.newHashMap();
        for (ScopeAnalyzer.Use use : sa.getUses(globalScope.root)) {
            LiveSet liveAtUse;
            boolean usedInSameProgramUnitAsDeclared;
            String symbolName = use.getSymbolName();
            LexicalScope cscope = ScopeAnalyzer.containingScopeForNode(use.ref.node);
            LexicalScope subScopeOrigin = (LexicalScope)banned.get(Pair.pair(cscope, symbolName));
            if (subScopeOrigin != null) {
                AncestorChain<?> firstDecl = subScopeOrigin.symbols.getSymbol(symbolName).getDeclarations().iterator().next();
                mq.addMessage((MessageTypeInt)LinterMessageType.OUT_OF_BLOCK_SCOPE, ((Reference)use.ref.node).getFilePosition(), MessagePart.Factory.valueOf(symbolName), firstDecl.node.getFilePosition());
                continue;
            }
            LexicalScope dscope = cscope.declaringScope(symbolName);
            boolean bl = usedInSameProgramUnitAsDeclared = dscope != null && dscope.inSameProgramUnit(cscope);
            if (dscope == null) {
                if (undeclaredGlobals.contains(symbolName)) continue;
                mq.addMessage((MessageTypeInt)MessageType.UNDEFINED_SYMBOL, ((Reference)use.ref.node).getFilePosition(), MessagePart.Factory.valueOf(symbolName));
                undeclaredGlobals.add(symbolName);
                continue;
            }
            if (dscope.isGlobal()) {
                Map<String, ScopeAnalyzer.Use> m;
                Map<String, ScopeAnalyzer.Use> map = !use.isLeftHandSideExpression() ? globalsRead : (m = use.isMemberAccess() ? globalsModified : globalsSet);
                if (!m.containsKey(symbolName)) {
                    m.put(symbolName, use);
                }
            }
            if (!usedInSameProgramUnitAsDeclared || use.isLeftHandSideExpression() && !use.isMemberAccess() || use.ref.parent.node instanceof ExpressionStmt && Linter.isForEachLoopKey(use.ref.parent.cast(ExpressionStmt.class)) || (liveAtUse = VariableLiveness.livenessFor(use.ref.node)) == null || liveAtUse.symbols.contains(Pair.pair(symbolName, dscope))) continue;
            mq.addMessage((MessageTypeInt)LinterMessageType.SYMBOL_NOT_LIVE, ((Reference)use.ref.node).getFilePosition(), MessagePart.Factory.valueOf(symbolName));
        }
        Linter.checkGlobalsDefined(globalScope, globalScope, Sets.union(provides, overrides), mq);
        for (String symbolName : Sets.difference(globalsSet.keySet(), Sets.union(provides, overrides))) {
            mq.addMessage((MessageTypeInt)MessageType.INVALID_ASSIGNMENT, ((Reference)((ScopeAnalyzer.Use)globalsSet.get((Object)symbolName)).ref.node).getFilePosition(), MessagePart.Factory.valueOf(symbolName));
        }
        for (String symbolName : Sets.difference(globalsModified.keySet(), Sets.union(provides, overrides))) {
            ScopeAnalyzer.Use use = (ScopeAnalyzer.Use)globalsModified.get(symbolName);
            mq.addMessage((MessageTypeInt)MessageType.INVALID_ASSIGNMENT, ((Reference)use.ref.node).getFilePosition(), MessagePart.Factory.valueOf(Linter.render(use.ref.parent.node)));
        }
        for (String symbolName : Sets.difference(requires, globalsRead.keySet())) {
            root = globalScope.root;
            mq.addMessage((MessageTypeInt)LinterMessageType.UNUSED_REQUIRE, root.node.getFilePosition().source(), MessagePart.Factory.valueOf(symbolName));
        }
        for (String symbolName : provides) {
            if (liveAtEnd.symbols.contains(Pair.pair(symbolName, globalScope))) continue;
            root = globalScope.root;
            mq.addMessage((MessageTypeInt)LinterMessageType.UNUSED_PROVIDE, root.node.getFilePosition().source(), MessagePart.Factory.valueOf(symbolName));
        }
    }

    private static void checkSideEffects(NodeBuckets buckets, MessageQueue mq) {
        for (AncestorChain<ExpressionStmt> es : buckets.get(ExpressionStmt.class)) {
            if (!Linter.shouldBeEvaluatedForValue(((ExpressionStmt)es.node).getExpression()) || Linter.isCommaOperatorInForLoop(es) || Linter.isForEachLoopKey(es)) continue;
            mq.addMessage((MessageTypeInt)MessageType.NO_SIDE_EFFECT, ((ExpressionStmt)es.node).getFilePosition());
        }
    }

    private static void checkDeadCode(NodeBuckets buckets, MessageQueue mq) {
        for (AncestorChain<ExpressionStmt> es : buckets.get(ExpressionStmt.class)) {
            if (VariableLiveness.livenessFor(es.node) != null) continue;
            boolean isAnalyzable = true;
            AncestorChain<ParseTreeNode> p = es;
            while (p != null) {
                if (p.node instanceof WithStmt) {
                    isAnalyzable = false;
                    break;
                }
                p = p.parent;
            }
            if (!isAnalyzable) continue;
            mq.addMessage((MessageTypeInt)LinterMessageType.CODE_NOT_REACHABLE, ((ExpressionStmt)es.node).getFilePosition());
        }
    }

    private static String render(ParseTreeNode node) {
        StringBuilder sb = new StringBuilder();
        TokenConsumer tc = node.makeRenderer(sb, null);
        node.render(new RenderContext(tc).withAsciiOnly(true).withEmbeddable(true));
        tc.noMoreTokens();
        return sb.toString();
    }

    private static final Set<String> parseIdentifierListFromComment(String annotationName, List<Token<?>> comments, MessageQueue mq) {
        Set<String> idents = Sets.newLinkedHashSet();
        for (Token<?> comment : comments) {
            String body = comment.text.replaceAll("\\*+/$", "").replaceAll("[\r\n]+[ \t]*\\*+[ \t]?", " ");
            String annotPrefix = "@" + annotationName;
            int annotStart = -1;
            while ((annotStart = body.indexOf(annotPrefix, annotStart + 1)) >= 0) {
                String annotBody;
                int annotBodyStart = annotStart + annotPrefix.length();
                int annotBodyEnd = body.indexOf(64, annotBodyStart);
                if (annotBodyEnd < 0) {
                    annotBodyEnd = body.length();
                }
                if ("".equals(annotBody = body.substring(annotBodyStart, annotBodyEnd).trim())) continue;
                for (String ident : annotBody.split("[\\s,]+")) {
                    if (!ParserBase.isJavascriptIdentifier(ident)) {
                        mq.addMessage((MessageTypeInt)MessageType.INVALID_IDENTIFIER, comment.pos, MessagePart.Factory.valueOf(ident));
                        continue;
                    }
                    idents.add(ident);
                }
            }
        }
        return Collections.unmodifiableSet(idents);
    }

    private static boolean shouldBeEvaluatedForValue(Expression e) {
        if (e instanceof Reference || e instanceof Literal || e instanceof ArrayConstructor || e instanceof ObjectConstructor || e instanceof FunctionConstructor) {
            return true;
        }
        if (!(e instanceof Operation)) {
            return false;
        }
        Operation op = (Operation)e;
        switch (op.getOperator()) {
            case ASSIGN: 
            case DELETE: 
            case POST_DECREMENT: 
            case POST_INCREMENT: 
            case PRE_DECREMENT: 
            case PRE_INCREMENT: 
            case VOID: {
                return false;
            }
            case FUNCTION_CALL: {
                Expression left = op.children().get(0);
                return left instanceof Operation && Operator.CONSTRUCTOR == ((Operation)left).getOperator();
            }
            case LOGICAL_AND: 
            case LOGICAL_OR: {
                return Linter.shouldBeEvaluatedForValue(op.children().get(1));
            }
            case TERNARY: {
                return Linter.shouldBeEvaluatedForValue(op.children().get(1)) && Linter.shouldBeEvaluatedForValue(op.children().get(2));
            }
        }
        return op.getOperator().getCategory() != OperatorCategory.ASSIGNMENT;
    }

    private static boolean isCommaOperatorInForLoop(AncestorChain<ExpressionStmt> es) {
        if (es.parent == null || !(es.parent.node instanceof ForLoop)) {
            return false;
        }
        Expression e = ((ExpressionStmt)es.node).getExpression();
        return Linter.isCommaOperationNotEvaluatedForValue(e);
    }

    private static boolean isForEachLoopKey(AncestorChain<ExpressionStmt> es) {
        if (es.parent == null || !(es.parent.node instanceof ForEachLoop)) {
            return false;
        }
        return ((ForEachLoop)es.parent.cast(ForEachLoop.class).node).getKeyReceiver() == es.node;
    }

    private static boolean isCommaOperationNotEvaluatedForValue(Expression e) {
        if (!(e instanceof Operation)) {
            return false;
        }
        Operation op = (Operation)e;
        if (op.getOperator() != Operator.COMMA) {
            return false;
        }
        Expression left = op.children().get(0);
        Expression right = op.children().get(1);
        return !Linter.shouldBeEvaluatedForValue(right) && (!Linter.shouldBeEvaluatedForValue(left) || Linter.isCommaOperationNotEvaluatedForValue(left));
    }

    public static void main(String[] args) throws IOException {
        ListIterator<String> argIt = Arrays.asList(args).listIterator();
        List<File> inputs = Lists.newArrayList();
        String outDir = null;
        Set<String> outers = Sets.newLinkedHashSet(Linter.BROWSER_ENVIRONMENT.outers);
        Set<String> ignores = Sets.newLinkedHashSet();
        while (argIt.hasNext()) {
            String arg = argIt.next();
            if (!arg.startsWith("-")) {
                argIt.previous();
                break;
            }
            if ("--out".equals(arg)) {
                outDir = argIt.next();
                continue;
            }
            if ("--builtin".equals(arg)) {
                outers.add(argIt.next());
                continue;
            }
            if ("--ignore".equals(arg)) {
                ignores.add(argIt.next());
                continue;
            }
            if ("--".equals(arg)) break;
            throw new IOException("Unrecognized command line flag " + arg);
        }
        while (argIt.hasNext()) {
            inputs.add(new File(argIt.next()));
        }
        List<File> deps = Lists.newArrayList();
        File out = outDir == null ? File.createTempFile(Linter.class.getSimpleName(), ".stamp") : new File(outDir, "jslint.txt");
        Environment env = new Environment(outers);
        new Linter(env, ignores).build(inputs, deps, out);
    }

    private static void checkGlobalsDefined(LexicalScope globalScope, LexicalScope scope, Set<String> documentedGlobals, MessageQueue mq) {
        for (String symbolName : Sets.difference(scope.symbols.symbolNames(), documentedGlobals)) {
            for (AncestorChain<?> decl : scope.symbols.getSymbol(symbolName).getDeclarations()) {
                if (decl == globalScope.root || decl.parent.node instanceof CatchStmt) continue;
                mq.addMessage((MessageTypeInt)MessageType.UNDOCUMENTED_GLOBAL, decl.node.getFilePosition(), MessagePart.Factory.valueOf(symbolName));
            }
        }
        for (LexicalScope inner : scope.innerScopes) {
            if (inner.isFunctionScope()) continue;
            Linter.checkGlobalsDefined(globalScope, inner, documentedGlobals, mq);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Environment {
        final Set<String> outers;

        public Environment(Set<String> outers) {
            this.outers = Sets.immutableSet(outers);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LintJob {
        final InputSource src;
        final Set<String> requires;
        final Set<String> provides;
        final Set<String> overrides;
        final Block program;

        LintJob(InputSource src, Set<String> requires, Set<String> provides, Set<String> overrides, Block program) {
            this.src = src;
            this.requires = requires;
            this.provides = provides;
            this.overrides = overrides;
            this.program = program;
        }
    }
}

