/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.ancillary.opt.StatementSimplifier;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Statement;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Join;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementSimplifierTest
extends CajaTestCase {
    public final void testExtraneousBlocks() throws ParseException {
        this.assertSimplified(Arrays.asList("{", "  if (foo())", "    return;", "  baz();", "}"), Arrays.asList("if (foo()) {", "  return void 0;", "} else {", "  baz();", "}"));
        this.assertNoErrors();
    }

    public final void testNestedBlocks() throws ParseException {
        this.assertSimplified(Arrays.asList("if (foo())", "  bar();", "else {", "  while (x) baz();", "  boo();", "}"), Arrays.asList("if (foo()) {", "  { bar(); }", "} else {", "  while (x) baz();", "  { boo(); }", "}"));
        this.assertNoErrors();
    }

    public final void testNoops() throws ParseException {
        this.assertSimplified(Arrays.asList("if (foo());", "else", "  boo();"), Arrays.asList("if (foo()) {", "  { ; }", "} else {", "  ;", "  { boo(); }", "}"));
        this.assertNoErrors();
    }

    public final void testRequiredBlocks() throws ParseException {
        this.assertSimplified(Arrays.asList("function f() { return 4; }"), Arrays.asList("function f() { return 4; }"));
        this.assertSimplified(Arrays.asList("try{f();}catch(e){g();}finally{h();}"), Arrays.asList("try{f();}catch(e){g();}finally{h();}"));
        this.assertNoErrors();
    }

    public final void testExprStmtsSimplified() throws ParseException {
        this.assertSimplified(Arrays.asList("while (cond) foo(), f(), bar();"), Arrays.asList("while (cond) { foo(); true; void f(); bar(); }"));
        this.assertNoErrors();
    }

    public final void testCondOptimization1() throws ParseException {
        this.assertSimplified(Arrays.asList("c && (foo(), bar(), baz())"), Arrays.asList("if (c) {", "  foo();", "  bar();", "  baz();", "}"));
        this.assertNoErrors();
    }

    public final void testCondOptimization2() throws ParseException {
        this.assertSimplified(Arrays.asList("c || (foo(), bar(), baz())"), Arrays.asList("if (!c) {", "  foo();", "  bar(),", "  baz();", "}"));
        this.assertNoErrors();
    }

    public final void testCondOptimization3a() throws ParseException {
        this.assertSimplified(Arrays.asList("return c ? boo() : (foo(), bar()), baz()"), Arrays.asList("if (!c) {", "  foo();", "  bar();", "  return baz();", "} else {", "  boo();", "  return baz();", "}"));
        this.assertNoErrors();
    }

    public final void testCondOptimization3b() throws ParseException {
        this.assertSimplified(Arrays.asList("return c ? void 0 : (foo(), baz())"), Arrays.asList("if (!c) {", "  foo();", "  return baz();", "} else {", "  return;", "}"));
        this.assertNoErrors();
    }

    public final void testCondOptimization3c() throws ParseException {
        this.assertSimplified(Arrays.asList("return c ? boo() : (foo(), bar()), baz()"), Arrays.asList("if (!c) {", "  return foo(),", "      bar(),", "      baz();", "} else {", "  boo();", "  return baz();", "}"));
        this.assertNoErrors();
    }

    public final void testCondOptimization3d() throws ParseException {
        this.assertSimplified(Arrays.asList("throw c ? boo() : (foo(), bar()), new Error(baz())"), Arrays.asList("if (!c) {", "  foo();", "  bar();", "  throw new Error(baz());", "} else {", "  boo();", "  throw new Error(baz());", "}"));
        this.assertNoErrors();
    }

    public final void testCondOptimization4a() throws ParseException {
        this.assertSimplified(Arrays.asList("if (!c) return foo(), bar(), baz()"), Arrays.asList("if (!c) {", "  foo();", "  bar();", "  return baz();", "}"));
        this.assertNoErrors();
    }

    public final void testCondOptimization4b() throws ParseException {
        this.assertSimplified(Arrays.asList("if (!c) throw foo(), bar(), baz()"), Arrays.asList("if (!c) {", "  foo();", "  bar();", "  throw baz();", "}"));
        this.assertNoErrors();
    }

    public final void testCondOptimization5() throws ParseException {
        this.assertSimplified(Arrays.asList("return c || null"), Arrays.asList("if (c) { return c; }", "return null;"));
        this.assertNoErrors();
    }

    public final void testCondOptimization6() throws ParseException {
        this.assertSimplified(Arrays.asList("return c || void 0"), Arrays.asList("if (c) { return c; }", "return;"));
        this.assertNoErrors();
    }

    public final void testCondOptimization7() throws ParseException {
        this.assertSimplified(Arrays.asList("return c && void 0"), Arrays.asList("if (c) { return; }", "return c;"));
        this.assertNoErrors();
    }

    public final void testCondOptimization8a() throws ParseException {
        this.assertSimplified(Arrays.asList("return !c"), Arrays.asList("if (!c) {", "  return true;", "}", "return false;"));
        this.assertNoErrors();
    }

    public final void testCondOptimization8b() throws ParseException {
        this.assertSimplified(Arrays.asList("return !!c"), Arrays.asList("if (c) {", "  return true;", "}", "return false;"));
        this.assertNoErrors();
    }

    public final void testCondOptimization8c() throws ParseException {
        this.assertSimplified(Arrays.asList("return c === b"), Arrays.asList("if (c === b) return true;", "else return false;"));
        this.assertNoErrors();
    }

    public final void testCondOptimization8d() throws ParseException {
        this.assertSimplified(Arrays.asList("return c !== b"), Arrays.asList("if (c === b) return false;", "return true;"));
        this.assertNoErrors();
    }

    public final void testNotFoldableToTernary() throws ParseException {
        this.assertSimplified(Arrays.asList("if (!c) foo(); else return bar();"), Arrays.asList("if (!c) {", "  foo();", "} else {", "  return bar();", "}"));
        this.assertNoErrors();
    }

    public final void testCondOptimizationComposes1() throws ParseException {
        this.assertSimplified(Arrays.asList("return c ? d ? (e && baz(),boo) : far : (foo(), bar)"), Arrays.asList("if (!c) {", "  foo();", "  return bar;", "} else if (d) {", "  if (e) {", "    baz();", "    return boo;", "  } else {", "    return boo;", "  }", "} else {", "  return far;", "}"));
        this.assertNoErrors();
    }

    public final void testCondOptimizationComposes2() throws ParseException {
        this.assertSimplified(Arrays.asList("{", "var x;", "return x = (c ? d ? e ? baz : boo : far : foo()), x;", "}"), Arrays.asList("var x;", "if (!c) {", "  x = foo();", "  return x;", "} else if (d) {", "  if (e) {", "    x = baz;", "  } else {", "    x = boo;", "  }", "  return x;", "} else {", "  x = far;", "  return x;", "}"));
        this.assertNoErrors();
    }

    public final void testMultiCondOpts() throws ParseException {
        this.assertSimplified(Arrays.asList("return a(),foo=='bar'?bar():foo=='bar2'?bar2():(baz(),boo(),far)"), Arrays.asList("a();", "if (foo == 'bar') { return bar(); }", "else if (foo == 'bar2') { return bar2(); }", "baz();", "boo();", "return far;"));
        this.assertNoErrors();
    }

    public final void testHandingConds() throws ParseException {
        this.assertSimplified(Arrays.asList("if (foo) { for (var k in o) if (f(o[k])) break; } else bar();"), Arrays.asList("if (foo) for (var k in o) { if (f(o[k])) break; } else bar();"));
        this.assertNoErrors();
    }

    public final void testUnnecessaryElses() throws ParseException {
        this.assertSimplified(Arrays.asList("if (foo()) bar();"), Arrays.asList("if (foo()) { bar(); } else { /* do nothing */ }"));
    }

    public final void testLabelRenaming() throws ParseException {
        this.assertSimplified(Arrays.asList("{", "  var foo = 1;", "  a: for (var k in o)", "    for (var j in o[k])", "      if (o[k][j]) break a;", "}"), Arrays.asList("var foo = 1;", "foo: for (var k in o) {", "  bar: for (var j in o[k]) {", "    if (o[k][j]) { break foo; }", "  }", "}"));
        this.assertNoErrors();
    }

    public final void testUnknownLabel() throws ParseException {
        this.assertSimplified(Arrays.asList("break;"), Arrays.asList("break foo;"));
        this.assertMessage(true, MessageType.UNDEFINED_SYMBOL, MessageLevel.ERROR, MessagePart.Factory.valueOf("foo"));
        this.assertNoErrors();
    }

    public final void testUselessLabel1() throws ParseException {
        this.assertSimplified(Arrays.asList("foo()"), Arrays.asList("{ foo: { foo(); } }"));
        this.assertNoErrors();
    }

    public final void testUselessLabel2() throws ParseException {
        this.assertSimplified(Arrays.asList("a: { while (1) break a; }"), Arrays.asList("{ foo: { while (1) break foo; } }"));
        this.assertNoErrors();
    }

    public final void testMaskLabel() throws ParseException {
        this.assertSimplified(Arrays.asList("a: for (var k in o)", "  switch (k) {", "    case x:", "      if (f(k)) break a;", "      break;", "    case y:", "      b: for (var j in p)", "        switch (j) {", "          case z:", "            if (f(j)) break b;", "            break;", "          default: panic();", "        }", "      break;", "    case w:", "      if (g(k)) break a;", "      break;", "    default: panic();", "  }"), Arrays.asList("foo: for (var k in o) {", "  switch (k) {", "    case x:", "      if (f(k)) { break foo; }", "      break;", "    case y:", "      foo: for (var j in p) {", "        switch (j) {", "          case z:", "            if (f(j)) { break foo; }", "            break;", "          default: panic();", "        }", "      }", "      break;", "    case w:", "      if (g(k)) break foo;", "      break;", "    default: panic();", "  }", "}"));
        this.assertNoErrors();
    }

    public final void testDeadCode() throws ParseException {
        this.assertSimplified(Arrays.asList("function f() { return foo(), bar(), baz(); }"), Arrays.asList("function f() {", "  foo();", "  bar();", "  return baz();", "  boo();", "}"));
        this.assertNoErrors();
    }

    public final void testSwitchBlocks1() throws ParseException {
        this.assertSimplified(Arrays.asList("switch (x) {", "  case 1:", "    return foo();", "  case 2:", "  case 3:", "    bar();", "    break;", "  case 4:", "    baz();", "}"), Arrays.asList("switch (x) {", "  case 1:", "    return foo();", "    break;", "  case 2:", "    bar();", "    break;", "  case 3:", "    bar();", "    break;", "  case 4:", "    baz();", "    break;", "  default:", "    break;", "}"));
        this.assertNoErrors();
    }

    public final void testSwitchBlocks3a() throws ParseException {
        this.assertSimplified(Arrays.asList("switch (x) {", "  case 1: return foo();", "  case 2: return bar();", "}"), Arrays.asList("foo: switch (x) {", "  case 1: return foo();", "  case 2: return bar();", "  case 3:", "  case 4:", "  default:", "    break;", "}"));
        this.assertNoErrors();
    }

    public final void testSwitchBlocks3b() throws ParseException {
        this.assertSimplified(Arrays.asList("switch (x) {", "  case 1: return foo();", "  case 2: return bar();", "}"), Arrays.asList("foo: switch (x) {", "  case 1: return foo();", "  case 2: return bar();", "  default:", "  case 3:", "  case 4:", "}"));
        this.assertNoErrors();
    }

    public final void testSwitchBlocks4() throws ParseException {
        this.assertSimplified(Arrays.asList("switch (x) {", "  case 1: return foo();", "  case 2: return bar();", "}"), Arrays.asList("foo: switch (x) {", "  case 1: return foo();", "  case 2: return bar();", "  case 3:", "  case 4:", "  default:", "    break;", "}"));
        this.assertNoErrors();
    }

    public final void testSwitchBlocks5() throws ParseException {
        this.assertSimplified(Arrays.asList("switch (x) {", "  case 2: return foo();", "  case x():", "}"), Arrays.asList("d: switch (x) {", "  case 1: break;", "  case 2: return foo();", "  case x():", "}"));
        this.assertNoErrors();
    }

    public final void testSwitchBlocks6() throws ParseException {
        this.assertSimplified(Arrays.asList("switch (x) {", "  case 1: break;", "  case 2: return bar();", "  default: baz();", "}"), Arrays.asList("bar: switch (x) {", "  case 1: break bar;", "  case 2: return bar();", "  default: baz();", "}"));
        this.assertNoErrors();
    }

    public final void testSwitchBlocks7() throws ParseException {
        this.assertSimplified(Arrays.asList("a: switch (x) {", "  case 2:", "    for (var i = 0; i < n; ++i)", "      if (arr[i]) break a; else if (arr[i] == null) break;", "    break;", "  case y():", "}"), Arrays.asList("foo: switch (x) {", "  case 1: break foo;", "  case 2:", "    for (var i = 0; i < n; ++i) {", "      if (arr[i]) break foo; else if (arr[i] == null) break;", "    }", "    break;", "  case y():", "  case 4:", "  default:", "    break;", "}"));
        this.assertNoErrors();
    }

    public final void testSwitchBlocks8() throws ParseException {
        this.assertSimplified(Arrays.asList("switch (x) {", "  case 4:", "  case 5:", "    return baz();", "}"), Arrays.asList("foo: switch (x) {", "  case 1:", "  case 2:", "  case 3: break;", "  case 4:", "  case 5:", "    return baz();;", "  default:", "    break;", "}"));
        this.assertNoErrors();
    }

    public final void testSwitchBlocks9() throws ParseException {
        this.assertSimplified(Arrays.asList("switch (x) {", "  case 1:", "    foo();", "    break;", "  case 4: baz();", "}"), Arrays.asList("foo: switch (x) {", "  case 1:", "    foo();", "  case 3: break;", "  case 4: baz();", "}"));
        this.assertNoErrors();
    }

    public final void testReturnValueVisited() throws ParseException {
        this.assertSimplified(Arrays.asList("function f() {", "  var i = 0;", "  return function () {", "     return ++i & 1 ? i : -i;", "  };", "}"), Arrays.asList("function f() {", "  var i = 0;", "  return function () {", "    if (++i & 1) { return i; } else { return -i; }", "  };", "}"));
        this.assertNoErrors();
    }

    public final void testBlockTruncating1() throws ParseException {
        this.assertSimplified(Arrays.asList("function f(x) {", "  return f;", "  function f() { return x * x; }", "}"), Arrays.asList("function f(x) {", "  return f;", "  function f() { return x * x; }", "}"));
        this.assertNoErrors();
    }

    public final void testBlockTruncating2() throws ParseException {
        this.assertSimplified(Arrays.asList("function f(x) {", "  return f;", "  function f() { return x * x; }", "}"), Arrays.asList("function f(x) {", "  return f;", "  f();", "  function f() { return x * x; }", "  f();", "}"));
        this.assertNoErrors();
    }

    public final void testBlockTruncating3() throws ParseException {
        this.assertSimplified(Arrays.asList("function f(x) {", "  return i++, f;", "  function f() { return x * x; }", "  var i;", "  var msg;", "}"), Arrays.asList("function f(x) {", "  i++;", "  return f;", "  if (foo) {", "    function f() { return x * x; }", "  } else {", "    try {", "      var i = 1;", "    } catch (ex) {", "      var msg = ex.message;", "    }", "  }", "}"));
        this.assertNoErrors();
    }

    public final void testExpressionStmtsOptimized() throws ParseException {
        this.assertSimplified(Arrays.asList("for (var i = 0; i < 10; ++i) arr[i] = inp[j--];"), Arrays.asList("for (var i = 0; i < 10; i++) { arr[i] = inp[j--]; }"));
        this.assertNoErrors();
    }

    public final void testOptimizeExpressionFlow() throws ParseException {
        StatementSimplifierTest.assertEquals((String)"4", (String)this.optFlow("4"));
        StatementSimplifierTest.assertEquals((String)"a || b", (String)this.optFlow("a ? a : b"));
        StatementSimplifierTest.assertEquals((String)"a && b", (String)this.optFlow("a ? b : a"));
        StatementSimplifierTest.assertEquals((String)this.norm("++a ? ++a : b"), (String)this.optFlow("++a ? ++a : b"));
        StatementSimplifierTest.assertEquals((String)this.norm("++a ? b : ++a"), (String)this.optFlow("++a ? b : ++a"));
        StatementSimplifierTest.assertEquals((String)this.norm("a ? b : c, d"), (String)this.optFlow("a ? (b,d) : (c,d)"));
        StatementSimplifierTest.assertEquals((String)this.norm("a && b, d"), (String)this.optFlow("a ? (b,d) : d"));
        StatementSimplifierTest.assertEquals((String)this.norm("a || c, d"), (String)this.optFlow("a ? d : (c,d)"));
        StatementSimplifierTest.assertEquals((String)this.norm("a || c, d"), (String)this.optFlow("!!a ? d : (c,d)"));
        StatementSimplifierTest.assertEquals((String)this.norm("a && c, d"), (String)this.optFlow("!a ? d : (c,d)"));
        StatementSimplifierTest.assertEquals((String)this.norm("a ? b : c, d, e"), (String)this.optFlow("a ? (b,d,e) : (c,d,e)"));
        StatementSimplifierTest.assertEquals((String)this.norm("a && b, d, e, f, g"), (String)this.optFlow("a ? (b, d, e, f, g) : (d, e, f, g)"));
        StatementSimplifierTest.assertEquals((String)this.norm("a ? x : (b, c, d), p, q, r"), (String)this.optFlow("!a ? (b, c, d, p, q, r) : (x, p, q, r)"));
        StatementSimplifierTest.assertEquals((String)this.norm("foo"), (String)this.optFlow("true ? foo : foo"));
        StatementSimplifierTest.assertEquals((String)this.norm("c(),foo"), (String)this.optFlow("c() ? foo : foo"));
        StatementSimplifierTest.assertEquals((String)this.norm("c(),d() ? foo : bar"), (String)this.optFlow("c() ? d() ? foo : bar : !d() ? bar : foo"));
        StatementSimplifierTest.assertEquals((String)this.norm("x + (c ? y : z)"), (String)this.optFlow("c ? x + y : x + z"));
        StatementSimplifierTest.assertEquals((String)this.norm("(c ? x : y) + z"), (String)this.optFlow("c ? x + z : y + z"));
        StatementSimplifierTest.assertEquals((String)this.norm("x = c ? y : z"), (String)this.optFlow("c ? x = y : x = z"));
        StatementSimplifierTest.assertEquals((String)this.norm("c ? x = z : y = z"), (String)this.optFlow("c ? x = z : y = z"));
        this.assertNoErrors();
    }

    public final void testExits() throws ParseException {
        StatementSimplifierTest.assertTrue((boolean)StatementSimplifier.exits(this.js(this.fromString("return;"))));
        StatementSimplifierTest.assertTrue((boolean)StatementSimplifier.exits(this.js(this.fromString("return 1;"))));
        StatementSimplifierTest.assertTrue((boolean)StatementSimplifier.exits(this.js(this.fromString("break foo;"))));
        StatementSimplifierTest.assertTrue((boolean)StatementSimplifier.exits(this.js(this.fromString("break;"))));
        StatementSimplifierTest.assertTrue((boolean)StatementSimplifier.exits(this.js(this.fromString("continue foo;"))));
        StatementSimplifierTest.assertTrue((boolean)StatementSimplifier.exits(this.js(this.fromString("continue;"))));
        StatementSimplifierTest.assertTrue((boolean)StatementSimplifier.exits(this.js(this.fromString("throw new Error();"))));
        StatementSimplifierTest.assertTrue((boolean)StatementSimplifier.exits(this.js(this.fromString("throw null;"))));
        StatementSimplifierTest.assertFalse((boolean)StatementSimplifier.exits(this.js(this.fromString("1;"))));
        StatementSimplifierTest.assertFalse((boolean)StatementSimplifier.exits(this.js(this.fromString("f();"))));
        StatementSimplifierTest.assertTrue((boolean)StatementSimplifier.exits(this.js(this.fromString("{ foo(); return; }"))));
        StatementSimplifierTest.assertFalse((boolean)StatementSimplifier.exits(this.js(this.fromString("{ foo(); bar(); }"))));
        StatementSimplifierTest.assertFalse((boolean)StatementSimplifier.exits(this.js(this.fromString("if (x) return;"))));
        StatementSimplifierTest.assertTrue((boolean)StatementSimplifier.exits(this.js(this.fromString("if (x) return y; else return z;"))));
        StatementSimplifierTest.assertFalse((boolean)StatementSimplifier.exits(this.js(this.fromString("if (x) y(); else return z;"))));
        StatementSimplifierTest.assertFalse((boolean)StatementSimplifier.exits(this.js(this.fromString("if (x) return y; else z();"))));
        this.assertNoErrors();
    }

    private String optFlow(String code) throws ParseException {
        return StatementSimplifierTest.render(StatementSimplifier.optimizeExpressionFlow(this.jsExpr(this.fromString(code))));
    }

    private String norm(String code) throws ParseException {
        return StatementSimplifierTest.render(this.jsExpr(this.fromString(code)));
    }

    private void assertSimplified(List<String> expected, List<String> input) throws ParseException {
        Block expectedStmt = this.js(this.fromString(Join.join((CharSequence)"\n", expected)));
        Block inputStmt = this.js(this.fromString(Join.join((CharSequence)"\n", input)));
        ParseTreeNode optimized = StatementSimplifier.optimize(inputStmt, this.mq);
        StatementSimplifierTest.assertEquals((String)StatementSimplifierTest.renderBody(expectedStmt), (String)StatementSimplifierTest.renderStmt((Statement)optimized));
    }

    private static String renderBody(Block bl) {
        StringBuilder sb = new StringBuilder();
        RenderContext rc = new RenderContext(bl.makeRenderer(sb, null));
        bl.renderBody(rc);
        rc.getOut().noMoreTokens();
        return sb.toString();
    }

    private static String renderStmt(Statement s) {
        StringBuilder sb = new StringBuilder();
        RenderContext rc = new RenderContext(s.makeRenderer(sb, null));
        s.renderBlock(rc, true);
        rc.getOut().noMoreTokens();
        return sb.toString();
    }
}

