/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.demos.playground.server;

import com.google.caja.demos.playground.client.CajolingServiceResult;
import com.google.caja.demos.playground.client.PlaygroundService;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.opensocial.DefaultGadgetRewriter;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.HtmlSnippetProducer;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.Lists;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GWTCajolingServiceImpl
extends RemoteServiceServlet
implements PlaygroundService {
    private final UriFetcher fetcher;
    private static final UriPolicy uriPolicy = new UriPolicy(){

        @Override
        public String rewriteUri(ExternalReference u, UriPolicy.UriEffect effect, UriPolicy.LoaderType loader, Map<String, ?> hints) {
            if (UriPolicy.LoaderType.SANDBOXED == loader) {
                return u.getUri().toString();
            }
            return "http://caja.appspot.com/cajole?url=" + UriUtil.encode(u.getUri().toString()) + "&loader=" + (Object)((Object)loader) + "&effect=" + (Object)((Object)effect);
        }
    };

    public GWTCajolingServiceImpl(UriFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @ParseTreeNode.ReflectiveCtor
    public GWTCajolingServiceImpl() {
        this(new UriFetcher(){

            @Override
            public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
                try {
                    return FetchedData.fromConnection(ref.getUri().toURL().openConnection());
                }
                catch (IOException ex) {
                    throw new UriFetcher.UriFetchException(ref, mimeType, ex);
                }
            }
        });
    }

    private static URI guessURI(String guess) {
        try {
            guess = UriUtil.normalizeUri(guess);
            if (guess != null) {
                return new URI(guess);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return URI.create("unknown:///unknown");
    }

    public String[] getMessageLevels() {
        MessageLevel[] values = MessageLevel.values();
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].name();
        }
        return result;
    }

    @Override
    public CajolingServiceResult cajole(String url, String input, boolean debugMode) {
        MessageContext mc = new MessageContext();
        SimpleMessageQueue mq = new SimpleMessageQueue();
        StringBuilder output = new StringBuilder();
        String html = null;
        String javascript = null;
        Map<InputSource, String> originalSources = Collections.singletonMap(new InputSource(GWTCajolingServiceImpl.guessURI(url)), input);
        try {
            DefaultGadgetRewriter rw = new DefaultGadgetRewriter(BuildInfo.getInstance(), mq);
            StringReader in = new StringReader(input);
            rw.rewriteContent(GWTCajolingServiceImpl.guessURI(url), in, this.fetcher, uriPolicy, debugMode, (Appendable)output);
            String[] htmlAndJs = output.toString().split("<script[^>]*>");
            html = htmlAndJs[0];
            javascript = htmlAndJs.length > 1 ? htmlAndJs[1].substring(0, htmlAndJs[1].length() - 9) : null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GadgetRewriteException e) {
            // empty catch block
        }
        String[] messages = this.formatMessages(originalSources, mc, mq);
        return new CajolingServiceResult(html, javascript, messages);
    }

    private String[] formatMessages(Map<InputSource, ? extends CharSequence> inputMap, MessageContext mc, MessageQueue mq) {
        List<Message> messages = mq.getMessages();
        HtmlSnippetProducer sp = new HtmlSnippetProducer(inputMap, mc);
        List<String> result = Lists.newArrayList();
        for (Message msg : messages) {
            String snippet = sp.getSnippet(msg);
            StringBuilder messageText = new StringBuilder();
            messageText.append(msg.getMessageLevel().name()).append(" ").append(msg.format(mc));
            messageText.append(":").append(snippet);
            result.add(messageText.toString());
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getBuildInfo() {
        return BuildInfo.getInstance().getBuildInfo();
    }

    @Override
    public String fetch(String uri) {
        try {
            URI address = new URI(uri);
            return this.fetcher.fetch(new ExternalReference(address, FilePosition.UNKNOWN), "*/*").getTextualContent().toString();
        }
        catch (URISyntaxException ex) {
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        catch (UriFetcher.UriFetchException ex) {
            return null;
        }
    }
}

