/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.html;

import com.google.caja.lang.html.RegularCriterion;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.util.Lists;
import java.util.Collections;
import java.util.List;

public final class HTML {

    public static final class Attribute {
        private final AttribKey key_;
        private final Type type_;
        private final String defaultValue_;
        private final String safeValue_;
        private final boolean valueless_;
        private final boolean optional_;
        private final UriPolicy.LoaderType loaderType_;
        private final UriPolicy.UriEffect effect_;
        private final RegularCriterion valueCriterion_;

        public Attribute(AttribKey key, Type type, String defaultValue, String safeValue, boolean valueless, boolean optional, UriPolicy.LoaderType loaderType, UriPolicy.UriEffect effect, RegularCriterion valueCriterion) {
            assert (key != null);
            assert (type != null);
            assert (safeValue == null || valueCriterion.accept(safeValue)) : "[" + safeValue + "] for " + key + " with criterion /" + valueCriterion.toRegularExpression() + "/";
            assert (type == Type.URI == (effect != null)) : key;
            assert (type == Type.URI == (loaderType != null)) : key;
            this.key_ = key;
            this.type_ = type;
            this.defaultValue_ = defaultValue;
            this.safeValue_ = safeValue;
            this.valueless_ = valueless;
            this.optional_ = optional;
            this.loaderType_ = loaderType;
            this.effect_ = effect;
            this.valueCriterion_ = valueCriterion;
        }

        public AttribKey getKey() {
            return this.key_;
        }

        public Type getType() {
            return this.type_;
        }

        public String getDefaultValue() {
            return this.defaultValue_;
        }

        public String getSafeValue() {
            return this.safeValue_;
        }

        public RegularCriterion getValueCriterion() {
            return this.valueCriterion_;
        }

        public boolean isValueless() {
            return this.valueless_;
        }

        public boolean isOptional() {
            return this.optional_;
        }

        public UriPolicy.UriEffect getUriEffect() {
            return this.effect_;
        }

        public UriPolicy.LoaderType getLoaderType() {
            return this.loaderType_;
        }

        public String toString() {
            return this.key_.toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute that = (Attribute)o;
            return this.key_.equals(that.key_);
        }

        public int hashCode() {
            return this.key_.hashCode();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            NONE,
            URI,
            URI_FRAGMENT,
            SCRIPT,
            STYLE,
            ID,
            IDREF,
            IDREFS,
            GLOBAL_NAME,
            LOCAL_NAME,
            CLASSES,
            FRAME_TARGET;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Element {
        private final ElKey key_;
        private final List<Attribute> attrs_;
        private final boolean empty_;
        private final boolean optionalEndTag_;
        private final boolean containsText_;

        public Element(ElKey key, List<Attribute> attrs, boolean empty, boolean optionalEndTag, boolean containsText) {
            assert (key != null);
            this.key_ = key;
            this.attrs_ = Collections.unmodifiableList(Lists.newArrayList(attrs));
            this.empty_ = empty;
            this.optionalEndTag_ = optionalEndTag;
            this.containsText_ = containsText;
        }

        public List<Attribute> getAttributes() {
            return this.attrs_;
        }

        public ElKey getKey() {
            return this.key_;
        }

        public boolean isEmpty() {
            return this.empty_;
        }

        public boolean isEndTagOptional() {
            return this.optionalEndTag_;
        }

        public boolean canContainText() {
            return this.containsText_;
        }

        public String toString() {
            return this.key_.toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Element)) {
                return false;
            }
            return this.key_.equals(((Element)o).key_);
        }

        public int hashCode() {
            return this.key_.hashCode();
        }
    }
}

