/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssLexer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenStream;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CssSplitter
implements TokenStream<CssTokenType> {
    private final CharProducer cp;
    private final MessageQueue mq;
    private boolean allowSubstitutions;
    private Token<CssTokenType> pending;

    CssSplitter(CharProducer cp, MessageQueue mq, boolean allowSubstitutions) {
        assert (null != cp);
        this.cp = cp;
        this.mq = mq;
        this.allowSubstitutions = allowSubstitutions;
    }

    @Override
    public boolean hasNext() throws ParseException {
        this.produce();
        return null != this.pending;
    }

    @Override
    public Token<CssTokenType> next() throws ParseException {
        this.produce();
        if (null == this.pending) {
            throw new NoSuchElementException();
        }
        Token<CssTokenType> result = this.pending;
        this.pending = null;
        return result;
    }

    boolean areSubstitutionsAllowed() {
        return this.allowSubstitutions;
    }

    public void allowSubstitutions(boolean allow) {
        this.allowSubstitutions = allow;
    }

    private void produce() throws ParseException {
        CssTokenType type;
        int end;
        if (null != this.pending) {
            return;
        }
        if (this.cp.isEmpty()) {
            return;
        }
        char[] buf = this.cp.getBuffer();
        int start = this.cp.getOffset();
        int limit = this.cp.getLimit();
        char ch = buf[start];
        if (CssLexer.isSpaceChar(ch)) {
            end = this.parseWhitespace(buf, end, limit);
            type = CssTokenType.SPACE;
        } else if (ch == '/') {
            if (end < limit && buf[end] == '*') {
                int state = 0;
                block10: for (end = start + 1; end != limit; ++end) {
                    ch = buf[end];
                    switch (state) {
                        case 0: {
                            state = 1;
                            continue block10;
                        }
                        case 1: {
                            if (ch != '*') continue block10;
                            state = 2;
                            continue block10;
                        }
                        case 2: {
                            if (ch == '/') {
                                state = 3;
                                continue block10;
                            }
                            if (ch == '*') continue block10;
                            state = 1;
                        }
                    }
                    if (state != 3) continue;
                }
                if (state != 3) {
                    throw new ParseException(new Message((MessageTypeInt)MessageType.UNTERMINATED_COMMENT_TOKEN, this.cp.filePositionForOffsets(start, end)));
                }
                type = CssTokenType.COMMENT;
            } else if (end < limit && buf[end] == '/') {
                while (++end != limit && (ch = buf[end]) != '\r' && ch != '\n') {
                }
                type = CssTokenType.COMMENT;
                FilePosition commentPos = this.cp.filePositionForOffsets(start, end);
                this.mq.addMessage((MessageTypeInt)MessageType.INVALID_CSS_COMMENT, commentPos);
            } else {
                type = CssTokenType.PUNCTUATION;
            }
        } else if ('~' == ch || '|' == ch) {
            if (end < limit && '=' == buf[end]) {
                ++end;
            }
            type = CssTokenType.PUNCTUATION;
        } else if (ch == '\'' || ch == '\"') {
            end = CssSplitter.parseString(this.cp, start);
            type = CssTokenType.STRING;
        } else if (ch == '@') {
            int identEnd = CssSplitter.parseIdent(this.cp, end);
            if (identEnd != -1) {
                type = CssTokenType.SYMBOL;
                end = identEnd;
            } else {
                type = CssTokenType.PUNCTUATION;
            }
        } else if (ch == '!') {
            type = CssTokenType.PUNCTUATION;
        } else if (ch == '#') {
            int nameEnd = CssSplitter.parseName(this.cp, end);
            if (nameEnd >= 0) {
                type = CssTokenType.HASH;
                end = nameEnd;
            } else {
                type = CssTokenType.PUNCTUATION;
            }
        } else if (ch == '<' || ch == '-') {
            int tailEnd = CssSplitter.parseMatch(this.cp, end, ch == '<' ? "!--" : "->");
            if (tailEnd >= 0) {
                end = tailEnd;
            }
            type = CssTokenType.PUNCTUATION;
        } else if (ch >= '0' && ch <= '9' || '.' == ch) {
            boolean isNum;
            if ('.' == ch) {
                int numEnd = CssSplitter.parseInt(this.cp, end);
                boolean bl = isNum = numEnd >= 0;
                if (isNum) {
                    end = numEnd;
                }
            } else {
                isNum = true;
                end = CssSplitter.parseNum(this.cp, start);
            }
            if (isNum) {
                int identEnd = CssSplitter.parseIdent(this.cp, end);
                if (identEnd >= 0) {
                    end = identEnd;
                } else if (end < limit && '%' == buf[end]) {
                    ++end;
                }
                type = CssTokenType.QUANTITY;
            } else {
                type = CssTokenType.PUNCTUATION;
            }
        } else {
            int identEnd = CssSplitter.parseIdent(this.cp, start);
            if (identEnd >= 0) {
                end = identEnd;
                if (end - start == 1 && 'U' == ch && end < limit && '+' == buf[end]) {
                    type = CssTokenType.UNICODE_RANGE;
                    ++end;
                    end = CssSplitter.parseRange(this.cp, end);
                } else if (end < limit && '(' == buf[end]) {
                    if (++end - start == 4 && CssSplitter.parseMatch(this.cp, start, "url(") >= 0) {
                        int uriEnd;
                        int stringEnd = CssSplitter.parseString(this.cp, end = this.parseWhitespace(buf, end, limit));
                        int n = uriEnd = stringEnd < 0 ? this.parseUri(this.cp, end) : -1;
                        if (stringEnd < 0 && uriEnd < 0) {
                            throw new ParseException(new Message((MessageTypeInt)MessageType.EXPECTED_TOKEN, this.cp.filePositionForOffsets(end, end), MessagePart.Factory.valueOf("{url}"), CssSplitter.toMessagePart(this.cp, end)));
                        }
                        end = stringEnd >= 0 ? stringEnd : uriEnd;
                        if ((end = this.parseWhitespace(buf, end, limit)) == limit || ')' != buf[end]) {
                            throw new ParseException(new Message((MessageTypeInt)MessageType.EXPECTED_TOKEN, this.cp.filePositionForOffsets(end, end), MessagePart.Factory.valueOf(")"), CssSplitter.toMessagePart(this.cp, end)));
                        }
                        ++end;
                        type = CssTokenType.URI;
                    } else {
                        type = CssTokenType.FUNCTION;
                    }
                } else {
                    type = CssTokenType.IDENT;
                }
            } else if (ch == '$' && this.allowSubstitutions) {
                if (end < limit && buf[end] != '{') {
                    type = CssTokenType.PUNCTUATION;
                } else {
                    int state = 0;
                    int nOpen = 0;
                    char delim = '\u0000';
                    while (end != limit) {
                        ch = buf[end];
                        switch (state) {
                            case 0: {
                                if (ch == '\"' || ch == '\'') {
                                    delim = ch;
                                    state = 1;
                                    break;
                                }
                                if (ch == '{') {
                                    ++nOpen;
                                    break;
                                }
                                if (ch != '}' || --nOpen != 0) break;
                                state = 3;
                                break;
                            }
                            case 1: {
                                if (ch == delim) {
                                    state = 0;
                                    break;
                                }
                                if (ch != '\\') break;
                                state = 2;
                                break;
                            }
                            case 2: {
                                state = 1;
                            }
                        }
                        ++end;
                        if (state != 3) continue;
                    }
                    if (state != 3) {
                        throw new ParseException(new Message((MessageTypeInt)MessageType.UNTERMINATED_STRING_TOKEN, this.cp.filePositionForOffsets(start, end)));
                    }
                    identEnd = CssSplitter.parseIdent(this.cp, end);
                    if (identEnd >= 0) {
                        end = identEnd;
                    } else if (end != limit && '%' == buf[end]) {
                        ++end;
                    }
                    type = CssTokenType.SUBSTITUTION;
                }
            } else {
                type = CssTokenType.PUNCTUATION;
            }
        }
        assert (end > start);
        this.pending = Token.instance(this.cp.toString(start, end), type, this.cp.filePositionForOffsets(start, end));
        this.cp.consumeTo(end);
    }

    private static int parseMatch(CharProducer cp, int start, String match) {
        int len = match.length();
        int limit = cp.getLimit();
        if (limit - start < len) {
            return -1;
        }
        char[] buf = cp.getBuffer();
        for (int i = 0; i < len; ++i) {
            char chB = buf[start + i];
            char chM = match.charAt(i);
            if (chB == chM || (chB | 0x20) == chM && chB >= 'A' && chB < 'Z') continue;
            return -1;
        }
        return start + len;
    }

    private static int parseString(CharProducer cp, int start) throws ParseException {
        int limit = cp.getLimit();
        if (start == limit) {
            return -1;
        }
        char[] buf = cp.getBuffer();
        char ch = buf[start];
        if (ch != '\'' && ch != '\"') {
            return -1;
        }
        char delim = ch;
        int end = start + 1;
        while (end < limit) {
            ch = buf[end];
            ++end;
            if (delim == ch) {
                return end;
            }
            if (ch == '\\') {
                if (end < limit && CssSplitter.isLineBreak(ch = buf[end])) {
                    if (ch != '\r' || ++end >= limit || buf[end] != '\n') continue;
                    ++end;
                    continue;
                }
                end = CssSplitter.parseEscapeBody(cp, end);
                continue;
            }
            if (!CssSplitter.isLineBreak(ch)) continue;
            throw new ParseException(new Message((MessageTypeInt)MessageType.MALFORMED_STRING, cp.filePositionForOffsets(end - 1, end - 1), MessagePart.Factory.valueOf("" + ch)));
        }
        throw new ParseException(new Message((MessageTypeInt)MessageType.UNTERMINATED_STRING_TOKEN, cp.filePositionForOffsets(start, end)));
    }

    private int parseUri(CharProducer cp, int start) throws ParseException {
        char[] buf = cp.getBuffer();
        int limit = cp.getLimit();
        int end = start;
        while (end < limit) {
            if (CssSplitter.isUriChar(buf[end])) {
                ++end;
                continue;
            }
            if (buf[end] != '\\') break;
            end = CssSplitter.parseEscapeBody(cp, end + 1);
        }
        return end;
    }

    private static boolean isUriChar(char ch) {
        switch (ch) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': {
                return true;
            }
        }
        return ch >= '*' && ch <= '~' || CssSplitter.isNonAscii(ch);
    }

    private static boolean isLineBreak(char ch) {
        switch (ch) {
            case '\n': 
            case '\f': 
            case '\r': {
                return true;
            }
        }
        return false;
    }

    private int parseWhitespace(char[] buf, int end, int limit) {
        while (end < limit && CssLexer.isSpaceChar(buf[end])) {
            ++end;
        }
        return end;
    }

    private static int parseNum(CharProducer cp, int start) throws ParseException {
        int end = CssSplitter.parseInt(cp, start);
        assert (end >= 0);
        int limit = cp.getLimit();
        char[] buf = cp.getBuffer();
        if (end < limit && '.' == buf[end]) {
            char ch;
            if (++end == limit || (ch = buf[end]) < '0' || ch > '9') {
                throw new ParseException(new Message((MessageTypeInt)MessageType.MALFORMED_NUMBER, cp.filePositionForOffsets(start, end), MessagePart.Factory.valueOf(cp.toString(start, end))));
            }
            return CssSplitter.parseInt(cp, end);
        }
        return end;
    }

    private static int parseInt(CharProducer cp, int start) {
        int limit = cp.getLimit();
        if (start == limit) {
            return -1;
        }
        char[] buf = cp.getBuffer();
        char ch = buf[start];
        if (ch >= '0' && ch <= '9') {
            int end = start;
            while (++end != limit && (ch = buf[end]) >= '0' && ch <= '9') {
            }
            return end;
        }
        return -1;
    }

    private static int parseIdent(CharProducer cp, int start) throws ParseException {
        int nmCharEnd;
        int end = CssSplitter.parseNmStart(cp, start);
        if (end < 0) {
            return -1;
        }
        while ((nmCharEnd = CssSplitter.parseNmChar(cp, end)) >= 0) {
            end = nmCharEnd;
        }
        return end;
    }

    private static int parseName(CharProducer cp, int start) throws ParseException {
        int nmCharEnd;
        int end = CssSplitter.parseNmChar(cp, start);
        if (end < 0) {
            return -1;
        }
        while ((nmCharEnd = CssSplitter.parseNmChar(cp, end)) >= 0) {
            end = nmCharEnd;
        }
        return end;
    }

    private static int parseNmStart(CharProducer cp, int start) throws ParseException {
        if (start == cp.getLimit()) {
            return -1;
        }
        char ch = cp.getBuffer()[start];
        if (CssLexer.isNmStart(ch)) {
            return start + 1;
        }
        if (ch == '\\') {
            return CssSplitter.parseEscapeBody(cp, start + 1);
        }
        return -1;
    }

    private static int parseNmChar(CharProducer cp, int start) throws ParseException {
        char ch;
        int end = CssSplitter.parseNmStart(cp, start);
        if (end >= 0) {
            return end;
        }
        if (start != cp.getLimit() && ((ch = cp.getBuffer()[start]) >= '0' && ch <= '9' || ch == '-')) {
            return start + 1;
        }
        return -1;
    }

    private static int parseEscapeBody(CharProducer cp, int start) throws ParseException {
        int limit = cp.getLimit();
        char[] buf = cp.getBuffer();
        if (start == limit) {
            throw new ParseException(new Message((MessageTypeInt)MessageType.EXPECTED_TOKEN, cp.filePositionForOffsets(start, start), MessagePart.Factory.valueOf("<hex-digit>"), MessagePart.Factory.valueOf("<end-of-input>")));
        }
        char ch = buf[start];
        if (CssLexer.isHexChar(ch)) {
            int end;
            int i = 5;
            for (end = start + 1; --i >= 0 && end != limit && CssLexer.isHexChar(ch = buf[end]); ++end) {
            }
            if (end < limit && CssLexer.isSpaceChar(ch = buf[end]) && '\r' == ch && ++end < limit && '\n' == buf[end]) {
                ++end;
            }
            return end;
        }
        if (CssSplitter.isLineBreak(ch)) {
            throw new ParseException(new Message((MessageTypeInt)MessageType.UNRECOGNIZED_ESCAPE, cp.filePositionForOffsets(start, start), MessagePart.Factory.valueOf(String.valueOf(ch))));
        }
        return start + 1;
    }

    private static int parseRange(CharProducer cp, int start) throws ParseException {
        int end;
        boolean isRange;
        char[] buf = cp.getBuffer();
        int limit = cp.getLimit();
        int len = 6;
        boolean bl = isRange = end < limit && buf[end] == '?';
        if (isRange) {
            for (end = start; end < limit && '?' == buf[end] && --len >= 0; ++end) {
            }
        }
        while (end < limit && CssLexer.isHexChar(buf[end]) && --len >= 0) {
            ++end;
        }
        if (!isRange) {
            if (end == limit || '-' != buf[end]) {
                throw new ParseException(new Message((MessageTypeInt)MessageType.EXPECTED_TOKEN, cp.filePositionForOffsets(end, end), MessagePart.Factory.valueOf("-"), CssSplitter.toMessagePart(cp, end)));
            }
            ++end;
            len = 6;
            while (end < limit && '?' == buf[end] && --len >= 0) {
                ++end;
            }
            while (end < limit && CssLexer.isHexChar(buf[end]) && --len >= 0) {
                ++end;
            }
        }
        return end != start ? end : -1;
    }

    private static boolean isNonAscii(char ch) {
        return ch >= '\u0080' && ch <= '\u00ff';
    }

    private static MessagePart toMessagePart(CharProducer cp, int offset) {
        return MessagePart.Factory.valueOf(offset == cp.getLimit() ? "<end-of-input>" : "" + cp.getBuffer()[offset]);
    }
}

