/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.PunctuationTrie;
import com.google.caja.util.Strings;
import java.util.HashMap;

public class HtmlEntities {
    public static final PunctuationTrie<Integer> ENTITY_TRIE;

    public static long decodeEntityAt(char[] chars, int offset, int limit) {
        int codepoint;
        int end;
        block25: {
            char ch = chars[offset];
            if ('&' != ch) {
                return (long)offset + 1L << 32 | (long)ch;
            }
            int entityLimit = Math.min(limit, offset + 10);
            end = -1;
            for (int i = offset + 1; i < entityLimit; ++i) {
                if (';' != chars[i]) continue;
                end = i;
                break;
            }
            if (end < 0 || offset + 2 >= end) {
                return (long)offset + 1L << 32 | 0x26L;
            }
            char ch1 = chars[offset + 1];
            char ch2 = chars[offset + 2];
            codepoint = -1;
            if ('#' == ch1) {
                if ('x' == ch2 || 'X' == ch2) {
                    codepoint = 0;
                    block8: for (int i = offset + 3; i < end; ++i) {
                        char digit = chars[i];
                        switch (digit & 0xFFF8) {
                            case 48: 
                            case 56: {
                                int decDig = digit & 0xF;
                                if (decDig < 10) {
                                    codepoint = codepoint << 4 | decDig;
                                    continue block8;
                                }
                                codepoint = -1;
                                break block25;
                            }
                            case 64: 
                            case 96: {
                                int hexDig = digit & 7;
                                if (hexDig != 0 && hexDig < 7) {
                                    codepoint = codepoint << 4 | hexDig + 9;
                                    continue block8;
                                }
                                codepoint = -1;
                                break block25;
                            }
                            default: {
                                codepoint = -1;
                                break block25;
                            }
                        }
                    }
                } else {
                    codepoint = 0;
                    block9: for (int i = offset + 2; i < end; ++i) {
                        char digit = chars[i];
                        switch (digit & 0xFFF8) {
                            case 48: 
                            case 56: {
                                int decDig = digit - 48;
                                if (decDig < 10) {
                                    codepoint = codepoint * 10 + decDig;
                                    continue block9;
                                }
                                codepoint = -1;
                                break block25;
                            }
                            default: {
                                codepoint = -1;
                                break block25;
                            }
                        }
                    }
                }
            } else {
                char nameChar;
                int i;
                PunctuationTrie<Integer> t = ENTITY_TRIE;
                for (i = offset + 1; i < end && (t = t.lookup(nameChar = chars[i])) != null; ++i) {
                }
                if (t == null) {
                    t = ENTITY_TRIE;
                    for (i = offset + 1; i < end; ++i) {
                        nameChar = chars[i];
                        if ('Z' >= nameChar && nameChar >= 'A') {
                            nameChar = (char)(nameChar | 0x20);
                        }
                        if ((t = t.lookup(nameChar)) == null) break;
                    }
                }
                if (t != null && t.isTerminal()) {
                    codepoint = t.getValue();
                }
            }
        }
        if (codepoint < 0) {
            return (long)offset + 1L << 32 | 0x26L;
        }
        return (long)end + 1L << 32 | (long)codepoint;
    }

    public static boolean isEntityName(String name) {
        int i;
        PunctuationTrie<Integer> t = ENTITY_TRIE;
        int n = name.length();
        boolean isUcase = true;
        for (i = 0; i < n; ++i) {
            char ch = name.charAt(i);
            if ('A' <= ch && ch <= 'Z') continue;
            isUcase = false;
            break;
        }
        if (isUcase) {
            name = Strings.toLowerCase(name);
        }
        for (i = 0; i < n; ++i) {
            if ((t = t.lookup(name.charAt(i))) != null) continue;
            return false;
        }
        return t.isTerminal();
    }

    static {
        HashMap<String, Integer> entities = new HashMap<String, Integer>();
        entities.put("quot", 34);
        entities.put("amp", 38);
        entities.put("lt", 60);
        entities.put("gt", 62);
        entities.put("apos", 39);
        entities.put("nbsp", 160);
        entities.put("iexcl", 161);
        entities.put("cent", 162);
        entities.put("pound", 163);
        entities.put("curren", 164);
        entities.put("yen", 165);
        entities.put("brvbar", 166);
        entities.put("sect", 167);
        entities.put("uml", 168);
        entities.put("copy", 169);
        entities.put("ordf", 170);
        entities.put("laquo", 171);
        entities.put("not", 172);
        entities.put("shy", 173);
        entities.put("reg", 174);
        entities.put("macr", 175);
        entities.put("deg", 176);
        entities.put("plusmn", 177);
        entities.put("sup2", 178);
        entities.put("sup3", 179);
        entities.put("acute", 180);
        entities.put("micro", 181);
        entities.put("para", 182);
        entities.put("middot", 183);
        entities.put("cedil", 184);
        entities.put("sup1", 185);
        entities.put("ordm", 186);
        entities.put("raquo", 187);
        entities.put("frac14", 188);
        entities.put("frac12", 189);
        entities.put("frac34", 190);
        entities.put("iquest", 191);
        entities.put("Agrave", 192);
        entities.put("Aacute", 193);
        entities.put("Acirc", 194);
        entities.put("Atilde", 195);
        entities.put("Auml", 196);
        entities.put("Aring", 197);
        entities.put("AElig", 198);
        entities.put("Ccedil", 199);
        entities.put("Egrave", 200);
        entities.put("Eacute", 201);
        entities.put("Ecirc", 202);
        entities.put("Euml", 203);
        entities.put("Igrave", 204);
        entities.put("Iacute", 205);
        entities.put("Icirc", 206);
        entities.put("Iuml", 207);
        entities.put("ETH", 208);
        entities.put("Ntilde", 209);
        entities.put("Ograve", 210);
        entities.put("Oacute", 211);
        entities.put("Ocirc", 212);
        entities.put("Otilde", 213);
        entities.put("Ouml", 214);
        entities.put("times", 215);
        entities.put("Oslash", 216);
        entities.put("Ugrave", 217);
        entities.put("Uacute", 218);
        entities.put("Ucirc", 219);
        entities.put("Uuml", 220);
        entities.put("Yacute", 221);
        entities.put("THORN", 222);
        entities.put("szlig", 223);
        entities.put("agrave", 224);
        entities.put("aacute", 225);
        entities.put("acirc", 226);
        entities.put("atilde", 227);
        entities.put("auml", 228);
        entities.put("aring", 229);
        entities.put("aelig", 230);
        entities.put("ccedil", 231);
        entities.put("egrave", 232);
        entities.put("eacute", 233);
        entities.put("ecirc", 234);
        entities.put("euml", 235);
        entities.put("igrave", 236);
        entities.put("iacute", 237);
        entities.put("icirc", 238);
        entities.put("iuml", 239);
        entities.put("eth", 240);
        entities.put("ntilde", 241);
        entities.put("ograve", 242);
        entities.put("oacute", 243);
        entities.put("ocirc", 244);
        entities.put("otilde", 245);
        entities.put("ouml", 246);
        entities.put("divide", 247);
        entities.put("oslash", 248);
        entities.put("ugrave", 249);
        entities.put("uacute", 250);
        entities.put("ucirc", 251);
        entities.put("uuml", 252);
        entities.put("yacute", 253);
        entities.put("thorn", 254);
        entities.put("yuml", 255);
        entities.put("fnof", 402);
        entities.put("Alpha", 913);
        entities.put("Beta", 914);
        entities.put("Gamma", 915);
        entities.put("Delta", 916);
        entities.put("Epsilon", 917);
        entities.put("Zeta", 918);
        entities.put("Eta", 919);
        entities.put("Theta", 920);
        entities.put("Iota", 921);
        entities.put("Kappa", 922);
        entities.put("Lambda", 923);
        entities.put("Mu", 924);
        entities.put("Nu", 925);
        entities.put("Xi", 926);
        entities.put("Omicron", 927);
        entities.put("Pi", 928);
        entities.put("Rho", 929);
        entities.put("Sigma", 931);
        entities.put("Tau", 932);
        entities.put("Upsilon", 933);
        entities.put("Phi", 934);
        entities.put("Chi", 935);
        entities.put("Psi", 936);
        entities.put("Omega", 937);
        entities.put("alpha", 945);
        entities.put("beta", 946);
        entities.put("gamma", 947);
        entities.put("delta", 948);
        entities.put("epsilon", 949);
        entities.put("zeta", 950);
        entities.put("eta", 951);
        entities.put("theta", 952);
        entities.put("iota", 953);
        entities.put("kappa", 954);
        entities.put("lambda", 955);
        entities.put("mu", 956);
        entities.put("nu", 957);
        entities.put("xi", 958);
        entities.put("omicron", 959);
        entities.put("pi", 960);
        entities.put("rho", 961);
        entities.put("sigmaf", 962);
        entities.put("sigma", 963);
        entities.put("tau", 964);
        entities.put("upsilon", 965);
        entities.put("phi", 966);
        entities.put("chi", 967);
        entities.put("psi", 968);
        entities.put("omega", 969);
        entities.put("thetasym", 977);
        entities.put("upsih", 978);
        entities.put("piv", 982);
        entities.put("bull", 8226);
        entities.put("hellip", 8230);
        entities.put("prime", 8242);
        entities.put("Prime", 8243);
        entities.put("oline", 8254);
        entities.put("frasl", 8260);
        entities.put("weierp", 8472);
        entities.put("image", 8465);
        entities.put("real", 8476);
        entities.put("trade", 8482);
        entities.put("alefsym", 8501);
        entities.put("larr", 8592);
        entities.put("uarr", 8593);
        entities.put("rarr", 8594);
        entities.put("darr", 8595);
        entities.put("harr", 8596);
        entities.put("crarr", 8629);
        entities.put("lArr", 8656);
        entities.put("uArr", 8657);
        entities.put("rArr", 8658);
        entities.put("dArr", 8659);
        entities.put("hArr", 8660);
        entities.put("forall", 8704);
        entities.put("part", 8706);
        entities.put("exist", 8707);
        entities.put("empty", 8709);
        entities.put("nabla", 8711);
        entities.put("isin", 8712);
        entities.put("notin", 8713);
        entities.put("ni", 8715);
        entities.put("prod", 8719);
        entities.put("sum", 8721);
        entities.put("minus", 8722);
        entities.put("lowast", 8727);
        entities.put("radic", 8730);
        entities.put("prop", 8733);
        entities.put("infin", 8734);
        entities.put("ang", 8736);
        entities.put("and", 8743);
        entities.put("or", 8744);
        entities.put("cap", 8745);
        entities.put("cup", 8746);
        entities.put("int", 8747);
        entities.put("there4", 8756);
        entities.put("sim", 8764);
        entities.put("cong", 8773);
        entities.put("asymp", 8776);
        entities.put("ne", 8800);
        entities.put("equiv", 8801);
        entities.put("le", 8804);
        entities.put("ge", 8805);
        entities.put("sub", 8834);
        entities.put("sup", 8835);
        entities.put("nsub", 8836);
        entities.put("sube", 8838);
        entities.put("supe", 8839);
        entities.put("oplus", 8853);
        entities.put("otimes", 8855);
        entities.put("perp", 8869);
        entities.put("sdot", 8901);
        entities.put("lceil", 8968);
        entities.put("rceil", 8969);
        entities.put("lfloor", 8970);
        entities.put("rfloor", 8971);
        entities.put("lang", 9001);
        entities.put("rang", 9002);
        entities.put("loz", 9674);
        entities.put("spades", 9824);
        entities.put("clubs", 9827);
        entities.put("hearts", 9829);
        entities.put("diams", 9830);
        entities.put("OElig", 338);
        entities.put("oelig", 339);
        entities.put("Scaron", 352);
        entities.put("scaron", 353);
        entities.put("Yuml", 376);
        entities.put("circ", 710);
        entities.put("tilde", 732);
        entities.put("ensp", 8194);
        entities.put("emsp", 8195);
        entities.put("thinsp", 8201);
        entities.put("zwnj", 8204);
        entities.put("zwj", 8205);
        entities.put("lrm", 8206);
        entities.put("rlm", 8207);
        entities.put("ndash", 8211);
        entities.put("mdash", 8212);
        entities.put("lsquo", 8216);
        entities.put("rsquo", 8217);
        entities.put("sbquo", 8218);
        entities.put("ldquo", 8220);
        entities.put("rdquo", 8221);
        entities.put("bdquo", 8222);
        entities.put("dagger", 8224);
        entities.put("Dagger", 8225);
        entities.put("permil", 8240);
        entities.put("lsaquo", 8249);
        entities.put("rsaquo", 8250);
        entities.put("euro", 8364);
        ENTITY_TRIE = new PunctuationTrie(entities);
    }
}

