/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.Punctuation;
import com.google.caja.lexer.PunctuationTrie;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeMap;
import junit.framework.TestCase;

public class PunctuationTrieTest
extends TestCase {
    PunctuationTrie<?> jsPunc;
    PunctuationTrie<Integer> skinny;

    public void setUp() throws Exception {
        TreeMap<String, Object> jsPuncStrs = new TreeMap<String, Object>();
        for (Punctuation p : Punctuation.values()) {
            if (p.toString().equals("..")) continue;
            jsPuncStrs.put(p.toString(), null);
        }
        this.jsPunc = new PunctuationTrie(jsPuncStrs);
        this.skinny = new PunctuationTrie<Integer>(Collections.singletonMap("hellooooooo", 4));
    }

    public void tearDown() throws Exception {
        this.jsPunc = null;
        this.skinny = null;
    }

    public final void testTreeStructure() {
        String jsTree = "nonterminal\n\t'!' terminal\n\t\t'=' terminal\n\t\t\t'=' terminal\n\t'%' terminal\n\t\t'=' terminal\n\t'&' terminal\n\t\t'&' terminal\n\t\t\t'=' terminal\n\t\t'=' terminal\n\t'(' terminal\n\t')' terminal\n\t'*' terminal\n\t\t'=' terminal\n\t'+' terminal\n\t\t'+' terminal\n\t\t'=' terminal\n\t',' terminal\n\t'-' terminal\n\t\t'-' terminal\n\t\t'=' terminal\n\t'.' terminal\n\t\t'.' nonterminal\n\t\t\t'.' terminal\n\t'/' terminal\n\t\t'=' terminal\n\t':' terminal\n\t\t':' terminal\n\t';' terminal\n\t'<' terminal\n\t\t'<' terminal\n\t\t\t'=' terminal\n\t\t'=' terminal\n\t'=' terminal\n\t\t'=' terminal\n\t\t\t'=' terminal\n\t'>' terminal\n\t\t'=' terminal\n\t\t'>' terminal\n\t\t\t'=' terminal\n\t\t\t'>' terminal\n\t\t\t\t'=' terminal\n\t'?' terminal\n\t'[' terminal\n\t']' terminal\n\t'^' terminal\n\t\t'=' terminal\n\t'{' terminal\n\t'|' terminal\n\t\t'=' terminal\n\t\t'|' terminal\n\t\t\t'=' terminal\n\t'}' terminal\n\t'~' terminal";
        String skinnyTree = "nonterminal\n\t'h' nonterminal\n\t\t'e' nonterminal\n\t\t\t'l' nonterminal\n\t\t\t\t'l' nonterminal\n\t\t\t\t\t'o' nonterminal\n\t\t\t\t\t\t'o' nonterminal\n\t\t\t\t\t\t\t'o' nonterminal\n\t\t\t\t\t\t\t\t'o' nonterminal\n\t\t\t\t\t\t\t\t\t'o' nonterminal\n\t\t\t\t\t\t\t\t\t\t'o' nonterminal\n\t\t\t\t\t\t\t\t\t\t\t'o' terminal";
        PunctuationTrieTest.assertEquals((String)jsTree, (String)this.jsPunc.toString());
        PunctuationTrieTest.assertEquals((String)skinnyTree, (String)this.skinny.toString());
    }

    public final void testPunctuationTrie() {
        HashSet uniq = new HashSet();
        for (Punctuation p : Punctuation.values()) {
            if (p.toString().equals("..")) continue;
            PunctuationTrie<?> t = this.jsPunc.lookup(p.toString());
            PunctuationTrieTest.assertTrue((t != null && t.isTerminal() ? 1 : 0) != 0);
            PunctuationTrieTest.assertTrue((boolean)uniq.add(t));
        }
        PunctuationTrieTest.assertEquals(null, this.jsPunc.lookup("foo"));
        PunctuationTrieTest.assertEquals(null, this.jsPunc.lookup("hi"));
        PunctuationTrieTest.assertEquals(null, this.jsPunc.lookup("<<<<<<<"));
        PunctuationTrieTest.assertEquals(null, this.jsPunc.lookup("<<<<"));
        PunctuationTrieTest.assertEquals(null, this.jsPunc.lookup("===="));
        PunctuationTrieTest.assertTrue((!this.jsPunc.lookup("..").isTerminal() ? 1 : 0) != 0);
    }

    public final void testSkinnyTrie() {
        String s = "hellooooooo";
        PunctuationTrie<Integer> t = this.skinny;
        for (int i = 0; i < s.length(); ++i) {
            PunctuationTrieTest.assertTrue((!t.isTerminal() ? 1 : 0) != 0);
            PunctuationTrieTest.assertEquals(null, t.lookup(' '));
            PunctuationTrieTest.assertEquals(null, (Object)t.getValue());
            t = t.lookup(s.charAt(i));
        }
        PunctuationTrieTest.assertTrue((boolean)t.isTerminal());
        PunctuationTrieTest.assertEquals(null, t.lookup('o'));
        PunctuationTrieTest.assertEquals((int)4, (int)t.getValue());
    }
}

