/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.opensocial;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.opensocial.GadgetSpec;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.render.Concatenator;
import com.google.caja.reporting.MarkupRenderMode;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetParser {
    private static final String NS_URI = "http://opensocial.org/";
    private static final Namespaces MODULE_NS = new Namespaces(Namespaces.COMMON, "", "http://opensocial.org/");

    public GadgetSpec parse(CharProducer gadgetSpec, InputSource src, String view, MessageQueue mq) throws GadgetRewriteException, ParseException {
        HtmlLexer lexer = new HtmlLexer(gadgetSpec);
        lexer.setTreatedAsXml(true);
        Element el = new DomParser(new TokenQueue<HtmlTokenType>(lexer, src, DomParser.SKIP_COMMENTS), true, MODULE_NS, mq).parseDocument();
        Document doc = el.getOwnerDocument();
        GadgetSpec spec = new GadgetSpec();
        this.readModulePrefs(doc, spec);
        this.readRequiredFeatures(doc, spec);
        this.readContent(doc, spec, view);
        return spec;
    }

    private void readModulePrefs(Document doc, GadgetSpec spec) throws GadgetRewriteException {
        Element modulePrefs;
        Iterator<Element> els = GadgetParser.getElementsByTagNameNS(doc, "ModulePrefs").iterator();
        Element element = modulePrefs = els.hasNext() ? els.next() : null;
        if (modulePrefs == null || els.hasNext()) {
            throw new GadgetRewriteException("Must have exactly one <ModulePrefs>");
        }
        for (Attr attr : Nodes.attributesOf(modulePrefs)) {
            spec.getModulePrefs().put(attr.getNodeName(), attr.getNodeValue());
        }
    }

    private void readRequiredFeatures(Document doc, GadgetSpec spec) throws GadgetRewriteException {
        for (Element require : GadgetParser.getElementsByTagNameNS(doc, "Require")) {
            Attr feature = require.getAttributeNodeNS(NS_URI, "feature");
            if (feature == null) {
                throw new GadgetRewriteException("<Require> must have a \"feature\" attribute");
            }
            spec.getRequiredFeatures().add(feature.getNodeValue());
        }
    }

    private void readContent(Document doc, GadgetSpec spec, String view) throws GadgetRewriteException {
        for (final Element contentNode : GadgetParser.getElementsByTagNameNS(doc, "Content")) {
            Attr viewAttr = contentNode.getAttributeNodeNS(NS_URI, "view");
            if (viewAttr != null && !Arrays.asList(viewAttr.getNodeValue().trim().split("\\s*,\\s*")).contains(view)) continue;
            Attr typeAttr = contentNode.getAttributeNodeNS(NS_URI, "type");
            if (typeAttr == null) {
                throw new GadgetRewriteException("No 'type' attribute for view '" + view + "'");
            }
            String value = typeAttr.getNodeValue();
            if (!value.equals("html")) {
                throw new GadgetRewriteException("Can't handle Content type '" + value + "'");
            }
            spec.setContentType(value);
            spec.setContent(new GadgetSpec.CharProducerFactory(){

                public CharProducer producer() {
                    ArrayList<CharProducer> chunks = new ArrayList<CharProducer>();
                    for (Node node : Nodes.childrenOf(contentNode)) {
                        if (node.getNodeType() == 3) {
                            Text t = (Text)node;
                            FilePosition tpos = Nodes.getFilePositionFor(t);
                            String rawText = Nodes.getRawText(t);
                            String plainText = t.getNodeValue();
                            CharProducer cp = null;
                            if (rawText != null && !String.valueOf((cp = CharProducer.Factory.fromHtmlAttribute(CharProducer.Factory.create(new StringReader(rawText), tpos))).getBuffer(), cp.getOffset(), cp.getLength()).equals(plainText)) {
                                cp = null;
                            }
                            if (cp == null) {
                                cp = CharProducer.Factory.create(new StringReader(plainText), tpos);
                            }
                            chunks.add(cp);
                            continue;
                        }
                        if (node.getNodeType() != 4) continue;
                        String cdata = node.getNodeValue();
                        FilePosition pos = Nodes.getFilePositionFor(node);
                        pos = FilePosition.instance(pos.source(), pos.startLineNo(), pos.startCharInFile() + 9, pos.startCharInLine() + 9, pos.length() - 12);
                        chunks.add(CharProducer.Factory.create(new StringReader(cdata), pos));
                    }
                    return CharProducer.Factory.chain(chunks.toArray(new CharProducer[0]));
                }
            });
            return;
        }
        throw new GadgetRewriteException("No content for view '" + view + "'");
    }

    public void render(GadgetSpec gadgetSpec, Appendable output) throws IOException {
        Element rootElement = this.toDocument(gadgetSpec);
        Concatenator tc = new Concatenator(output, new Callback<IOException>(){

            @Override
            public void handle(IOException e) {
                throw new RenderFailure(e);
            }
        });
        RenderContext rc = new RenderContext(tc).withMarkupRenderMode(MarkupRenderMode.XML);
        Nodes.render(rootElement, MODULE_NS, rc);
        tc.noMoreTokens();
    }

    private Element toDocument(GadgetSpec gadgetSpec) throws IOException {
        Document doc = DomParser.makeDocument(null, null);
        Element modulePrefs = doc.createElementNS(NS_URI, "ModulePrefs");
        for (Map.Entry<String, String> e : gadgetSpec.getModulePrefs().entrySet()) {
            modulePrefs.setAttributeNS(NS_URI, e.getKey(), e.getValue());
        }
        for (String feature : gadgetSpec.getRequiredFeatures()) {
            Element featureEl = doc.createElementNS(NS_URI, "Require");
            featureEl.setAttributeNS(NS_URI, "feature", feature);
            modulePrefs.appendChild(featureEl);
        }
        Element content = doc.createElementNS(NS_URI, "Content");
        content.setAttributeNS(NS_URI, "type", gadgetSpec.getContentType());
        content.appendChild(doc.createCDATASection(this.drain(gadgetSpec.getContent())));
        Element module = doc.createElementNS(NS_URI, "Module");
        module.appendChild(modulePrefs);
        module.appendChild(content);
        doc.appendChild(module);
        return module;
    }

    private String drain(CharProducer cp) {
        return String.valueOf(cp.getBuffer(), cp.getOffset(), cp.getLimit() - cp.getOffset());
    }

    private static Iterable<Element> getElementsByTagNameNS(Document d, String localName) {
        NodeList elements = d.getElementsByTagNameNS(NS_URI, localName);
        return Nodes.nodeListIterable(elements, Element.class);
    }

    private static class RenderFailure
    extends SomethingWidgyHappenedError {
        RenderFailure(IOException ex) {
            this.initCause(ex);
        }
    }
}

