/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser;

import com.google.caja.SomethingWidgyHappenedError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class Normalizer {
    private static final Method IS_NORMALIZED;
    private static final Object NORMAL_FORM_C;

    Normalizer() {
    }

    public static boolean isNormalized(CharSequence s) {
        if (IS_NORMALIZED != null) {
            try {
                return (Boolean)IS_NORMALIZED.invoke(null, s, NORMAL_FORM_C);
            }
            catch (IllegalAccessException ex) {
                throw new SomethingWidgyHappenedError("Normalizer unexpectedly uninvokable", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                throw new SomethingWidgyHappenedError("Normalizer unexpectedly uninvokable", th);
            }
        }
        int i = s.length();
        while (--i >= 0) {
            char ch = s.charAt(i);
            if (ch < '\u0100') continue;
            return false;
        }
        return true;
    }

    static {
        Method isNormalized = null;
        Object normalFormC = null;
        try {
            Class<?> normalizer = Class.forName("java.text.Normalizer");
            Class<?> normalizerForm = Class.forName("java.text.Normalizer$Form");
            isNormalized = normalizer.getMethod("isNormalized", CharSequence.class, normalizerForm);
            normalFormC = normalizerForm.getField("NFC").get(null);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (IllegalAccessException ex) {
            throw new SomethingWidgyHappenedError("Normalizer exists but is unexpectedly inaccessible", (Throwable)ex);
        }
        catch (NoSuchFieldException ex) {
            throw new SomethingWidgyHappenedError("Normalizer.Form unexpectedly missing", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new SomethingWidgyHappenedError("Normalizer unexpectedly missing methods", (Throwable)ex);
        }
        IS_NORMALIZED = isNormalized;
        NORMAL_FORM_C = normalFormC;
    }
}

