/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.LabeledStatement;
import com.google.caja.parser.js.LabeledStmtWrapper;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class ParseTreeNodeTest
extends TestCase {
    LabeledStmtWrapper root;
    LabeledStmtWrapper b9;

    protected void setUp() throws Exception {
        super.setUp();
        FilePosition unk = FilePosition.UNKNOWN;
        ExpressionStmt[] b = new ExpressionStmt[13];
        int i = b.length;
        while (--i >= 0) {
            b[i] = new ExpressionStmt(unk, new IntegerLiteral(unk, i));
        }
        LabeledStmtWrapper b1 = new LabeledStmtWrapper(unk, "$1", new Block(unk, Arrays.asList(b[2], b[3], b[4])));
        LabeledStmtWrapper b5 = new LabeledStmtWrapper(unk, "$5", new Block(unk, Arrays.asList(b[6], b[7], b[8])));
        this.root = new LabeledStmtWrapper(unk, "$0", new Block(unk, Arrays.asList(b1, b5)));
        this.b9 = new LabeledStmtWrapper(unk, "$9", new Block(unk, Arrays.asList(b[10], b[11], b[12])));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.root = null;
    }

    public final void testFormatTree() throws Exception {
        StringBuilder sb = new StringBuilder();
        MessageContext mc = new MessageContext();
        this.root.formatTree(mc, 0, sb);
        ParseTreeNodeTest.assertEquals((String)"LabeledStmtWrapper : $0\n  Block\n    LabeledStmtWrapper : $1\n      Block\n        ExpressionStmt\n          IntegerLiteral : 2\n        ExpressionStmt\n          IntegerLiteral : 3\n        ExpressionStmt\n          IntegerLiteral : 4\n    LabeledStmtWrapper : $5\n      Block\n        ExpressionStmt\n          IntegerLiteral : 6\n        ExpressionStmt\n          IntegerLiteral : 7\n        ExpressionStmt\n          IntegerLiteral : 8", (String)sb.toString());
    }

    public final void testRender() {
        StringBuilder sb = new StringBuilder();
        JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(sb));
        this.root.render(new RenderContext(tc));
        tc.noMoreTokens();
        ParseTreeNodeTest.assertEquals((String)"$0: {\n  $1: {\n    2;\n    3;\n    4;\n  }\n  $5: {\n    6;\n    7;\n    8;\n  }\n}", (String)sb.toString());
    }

    public final void testVisitPreOrder() {
        IntEnqueuer ie = new IntEnqueuer();
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4, 5, 6, 7, 8]", (String)ie.getNums().toString());
    }

    public final void testVisitPreOrderReturnHandling() {
        IntEnqueuerExcept ie = new IntEnqueuerExcept(6L);
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4, 5, 6, 7, 8]", (String)ie.getNums().toString());
        ie = new IntEnqueuerExcept(1L);
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 5, 6, 7, 8]", (String)ie.getNums().toString());
    }

    public final void testVisitPostOrder() {
        IntEnqueuer ie = new IntEnqueuer();
        this.root.acceptPostOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[2, 3, 4, 1, 6, 7, 8, 5, 0]", (String)ie.getNums().toString());
    }

    public final void testVisitPostOrderReturnHandling() {
        IntEnqueuerExcept ie = new IntEnqueuerExcept(6L);
        this.root.acceptPostOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[2, 3, 4, 1, 6]", (String)ie.getNums().toString());
    }

    void doReplace() {
        ParseTreeNode rootBlock = this.root.children().get(0);
        ParseTreeNodeTest.assertTrue((boolean)(rootBlock instanceof Block));
        ParseTreeNode b5 = rootBlock.children().get(1);
        ParseTreeNodeTest.assertTrue((boolean)(b5 instanceof LabeledStatement));
        ParseTreeNodeTest.assertEquals((String)"$5", (String)((LabeledStatement)b5).getLabel());
        ((Block)rootBlock).replaceChild(this.b9, b5);
    }

    public final void testFormatTreePostReplace() throws Exception {
        this.doReplace();
        StringBuilder sb = new StringBuilder();
        MessageContext mc = new MessageContext();
        this.root.formatTree(mc, 0, sb);
        ParseTreeNodeTest.assertEquals((String)"LabeledStmtWrapper : $0\n  Block\n    LabeledStmtWrapper : $1\n      Block\n        ExpressionStmt\n          IntegerLiteral : 2\n        ExpressionStmt\n          IntegerLiteral : 3\n        ExpressionStmt\n          IntegerLiteral : 4\n    LabeledStmtWrapper : $9\n      Block\n        ExpressionStmt\n          IntegerLiteral : 10\n        ExpressionStmt\n          IntegerLiteral : 11\n        ExpressionStmt\n          IntegerLiteral : 12", (String)sb.toString());
    }

    public final void testRenderPostReplace() {
        this.doReplace();
        StringBuilder sb = new StringBuilder();
        JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(sb));
        this.root.render(new RenderContext(tc));
        tc.noMoreTokens();
        ParseTreeNodeTest.assertEquals((String)"$0: {\n  $1: {\n    2;\n    3;\n    4;\n  }\n  $9: {\n    10;\n    11;\n    12;\n  }\n}", (String)sb.toString());
    }

    public final void testVisitPreOrderPostReplace() {
        this.doReplace();
        IntEnqueuer ie = new IntEnqueuer();
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4, 9, 10, 11, 12]", (String)ie.getNums().toString());
    }

    public final void testVisitPreorderDoesntDescendIntoReplaced() {
        IntEnqueuerThatReplaces ie = new IntEnqueuerThatReplaces(5L, this.b9);
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4, 5]", (String)ie.getNums().toString());
    }

    void doInsert(int before) {
        ParseTreeNode b;
        ParseTreeNode rootBlock = this.root.children().get(0);
        ParseTreeNodeTest.assertTrue((boolean)(rootBlock instanceof Block));
        switch (before) {
            case -1: {
                b = null;
                break;
            }
            case 1: {
                b = rootBlock.children().get(0);
                break;
            }
            case 5: {
                b = rootBlock.children().get(1);
                break;
            }
            default: {
                ParseTreeNodeTest.fail((String)String.valueOf(before));
                return;
            }
        }
        if (null != b) {
            ParseTreeNodeTest.assertTrue((boolean)(b instanceof LabeledStatement));
            ParseTreeNodeTest.assertEquals((String)("$" + before), (String)((LabeledStatement)b).getLabel());
        } else {
            ParseTreeNodeTest.assertEquals((int)-1, (int)before);
        }
        ((Block)rootBlock).insertBefore(this.b9, b);
    }

    public final void testFormatTreePostInsert() throws Exception {
        this.doInsert(5);
        StringBuilder sb = new StringBuilder();
        MessageContext mc = new MessageContext();
        this.root.formatTree(mc, 0, sb);
        ParseTreeNodeTest.assertEquals((String)"LabeledStmtWrapper : $0\n  Block\n    LabeledStmtWrapper : $1\n      Block\n        ExpressionStmt\n          IntegerLiteral : 2\n        ExpressionStmt\n          IntegerLiteral : 3\n        ExpressionStmt\n          IntegerLiteral : 4\n    LabeledStmtWrapper : $9\n      Block\n        ExpressionStmt\n          IntegerLiteral : 10\n        ExpressionStmt\n          IntegerLiteral : 11\n        ExpressionStmt\n          IntegerLiteral : 12\n    LabeledStmtWrapper : $5\n      Block\n        ExpressionStmt\n          IntegerLiteral : 6\n        ExpressionStmt\n          IntegerLiteral : 7\n        ExpressionStmt\n          IntegerLiteral : 8", (String)sb.toString());
    }

    public final void testRenderPostInsert() {
        this.doInsert(5);
        StringBuilder sb = new StringBuilder();
        JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(sb));
        this.root.render(new RenderContext(tc));
        tc.noMoreTokens();
        ParseTreeNodeTest.assertEquals((String)"$0: {\n  $1: {\n    2;\n    3;\n    4;\n  }\n  $9: {\n    10;\n    11;\n    12;\n  }\n  $5: {\n    6;\n    7;\n    8;\n  }\n}", (String)sb.toString());
    }

    public final void testVisitPreOrderPostInsert() {
        this.doInsert(5);
        IntEnqueuer ie = new IntEnqueuer();
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4, 9, 10, 11, 12, 5, 6, 7, 8]", (String)ie.getNums().toString());
    }

    public final void testVisitPreorderDoesntDescendIntoInserted() {
        IntEnqueuerThatInserts ie = new IntEnqueuerThatInserts(5L, this.b9);
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4, 5, 6, 7, 8]", (String)ie.getNums().toString());
    }

    public final void testVisitPostOrderDoesntDescendIntoInserted() {
        IntEnqueuerThatInserts ie = new IntEnqueuerThatInserts(5L, this.b9);
        this.root.acceptPostOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[2, 3, 4, 1, 6, 7, 8, 5, 0]", (String)ie.getNums().toString());
    }

    public final void testFormatTreePostInsert2() throws Exception {
        this.doInsert(1);
        StringBuilder sb = new StringBuilder();
        MessageContext mc = new MessageContext();
        this.root.formatTree(mc, 0, sb);
        ParseTreeNodeTest.assertEquals((String)"LabeledStmtWrapper : $0\n  Block\n    LabeledStmtWrapper : $9\n      Block\n        ExpressionStmt\n          IntegerLiteral : 10\n        ExpressionStmt\n          IntegerLiteral : 11\n        ExpressionStmt\n          IntegerLiteral : 12\n    LabeledStmtWrapper : $1\n      Block\n        ExpressionStmt\n          IntegerLiteral : 2\n        ExpressionStmt\n          IntegerLiteral : 3\n        ExpressionStmt\n          IntegerLiteral : 4\n    LabeledStmtWrapper : $5\n      Block\n        ExpressionStmt\n          IntegerLiteral : 6\n        ExpressionStmt\n          IntegerLiteral : 7\n        ExpressionStmt\n          IntegerLiteral : 8", (String)sb.toString());
    }

    public final void testRenderPostInsert2() {
        this.doInsert(1);
        StringBuilder sb = new StringBuilder();
        JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(sb));
        this.root.render(new RenderContext(tc));
        tc.noMoreTokens();
        ParseTreeNodeTest.assertEquals((String)"$0: {\n  $9: {\n    10;\n    11;\n    12;\n  }\n  $1: {\n    2;\n    3;\n    4;\n  }\n  $5: {\n    6;\n    7;\n    8;\n  }\n}", (String)sb.toString());
    }

    public final void testVisitPreOrderPostInsert2() {
        this.doInsert(1);
        IntEnqueuer ie = new IntEnqueuer();
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8]", (String)ie.getNums().toString());
    }

    public final void testVisitPreorderDoesntDescendIntoInserted2() {
        IntEnqueuerThatInserts ie = new IntEnqueuerThatInserts(1L, this.b9);
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4, 5, 6, 7, 8]", (String)ie.getNums().toString());
    }

    public final void testVisitPostOrderDoesntDescendIntoInserted2() {
        IntEnqueuerThatInserts ie = new IntEnqueuerThatInserts(1L, this.b9);
        this.root.acceptPostOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[2, 3, 4, 1, 6, 7, 8, 5, 0]", (String)ie.getNums().toString());
    }

    public final void testFormatTreePostInsert3() throws Exception {
        this.doInsert(-1);
        StringBuilder sb = new StringBuilder();
        MessageContext mc = new MessageContext();
        this.root.formatTree(mc, 0, sb);
        ParseTreeNodeTest.assertEquals((String)"LabeledStmtWrapper : $0\n  Block\n    LabeledStmtWrapper : $1\n      Block\n        ExpressionStmt\n          IntegerLiteral : 2\n        ExpressionStmt\n          IntegerLiteral : 3\n        ExpressionStmt\n          IntegerLiteral : 4\n    LabeledStmtWrapper : $5\n      Block\n        ExpressionStmt\n          IntegerLiteral : 6\n        ExpressionStmt\n          IntegerLiteral : 7\n        ExpressionStmt\n          IntegerLiteral : 8\n    LabeledStmtWrapper : $9\n      Block\n        ExpressionStmt\n          IntegerLiteral : 10\n        ExpressionStmt\n          IntegerLiteral : 11\n        ExpressionStmt\n          IntegerLiteral : 12", (String)sb.toString());
    }

    public final void testRenderPostInsert3() {
        this.doInsert(-1);
        StringBuilder sb = new StringBuilder();
        JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(sb));
        this.root.render(new RenderContext(tc));
        tc.noMoreTokens();
        ParseTreeNodeTest.assertEquals((String)"$0: {\n  $1: {\n    2;\n    3;\n    4;\n  }\n  $5: {\n    6;\n    7;\n    8;\n  }\n  $9: {\n    10;\n    11;\n    12;\n  }\n}", (String)sb.toString());
    }

    public final void testVisitPreOrderPostInsert3() {
        this.doInsert(-1);
        IntEnqueuer ie = new IntEnqueuer();
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]", (String)ie.getNums().toString());
    }

    void doRemove(int num) {
        ParseTreeNode b;
        ParseTreeNode rootBlock = this.root.children().get(0);
        ParseTreeNodeTest.assertTrue((boolean)(rootBlock instanceof Block));
        switch (num) {
            case 1: {
                b = rootBlock.children().get(0);
                break;
            }
            case 5: {
                b = rootBlock.children().get(1);
                break;
            }
            default: {
                ParseTreeNodeTest.fail((String)String.valueOf(num));
                return;
            }
        }
        ParseTreeNodeTest.assertTrue((boolean)(b instanceof LabeledStatement));
        ParseTreeNodeTest.assertEquals((String)("$" + num), (String)((LabeledStatement)b).getLabel());
        ((Block)rootBlock).removeChild(b);
    }

    public final void testFormatTreePostRemove() throws Exception {
        this.doRemove(5);
        StringBuilder sb = new StringBuilder();
        MessageContext mc = new MessageContext();
        this.root.formatTree(mc, 0, sb);
        ParseTreeNodeTest.assertEquals((String)"LabeledStmtWrapper : $0\n  Block\n    LabeledStmtWrapper : $1\n      Block\n        ExpressionStmt\n          IntegerLiteral : 2\n        ExpressionStmt\n          IntegerLiteral : 3\n        ExpressionStmt\n          IntegerLiteral : 4", (String)sb.toString());
    }

    public final void testRenderPostRemove() {
        this.doRemove(5);
        StringBuilder sb = new StringBuilder();
        JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(sb));
        this.root.render(new RenderContext(tc));
        tc.noMoreTokens();
        ParseTreeNodeTest.assertEquals((String)"$0: {\n  $1: {\n    2;\n    3;\n    4;\n  }\n}", (String)sb.toString());
    }

    public final void testVisitPreOrderPostRemove() {
        this.doRemove(5);
        IntEnqueuer ie = new IntEnqueuer();
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4]", (String)ie.getNums().toString());
    }

    public final void testVisitPostOrderPostRemove() {
        this.doRemove(5);
        IntEnqueuer ie = new IntEnqueuer();
        this.root.acceptPostOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[2, 3, 4, 1, 0]", (String)ie.getNums().toString());
    }

    public final void testVisitPreorderDoesntDescendIntoRemoved() {
        IntEnqueuerThatRemoves ie = new IntEnqueuerThatRemoves(5L);
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4, 5]", (String)ie.getNums().toString());
    }

    public final void testVisitPostOrderDescendsIntoRemoved() {
        IntEnqueuerThatRemoves ie = new IntEnqueuerThatRemoves(5L);
        this.root.acceptPostOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[2, 3, 4, 1, 6, 7, 8, 5, 0]", (String)ie.getNums().toString());
    }

    public final void testFormatTreePostRemove2() throws Exception {
        this.doRemove(1);
        StringBuilder sb = new StringBuilder();
        MessageContext mc = new MessageContext();
        this.root.formatTree(mc, 0, sb);
        ParseTreeNodeTest.assertEquals((String)"LabeledStmtWrapper : $0\n  Block\n    LabeledStmtWrapper : $5\n      Block\n        ExpressionStmt\n          IntegerLiteral : 6\n        ExpressionStmt\n          IntegerLiteral : 7\n        ExpressionStmt\n          IntegerLiteral : 8", (String)sb.toString());
    }

    public final void testRenderPostRemove2() {
        this.doRemove(1);
        StringBuilder sb = new StringBuilder();
        JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(sb));
        this.root.render(new RenderContext(tc));
        tc.noMoreTokens();
        ParseTreeNodeTest.assertEquals((String)"$0: {\n  $5: {\n    6;\n    7;\n    8;\n  }\n}", (String)sb.toString());
    }

    public final void testVisitPreOrderPostRemove2() {
        this.doRemove(1);
        IntEnqueuer ie = new IntEnqueuer();
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 5, 6, 7, 8]", (String)ie.getNums().toString());
    }

    public final void testVisitPostOrderPostRemove2() {
        this.doRemove(1);
        IntEnqueuer ie = new IntEnqueuer();
        this.root.acceptPostOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[6, 7, 8, 5, 0]", (String)ie.getNums().toString());
    }

    public final void testVisitPreorderDoesntDescendIntoRemoved2() {
        IntEnqueuerThatRemoves ie = new IntEnqueuerThatRemoves(1L);
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 5, 6, 7, 8]", (String)ie.getNums().toString());
    }

    public final void testVisitPostOrderDescendsIntoRemoved2() {
        IntEnqueuerThatRemoves ie = new IntEnqueuerThatRemoves(1L);
        this.root.acceptPostOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[2, 3, 4, 1, 6, 7, 8, 5, 0]", (String)ie.getNums().toString());
    }

    public final void testVisitPostOrderProceedsWhenNextDeleted() {
        this.doInsert(-1);
        IntEnqueuerThatMungesSiblings ie = new IntEnqueuerThatMungesSiblings(6L, new long[]{6L, 7L}, new long[0]);
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4, 5, 8, 9, 10, 11, 12]", (String)ie.getNums().toString());
    }

    public final void testVisitPostOrderProceedsWhenAllNextDeleted1() {
        this.doInsert(-1);
        IntEnqueuerThatMungesSiblings ie = new IntEnqueuerThatMungesSiblings(7L, new long[]{7L, 8L}, new long[]{13L});
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4, 5, 6, 13, 9, 10, 11, 12]", (String)ie.getNums().toString());
    }

    public final void testVisitPostOrderProceedsWhenAllNextDeleted2() {
        this.doInsert(-1);
        IntEnqueuerThatMungesSiblings ie = new IntEnqueuerThatMungesSiblings(6L, new long[]{6L, 7L, 8L}, new long[0]);
        this.root.acceptPreOrder(ie, null);
        ParseTreeNodeTest.assertEquals((String)"[0, 1, 2, 3, 4, 5, 9, 10, 11, 12]", (String)ie.getNums().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntEnqueuerThatMungesSiblings
    extends IntEnqueuer {
        private Set<Long> toRemove;
        private long[] toAdd;
        private long remover;

        IntEnqueuerThatMungesSiblings(long remover, long[] toRemove, long[] toAdd) {
            this.remover = remover;
            this.toRemove = new HashSet<Long>();
            for (int i = 0; i < toRemove.length; ++i) {
                this.toRemove.add(toRemove[i]);
            }
            this.toAdd = (long[])toAdd.clone();
        }

        @Override
        public boolean visit(AncestorChain<?> ancestors) {
            Object n = ancestors.node;
            this.processNode((ParseTreeNode)n);
            if (n instanceof ExpressionStmt && ((IntegerLiteral)n.children().get(0)).getValue().longValue() == this.remover) {
                MutableParseTreeNode p = (MutableParseTreeNode)ancestors.parent.node;
                ArrayList<? extends ParseTreeNode> siblings = new ArrayList<ParseTreeNode>(p.children());
                for (ParseTreeNode parseTreeNode : siblings) {
                    Number num = ((IntegerLiteral)parseTreeNode.children().get(0)).getValue();
                    if (!this.toRemove.contains(num.longValue())) continue;
                    p.removeChild(parseTreeNode);
                }
                for (int i = 0; i < this.toAdd.length; ++i) {
                    p.appendChild(new ExpressionStmt(FilePosition.UNKNOWN, new IntegerLiteral(FilePosition.UNKNOWN, this.toAdd[i])));
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntEnqueuerThatRemoves
    extends IntEnqueuer {
        private long toRemove;

        IntEnqueuerThatRemoves(long toRemove) {
            this.toRemove = toRemove;
        }

        @Override
        public boolean visit(AncestorChain<?> ancestors) {
            Object n = ancestors.node;
            Number num = this.processNode((ParseTreeNode)n);
            if (null != num && num.longValue() == this.toRemove) {
                ((MutableParseTreeNode)ancestors.parent.node).removeChild((ParseTreeNode)n);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntEnqueuerThatInserts
    extends IntEnqueuer {
        private long num;
        private ParseTreeNode toInsert;

        IntEnqueuerThatInserts(long num, ParseTreeNode toInsert) {
            this.num = num;
            this.toInsert = toInsert;
        }

        @Override
        public boolean visit(AncestorChain<?> ancestors) {
            Object n = ancestors.node;
            Number num = this.processNode((ParseTreeNode)n);
            if (null != num && num.longValue() == this.num) {
                ((MutableParseTreeNode)ancestors.parent.node).insertBefore(this.toInsert, (ParseTreeNode)n);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntEnqueuerThatReplaces
    extends IntEnqueuer {
        private long toReplace;
        private ParseTreeNode replacement;

        IntEnqueuerThatReplaces(long toReplace, ParseTreeNode replacement) {
            this.toReplace = toReplace;
            this.replacement = replacement;
        }

        @Override
        public boolean visit(AncestorChain<?> ancestors) {
            Object n = ancestors.node;
            Number num = this.processNode((ParseTreeNode)n);
            if (null != num && num.longValue() == this.toReplace) {
                ((MutableParseTreeNode)ancestors.parent.node).replaceChild(this.replacement, (ParseTreeNode)n);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntEnqueuerExcept
    extends IntEnqueuer {
        private long exception;

        IntEnqueuerExcept(long exception) {
            this.exception = exception;
        }

        @Override
        public boolean visit(AncestorChain<?> ancestors) {
            Object n = ancestors.node;
            Number num = this.processNode((ParseTreeNode)n);
            return num == null || this.exception != num.longValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntEnqueuer
    implements Visitor {
        private List<Number> nums = new ArrayList<Number>();

        IntEnqueuer() {
        }

        protected final Number processNode(ParseTreeNode n) {
            Number num;
            if (n instanceof IntegerLiteral) {
                num = ((IntegerLiteral)n).getValue();
            } else if (n instanceof LabeledStatement) {
                num = Long.valueOf(((LabeledStatement)n).getLabel().substring(1));
            } else {
                return null;
            }
            this.nums.add(num);
            return num;
        }

        @Override
        public boolean visit(AncestorChain<?> ancestors) {
            this.processNode((ParseTreeNode)ancestors.node);
            return true;
        }

        List<Number> getNums() {
            return this.nums;
        }
    }
}

