/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.Token;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AttrStub {
    final Token<HtmlTokenType> nameTok;
    final Token<HtmlTokenType> valueTok;
    final String value;

    AttrStub(Token<HtmlTokenType> nameTok, Token<HtmlTokenType> valueTok, String value) {
        this.nameTok = nameTok;
        this.valueTok = valueTok;
        this.value = value;
    }

    Namespaces toNamespace(Namespaces ns, MessageQueue mq) {
        String rawName = this.nameTok.text;
        if (rawName.startsWith("xmlns")) {
            if (rawName.length() == 5) {
                return new Namespaces(ns, "", this.value);
            }
            if (':' == rawName.charAt(5)) {
                String prefix = rawName.substring(6);
                if ("".equals(prefix) || "xml".equals(prefix) || "xmlns".equals(prefix)) {
                    mq.addMessage((MessageTypeInt)MessageType.ILLEGAL_NAMESPACE_NAME, this.nameTok.pos, MessagePart.Factory.valueOf(prefix));
                } else {
                    return new Namespaces(ns, prefix, this.value);
                }
            }
        }
        return null;
    }

    Attr toAttr(Document doc, String attrUri, String attrQName) {
        Attr attrNode = doc.createAttributeNS(attrUri, attrQName);
        attrNode.setValue(this.value);
        Nodes.setFilePositionFor(attrNode, this.nameTok.pos);
        Nodes.setFilePositionForValue(attrNode, this.valueTok.pos);
        Nodes.setRawValue(attrNode, this.valueTok.text);
        return attrNode;
    }
}

