/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.util.Strings;

public final class Namespaces {
    public final Namespaces parent;
    public final String prefix;
    public final String uri;
    public static final String HTML_NAMESPACE_URI = "http://www.w3.org/1999/xhtml";
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    public static final String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    public static final String SVG_NAMESPACE_URI = "http://www.w3.org/2000/svg";
    private static final Namespaces XMLNS = new Namespaces("xmlns", "http://www.w3.org/2000/xmlns/");
    public static final Namespaces XML_SPECIAL = new Namespaces(XMLNS, "xml", "http://www.w3.org/XML/1998/namespace");
    public static final Namespaces XLINK = new Namespaces(XML_SPECIAL, "xlink", "http://www.w3.org/1999/xlink");
    public static final Namespaces IHTML = new Namespaces(XLINK, "ihtml", "http://code.google.com/p/google-caja/ihtml");
    public static final Namespaces COMMON = new Namespaces(new Namespaces(new Namespaces(new Namespaces(IHTML, "xsl", "http://www.w3.org/1999/XSL/Transform"), "os", "http://ns.opensocial.org/2008/markup"), "svg", "http://www.w3.org/2000/svg"), "html", "http://www.w3.org/1999/xhtml");
    public static final Namespaces HTML_DEFAULT = new Namespaces(COMMON, "", "http://www.w3.org/1999/xhtml");
    private Namespaces lastForUri;
    private Namespaces lastForPrefix;

    public Namespaces(Namespaces parent, String prefix, String uri) {
        assert (parent != null);
        assert (prefix.indexOf(58) < 0);
        this.parent = parent;
        this.prefix = prefix;
        this.uri = uri.intern();
    }

    private Namespaces(String prefix, String uri) {
        this.parent = null;
        this.prefix = prefix;
        this.uri = uri.intern();
    }

    public static boolean isHtml(String namespaceUri) {
        return HTML_NAMESPACE_URI.equals(namespaceUri);
    }

    public static String localName(String uri, String qualifiedName) {
        String localName = qualifiedName.substring(qualifiedName.indexOf(58) + 1);
        return Namespaces.isHtml(uri) ? Strings.toLowerCase(localName) : localName;
    }

    public Namespaces forElementName(String qname) {
        int index = qname.indexOf(58);
        return this.forPrefix(qname, index < 0 ? 0 : index);
    }

    public Namespaces forAttrName(Namespaces elNs, String qname) {
        if ("xmlns".equals(qname)) {
            return XMLNS;
        }
        int index = qname.indexOf(58);
        if (index < 0) {
            return elNs;
        }
        return this.forPrefix(qname, index < 0 ? 0 : index);
    }

    public Namespaces forPrefix(String prefix) {
        return this.forPrefix(prefix, prefix.length());
    }

    private Namespaces forPrefix(String qname, int colon) {
        if (this.lastForPrefix != null && colon == this.lastForPrefix.prefix.length() && qname.regionMatches(0, this.lastForPrefix.prefix, 0, colon)) {
            return this.lastForPrefix;
        }
        Namespaces ns = Namespaces.forPrefix(this, qname, colon);
        if (ns != null) {
            this.lastForPrefix = ns;
        }
        return ns;
    }

    private static Namespaces forPrefix(Namespaces ns, String qname, int end) {
        do {
            if (end != ns.prefix.length() || !ns.prefix.regionMatches(0, qname, 0, end)) continue;
            return ns;
        } while ((ns = ns.parent) != null);
        return null;
    }

    public Namespaces forUri(String uri) {
        uri = uri.intern();
        if (this.lastForUri != null && uri == this.lastForUri.uri) {
            return this.lastForUri;
        }
        Namespaces ns = Namespaces.forUri(this, uri);
        if (ns != null) {
            this.lastForUri = ns;
        }
        return ns;
    }

    private static Namespaces forUri(Namespaces ns, String uri) {
        Namespaces p = ns;
        block0: do {
            if (p.uri != uri) continue;
            Namespaces c = ns;
            while (c != p) {
                if (p.prefix.equals(c.prefix)) continue block0;
                c = c.parent;
            }
            return p;
        } while ((p = p.parent) != null);
        return null;
    }

    public String toString() {
        return "[" + (this.prefix.length() != 0 ? "xmlns:" + this.prefix : "xmlns") + "=" + this.uri + "]";
    }
}

