/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.Token;
import com.google.caja.parser.html.AbstractElementStack;
import com.google.caja.parser.html.AttrStub;
import com.google.caja.parser.html.DomParserMessageType;
import com.google.caja.parser.html.IllegalDocumentStateException;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlElementStack
extends AbstractElementStack {
    private final MessageQueue mq;

    XmlElementStack(Document doc, Namespaces ns, boolean needsDebugData, MessageQueue mq) {
        super(doc, ns, needsDebugData);
        this.mq = mq;
    }

    @Override
    public boolean needsNamespaceFixup() {
        return false;
    }

    @Override
    public void processTag(Token<HtmlTokenType> start, Token<HtmlTokenType> end, List<AttrStub> attrs) throws IllegalDocumentStateException {
        assert (start.type == HtmlTokenType.TAGBEGIN);
        assert (end.type == HtmlTokenType.TAGEND);
        boolean open = !start.text.startsWith("</");
        this.processTag(start.text.substring(open ? 1 : 2), open, start, end, attrs);
    }

    private void processTag(String elQName, boolean open, Token<HtmlTokenType> start, Token<HtmlTokenType> end, List<AttrStub> attrs) throws IllegalDocumentStateException {
        if (open) {
            AbstractElementStack.OpenNode bottom = this.getBottom();
            Namespaces ns = bottom.ns;
            Iterator<AttrStub> it = attrs.iterator();
            while (it.hasNext()) {
                AttrStub a = it.next();
                Namespaces fromAttr = a.toNamespace(ns, this.mq);
                if (fromAttr == null) continue;
                ns = fromAttr;
                it.remove();
            }
            Namespaces elNs = ns.forElementName(elQName);
            if (elNs == null) {
                elNs = ns = XmlElementStack.unknownNamespace(start.pos, ns, elQName, this.mq);
            }
            Element newElement = this.doc.createElementNS(elNs.uri, elQName);
            for (AttrStub a : attrs) {
                String localAttrName;
                String attrQName = a.nameTok.text;
                Namespaces attrNs = ns.forAttrName(elNs, attrQName);
                if (attrNs == null) {
                    attrNs = ns = XmlElementStack.unknownNamespace(a.nameTok.pos, ns, attrQName, this.mq);
                }
                if (!newElement.hasAttributeNS(attrNs.uri, localAttrName = Namespaces.localName(attrNs.uri, attrQName))) {
                    if (this.needsDebugData) {
                        Attr attrNode = a.toAttr(this.doc, attrNs.uri, attrQName);
                        newElement.setAttributeNodeNS(attrNode);
                        continue;
                    }
                    newElement.setAttributeNS(attrNs.uri, attrQName, a.value);
                    continue;
                }
                this.mq.addMessage((MessageTypeInt)MessageType.DUPLICATE_ATTRIBUTE, a.nameTok.pos, MessagePart.Factory.valueOf(attrQName), Nodes.getFilePositionFor(newElement.getAttributeNodeNS(attrNs.uri, localAttrName)));
            }
            if (this.needsDebugData) {
                Nodes.setFilePositionFor(newElement, FilePosition.span(start.pos, end.pos));
            }
            if ("/>".equals(end.text)) {
                this.doAppend(newElement, bottom.n);
            } else {
                this.push(newElement, ns, elQName);
            }
        } else {
            String bottomElementName = this.getBottom().qname;
            if (!elQName.equals(bottomElementName)) {
                throw new IllegalDocumentStateException(new Message((MessageTypeInt)DomParserMessageType.UNMATCHED_END, start.pos, MessagePart.Factory.valueOf(start.text), MessagePart.Factory.valueOf("<" + bottomElementName)));
            }
            this.popN(1, end.pos);
        }
    }

    @Override
    public void processText(Token<HtmlTokenType> text) {
        Text textNode;
        Node parent = this.getBottom().n;
        switch ((HtmlTokenType)text.type) {
            case CDATA: {
                textNode = this.doc.createCDATASection(text.text.substring(9, text.text.length() - 3));
                break;
            }
            case TEXT: {
                Node lastSibling = parent.getLastChild();
                if (lastSibling != null && lastSibling.getNodeType() == 3) {
                    Text combined = this.doc.createTextNode(lastSibling.getNodeValue() + Nodes.decode(text.text));
                    if (this.needsDebugData) {
                        Nodes.setRawText(combined, Nodes.getRawText((Text)lastSibling) + text.text);
                        Nodes.setFilePositionFor(combined, FilePosition.span(Nodes.getFilePositionFor(lastSibling), text.pos));
                    }
                    parent.replaceChild(combined, lastSibling);
                    return;
                }
                textNode = this.doc.createTextNode(Nodes.decode(text.text));
                break;
            }
            case UNESCAPED: {
                textNode = this.doc.createTextNode(text.text);
                break;
            }
            default: {
                throw new IllegalArgumentException(text.toString());
            }
        }
        if (this.needsDebugData) {
            Nodes.setRawText(textNode, text.text);
            Nodes.setFilePositionFor(textNode, text.pos);
        }
        this.doAppend(textNode, parent);
    }

    @Override
    public void processComment(Token<HtmlTokenType> commentToken) {
        String text = commentToken.text.substring("<!--".length(), commentToken.text.lastIndexOf("--"));
        Comment comment = this.doc.createComment(text);
        if (this.needsDebugData) {
            Nodes.setFilePositionFor(comment, commentToken.pos);
        }
        this.doAppend(comment, this.getBottom().n);
    }

    @Override
    public void finish(FilePosition endOfDocument) throws IllegalDocumentStateException {
        int nOpen;
        this.stripIgnorableText();
        DocumentFragment root = this.getRootElement();
        if (this.needsDebugData) {
            FilePosition rootStart = Nodes.getFilePositionFor(root);
            if (rootStart == null || InputSource.UNKNOWN.equals(rootStart.source())) {
                rootStart = root.getFirstChild() == null ? endOfDocument : Nodes.getFilePositionFor(root.getFirstChild());
            }
            if (rootStart.startCharInFile() <= endOfDocument.startCharInFile()) {
                Nodes.setFilePositionFor(root, FilePosition.span(rootStart, endOfDocument));
            }
        }
        if ((nOpen = this.getNOpenElements()) != 1) {
            Element openEl = this.getElement(nOpen - 1);
            throw new IllegalDocumentStateException(new Message((MessageTypeInt)DomParserMessageType.MISSING_END, endOfDocument, MessagePart.Factory.valueOf(openEl.getTagName()), Nodes.getFilePositionFor(openEl)));
        }
    }

    @Override
    public String fixBrokenEntities(String rawText, FilePosition textPos) {
        return rawText;
    }
}

