/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.ParseException;
import com.google.caja.util.CajaTestCase;

public class FuzzedParserTest
extends CajaTestCase {
    public final void testParse1() {
        this.throwsParseException("if(++(({y:5, toString: function() { return this; } }))) {switch((+[<><x><y/></x></> for each (x in this)])) { case ([window, this] = x%=0.1): var x = *; case <y><z/></y>: ; }<y><z/></y>; const this; } else  if ( /* Comment */new (x = [[]])(({y:5, toString: function() { return this; } }).@*)) {(<y><z/></y>);*; }");
    }

    public final void testParse2() {
        this.throwsParseException("for(var x in ((/a/gi)(window.x))){do {gc } while(0);if( /x/  != false--) { /x/gx;continue M; } else /*noex infloop*/for(x; y; <y><z/></y>) {(-3/0); } }");
    }

    public final void testParse3() {
        this.throwsParseException("with({x: ([Math.sin])})L:switch(((new (true)()++).__iterator");
    }

    public final void testParse4() {
        this.throwsParseException("/* HOISTY2 */for(let [x, x] = ({})-- in <x><y/></x>) {gc()th");
    }

    public final void testParse305() {
        this.throwsParseException("L: for ([x, x] in [15,16,17,18].filter(/a/gi, undefined)++) {throw StopIteration; }");
    }

    public final void testParse690() {
        this.throwsParseException("if((let (x=3,y=4) (true++))) {return; } else  if ( /* Comment */this) import x.*;");
    }

    public final void testParse692() {
        this.throwsParseException("L:if([15,16,17,18].some(x = y, let (x = 3) ++<><x><y/></x></>)) {return; } else  if (<x/>) gc()");
    }

    public final void testParse564() {
        this.throwsParseException("/* HOISTY1 */M:for(var x = ({y:5, valueOf: eval(\"x\", null--)}) in <y><z/></y>.x ? ([11,12,13,14].filter) : NaN+=\"\" ) 1e-81; const window;");
    }

    public final void testParse477() {
        this.throwsParseException("/*infloop*/do while( \"\" );");
    }

    public final void testParse478() throws ParseException {
        this.parseString("do while(true); while(true);");
    }

    private void throwsParseException(String fuzzString) {
        try {
            this.parseString(fuzzString);
        }
        catch (ParseException e) {
            return;
        }
        FuzzedParserTest.fail((String)("Expected failure for " + fuzzString));
    }

    private void parseString(String fuzzString) throws ParseException {
        this.js(this.fromString(fuzzString));
    }
}

