/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.parser.js.NumberLiteral;
import java.math.BigDecimal;
import junit.framework.TestCase;

public class NumberLiteralTest
extends TestCase {
    public final void testNumberToString() {
        NumberLiteralTest.assertEquals((String)"NaN", (String)NumberLiteral.numberToString(Double.NaN));
        NumberLiteralTest.assertEquals((String)"Infinity", (String)NumberLiteral.numberToString(Double.POSITIVE_INFINITY));
        NumberLiteralTest.assertEquals((String)"-Infinity", (String)NumberLiteral.numberToString(Double.NEGATIVE_INFINITY));
        NumberLiteralTest.assertEquals((String)"0", (String)NumberLiteral.numberToString(0.0));
        NumberLiteralTest.assertEquals((String)"0", (String)NumberLiteral.numberToString(-0.0));
        NumberLiteralTest.assertEquals((String)"1", (String)NumberLiteral.numberToString(1.0));
        NumberLiteralTest.assertEquals((String)"-1", (String)NumberLiteral.numberToString(-1.0));
        this.assertNumberToString("-0.1", "-0.1");
        this.assertNumberToString("0.1", ".1");
        this.assertNumberToString("0.1", "00.100");
        this.assertNumberToString("0.00001", "0.00001");
        this.assertNumberToString("0.000011", "0.000011");
        this.assertNumberToString("0.000099", "0.000099");
        this.assertNumberToString("0.0000999999999999999999999", "0.0000999999999999999999999999");
        this.assertNumberToString("0.000199999999999999999999", "0.000199999999999999999999999");
        this.assertNumberToString("0.000199999999999999999999", "0.000199999999999999999999989");
        this.assertNumberToString("9.9e-25", "0.00000000000000000000000099");
        this.assertNumberToString("1e+31", "10000000000000000000000000000000");
        this.assertNumberToString("1.1e+31", "11000000000000000000000000000000");
        this.assertNumberToString("9.9e+31", "99000000000000000000000000000000");
        this.assertNumberToString("9.99999999999999999999e+31", "99999999999999999999999999999999");
    }

    private void assertNumberToString(String golden, String input) {
        NumberLiteralTest.assertEquals((String)input, (String)golden, (String)NumberLiteral.numberToString(new BigDecimal(input)));
    }
}

