/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.TryStmt;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.util.CajaTestCase;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeTest
extends CajaTestCase {
    public final void testSimpleDeclaredFunction() throws Exception {
        Block n = this.js(this.fromString("var x = 3;function foo() {  var y = 3;  z = 4;};"));
        Scope s0 = Scope.fromProgram(n, this.mq);
        Scope s1 = Scope.fromFunctionConstructor(s0, this.findFunctionConstructor(n, "foo"));
        ScopeTest.assertTrue((boolean)s0.isDefined("x"));
        ScopeTest.assertFalse((boolean)s0.isImported("x"));
        ScopeTest.assertFalse((boolean)s0.isFunction("x"));
        ScopeTest.assertFalse((boolean)s0.isDeclaredFunction("x"));
        ScopeTest.assertTrue((boolean)s0.isDefined("foo"));
        ScopeTest.assertFalse((boolean)s0.isImported("foo"));
        ScopeTest.assertTrue((boolean)s0.isFunction("foo"));
        ScopeTest.assertTrue((boolean)s0.isDeclaredFunction("foo"));
        ScopeTest.assertFalse((boolean)s0.isDefined("y"));
        ScopeTest.assertFalse((boolean)s0.isImported("y"));
        ScopeTest.assertFalse((boolean)s0.isFunction("y"));
        ScopeTest.assertFalse((boolean)s0.isDeclaredFunction("y"));
        ScopeTest.assertFalse((boolean)s0.isDefined("z"));
        ScopeTest.assertTrue((boolean)s0.isImported("z"));
        ScopeTest.assertFalse((boolean)s0.isFunction("z"));
        ScopeTest.assertFalse((boolean)s0.isDeclaredFunction("z"));
        ScopeTest.assertTrue((boolean)s1.isDefined("x"));
        ScopeTest.assertFalse((boolean)s1.isImported("x"));
        ScopeTest.assertFalse((boolean)s1.isFunction("x"));
        ScopeTest.assertFalse((boolean)s1.isDeclaredFunction("x"));
        ScopeTest.assertTrue((boolean)s1.isDefined("foo"));
        ScopeTest.assertFalse((boolean)s1.isImported("foo"));
        ScopeTest.assertTrue((boolean)s1.isFunction("foo"));
        ScopeTest.assertFalse((boolean)s1.isDeclaredFunction("foo"));
        ScopeTest.assertTrue((boolean)s1.isDefined("y"));
        ScopeTest.assertFalse((boolean)s1.isImported("y"));
        ScopeTest.assertFalse((boolean)s1.isFunction("y"));
        ScopeTest.assertFalse((boolean)s1.isDeclaredFunction("y"));
        ScopeTest.assertFalse((boolean)s1.isDefined("z"));
        ScopeTest.assertTrue((boolean)s1.isImported("z"));
        ScopeTest.assertFalse((boolean)s1.isFunction("z"));
        ScopeTest.assertFalse((boolean)s1.isDeclaredFunction("z"));
    }

    public final void testFreeVariablesDotted() throws Exception {
        this.assertFreeVariables("a;", "a", "");
        this.assertFreeVariables("a.b;", "a", "b");
        this.assertFreeVariables("a.b.c;", "a", "b,c");
        this.assertFreeVariables("a.b.c.d;", "a", "b,c,d");
    }

    public final void testFreeVariablesIndexedChained() throws Exception {
        this.assertFreeVariables("a;", "a", "");
        this.assertFreeVariables("a[b];", "a,b", "");
        this.assertFreeVariables("a[b][c];", "a,b,c", "");
        this.assertFreeVariables("a[b][c][d];", "a,b,c,d", "");
    }

    public final void testFreeVariablesIndexedRecursive() throws Exception {
        this.assertFreeVariables("a;", "a", "");
        this.assertFreeVariables("a[b];", "a,b", "");
        this.assertFreeVariables("a[b[c]];", "a,b,c", "");
        this.assertFreeVariables("a[b[c[d]]];", "a,b,c,d", "");
    }

    public final void testFreeVariableFunction() throws Exception {
        this.assertFreeVariables("a();", "a", "");
    }

    public final void testFreeVariableFunctionWithMember() throws Exception {
        this.assertFreeVariables("a();", "a", "");
        this.assertFreeVariables("a().b;", "a", "b");
        this.assertFreeVariables("a().b.c;", "a", "b,c");
        this.assertFreeVariables("a().b.c.d;", "a", "b,c,d");
    }

    public final void testFreeVariableFunctionParams() throws Exception {
        this.assertFreeVariables("a(b, c, d);", "a,b,c,d", "");
    }

    public final void testFreeVariableDeclaration() throws Exception {
        this.assertFreeVariables("var a = b, c = d;", "b,d", "a,c");
    }

    public final void testFreeVariableCatchStmt() throws Exception {
        this.assertFreeVariables("   try {   a; } catch (e) {   b;   e; }", "a,b", "e");
        this.assertFreeVariables("   try {   a; } catch (e0) {   b;   try {     c;   } catch (e1) {     d;     e0;   } }", "a,b,c,d", "e0,e1");
        this.assertFreeVariables("   try {   a; } catch (e0) {   b;   try {     c;   } catch (e1) {     d;     e0;   }   e1; }", "a,b,c,d,e1", "e0");
    }

    private void assertFreeVariables(String code, String freeVariables, String notFreeVariables) throws Exception {
        Block n = this.js(this.fromString(code));
        Scope s = Scope.fromProgram(n, this.mq);
        for (String v : freeVariables.split(",")) {
            ScopeTest.assertTrue((String)("<" + v + "> should be a free variable in <" + code + ">"), (boolean)s.isImported(v));
        }
        for (String v : notFreeVariables.split(",")) {
            ScopeTest.assertFalse((String)("<" + v + "> should not be a free variable in <" + code + ">"), (boolean)s.isImported(v));
        }
    }

    public final void testAnonymousFunction() throws Exception {
        Block n = this.js(this.fromString("var x = function() {};"));
        Scope s0 = Scope.fromProgram(n, this.mq);
        Scope s1 = Scope.fromFunctionConstructor(s0, this.findFunctionConstructor(n, null));
        ScopeTest.assertTrue((boolean)s0.isDefined("x"));
        ScopeTest.assertFalse((boolean)s0.isImported("x"));
        ScopeTest.assertTrue((boolean)s1.isDefined("x"));
        ScopeTest.assertFalse((boolean)s1.isImported("x"));
    }

    public final void testNamedFunction() throws Exception {
        Block n = this.js(this.fromString("var x = function foo() {};"));
        Scope s0 = Scope.fromProgram(n, this.mq);
        Scope s1 = Scope.fromFunctionConstructor(s0, this.findFunctionConstructor(n, "foo"));
        ScopeTest.assertTrue((boolean)s0.isDefined("x"));
        ScopeTest.assertFalse((boolean)s0.isImported("x"));
        ScopeTest.assertFalse((boolean)s0.isDefined("foo"));
        ScopeTest.assertFalse((boolean)s0.isImported("foo"));
        ScopeTest.assertTrue((boolean)s1.isDefined("x"));
        ScopeTest.assertFalse((boolean)s1.isImported("x"));
        ScopeTest.assertTrue((boolean)s1.isDefined("foo"));
        ScopeTest.assertFalse((boolean)s1.isImported("foo"));
    }

    public final void testNamedFunctionSameName() throws Exception {
        Block n = this.js(this.fromString("var x = function x() {};"));
        Scope s0 = Scope.fromProgram(n, this.mq);
        Scope s1 = Scope.fromFunctionConstructor(s0, this.findFunctionConstructor(n, "x"));
        ScopeTest.assertTrue((boolean)s0.isDefined("x"));
        ScopeTest.assertFalse((boolean)s0.isImported("x"));
        ScopeTest.assertTrue((boolean)s1.isDefined("x"));
        ScopeTest.assertFalse((boolean)s1.isImported("x"));
    }

    public final void testFormalParams() throws Exception {
        Block n = this.js(this.fromString("function f(x) {};"));
        Scope s0 = Scope.fromProgram(n, this.mq);
        Scope s1 = Scope.fromFunctionConstructor(s0, this.findFunctionConstructor(n, "f"));
        ScopeTest.assertFalse((boolean)s0.isDefined("x"));
        ScopeTest.assertTrue((boolean)s1.isDefined("x"));
    }

    public final void testCatchBlocks() throws Exception {
        Block n = this.js(this.fromString("try { } catch (e) { var x; }"));
        TryStmt t = (TryStmt)n.children().get(0);
        CatchStmt c = (CatchStmt)t.children().get(1);
        Scope s0 = Scope.fromProgram(n, this.mq);
        Scope s1 = Scope.fromCatchStmt(s0, c);
        ScopeTest.assertFalse((boolean)s0.isDefined("e"));
        ScopeTest.assertTrue((boolean)s1.isDefined("e"));
        ScopeTest.assertTrue((boolean)s1.isException("e"));
        ScopeTest.assertTrue((boolean)s0.isDefined("x"));
    }

    public final void testBodyOfNamedFunction() throws Exception {
        Block n = this.js(this.fromString("function foo() { var x; }"));
        Scope s0 = Scope.fromProgram(n, this.mq);
        ScopeTest.assertEquals((int)0, (int)this.mq.getMessages().size());
        ScopeTest.assertTrue((boolean)s0.isDefined("foo"));
    }

    public final void testMaskedExceptionVariablesErrorA() throws Exception {
        Block n = this.js(this.fromString("var e; try { } catch (e) { var x; }"));
        TryStmt t = (TryStmt)n.children().get(1);
        CatchStmt c = (CatchStmt)t.children().get(1);
        Scope s0 = Scope.fromProgram(n, this.mq);
        Scope.fromCatchStmt(s0, c);
        this.assertMsgType(MessageType.MASKING_SYMBOL, this.mq.getMessages().get(0));
        this.assertMsgLevel(MessageLevel.ERROR, this.mq.getMessages().get(0));
    }

    public final void testMaskedExceptionVariablesErrorB() throws Exception {
        Block n = this.js(this.fromString("try { } catch (e) { function foo() { var e; } }"));
        TryStmt t = (TryStmt)n.children().get(0);
        CatchStmt c = (CatchStmt)t.children().get(1);
        Declaration d = this.findNodeWithIdentifier(n, Declaration.class, "foo");
        FunctionConstructor fc = (FunctionConstructor)d.getInitializer();
        Scope s0 = Scope.fromProgram(n, this.mq);
        Scope s1 = Scope.fromCatchStmt(s0, c);
        Scope.fromFunctionConstructor(s1, fc);
        ScopeTest.assertEquals((int)1, (int)this.mq.getMessages().size());
        this.assertMsgType(MessageType.MASKING_SYMBOL, this.mq.getMessages().get(0));
        this.assertMsgLevel(MessageLevel.ERROR, this.mq.getMessages().get(0));
    }

    public final void testMaskedExceptionVariablesSame() throws Exception {
        Block outerBlock = this.js(this.fromString("try { } catch (e) { try { } catch (e) { var x; } }"));
        TryStmt t0 = (TryStmt)outerBlock.children().get(0);
        CatchStmt c0 = t0.getCatchClause();
        Block b0 = c0.getBody();
        TryStmt t1 = (TryStmt)b0.children().get(0);
        CatchStmt c1 = t1.getCatchClause();
        Scope sn = Scope.fromProgram(outerBlock, this.mq);
        Scope sc0 = Scope.fromCatchStmt(sn, c0);
        Scope.fromCatchStmt(sc0, c1);
        ScopeTest.assertEquals((int)0, (int)this.mq.getMessages().size());
    }

    private void assertFunctionRedefined(String code, boolean recurseIntoFunction, MessageType type, MessageLevel level) throws Exception {
        Block b = this.js(this.fromString(code));
        Scope s0 = Scope.fromProgram(b, this.mq);
        if (recurseIntoFunction) {
            Scope.fromFunctionConstructor(s0, this.findFunctionConstructor(b, "foo"));
        }
        ScopeTest.assertFalse((this.mq.getMessages().size() == 0 ? 1 : 0) != 0);
        this.assertMsgType(type, this.mq.getMessages().get(0));
        this.assertMsgLevel(level, this.mq.getMessages().get(0));
    }

    public final void testFunctionsRedefined() throws Exception {
        this.assertFunctionRedefined("function foo() {} var foo;", false, MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR);
        this.assertFunctionRedefined("function foo() {} var foo = 3;", false, MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR);
        this.assertFunctionRedefined("function foo() { var foo; }", true, MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR);
        this.assertFunctionRedefined("function foo() { var foo = 3; }", true, MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR);
        this.assertFunctionRedefined("var f = function foo() {}; var foo;", false, MessageType.SYMBOL_REDEFINED, MessageLevel.LINT);
        this.assertFunctionRedefined("var f = function foo() {}; var foo = 3;", false, MessageType.SYMBOL_REDEFINED, MessageLevel.LINT);
        this.assertFunctionRedefined("var f = function foo() { var foo; };", true, MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR);
        this.assertFunctionRedefined("var f = function foo() { var foo = 3; };", true, MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR);
        this.assertFunctionRedefined("function foo(){ (function() { var foo; })(); }", true, MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR);
        this.assertFunctionRedefined("function foo(){ (function() { var foo = 3; })(); }", true, MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR);
    }

    public final void testStartStatementsForProgram() throws Exception {
        Scope s0 = Scope.fromProgram(this.js(this.fromString("{}")), this.mq);
        ScopeTest.assertEquals((int)0, (int)s0.getStartStatements().size());
        s0.addStartStatement(this.js(this.fromString("{}")));
        ScopeTest.assertEquals((int)1, (int)s0.getStartStatements().size());
        s0.addStartOfScopeStatement(this.js(this.fromString("{}")));
        ScopeTest.assertEquals((int)2, (int)s0.getStartStatements().size());
        s0.declareStartOfScopeTempVariable();
        ScopeTest.assertEquals((int)3, (int)s0.getStartStatements().size());
    }

    public final void testStartStatementsForPlainBlock() throws Exception {
        Scope s0 = Scope.fromProgram(this.js(this.fromString("{}")), this.mq);
        Scope s1 = Scope.fromPlainBlock(s0);
        ScopeTest.assertEquals((int)0, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)0, (int)s1.getStartStatements().size());
        s1.addStartStatement(this.js(this.fromString("{}")));
        ScopeTest.assertEquals((int)0, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)1, (int)s1.getStartStatements().size());
        s1.addStartOfScopeStatement(this.js(this.fromString("{}")));
        ScopeTest.assertEquals((int)1, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)1, (int)s1.getStartStatements().size());
        s1.declareStartOfScopeTempVariable();
        ScopeTest.assertEquals((int)2, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)1, (int)s1.getStartStatements().size());
    }

    public final void testStartStatementsForCatchStmt() throws Exception {
        Scope s0 = Scope.fromProgram(this.js(this.fromString("{}")), this.mq);
        Block block = this.js(this.fromString("try {} catch (e) {}"));
        TryStmt t = (TryStmt)block.children().get(0);
        Scope s1 = Scope.fromCatchStmt(s0, t.getCatchClause());
        ScopeTest.assertEquals((int)0, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)0, (int)s1.getStartStatements().size());
        s1.addStartStatement(this.js(this.fromString("{}")));
        ScopeTest.assertEquals((int)0, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)1, (int)s1.getStartStatements().size());
        s1.addStartOfScopeStatement(this.js(this.fromString("{}")));
        ScopeTest.assertEquals((int)1, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)1, (int)s1.getStartStatements().size());
        s1.declareStartOfScopeTempVariable();
        ScopeTest.assertEquals((int)2, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)1, (int)s1.getStartStatements().size());
    }

    public final void testStartStatementsForFunctionConstructor() throws Exception {
        Scope s0 = Scope.fromProgram(this.js(this.fromString("{}")), this.mq);
        Block block = this.js(this.fromString("function() {};"));
        FunctionConstructor fc = (FunctionConstructor)block.children().get(0).children().get(0);
        Scope s1 = Scope.fromFunctionConstructor(s0, fc);
        ScopeTest.assertEquals((int)0, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)0, (int)s1.getStartStatements().size());
        s1.addStartStatement(this.js(this.fromString("{}")));
        ScopeTest.assertEquals((int)0, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)1, (int)s1.getStartStatements().size());
        s1.addStartOfScopeStatement(this.js(this.fromString("{}")));
        ScopeTest.assertEquals((int)0, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)2, (int)s1.getStartStatements().size());
        s1.declareStartOfScopeTempVariable();
        ScopeTest.assertEquals((int)0, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)3, (int)s1.getStartStatements().size());
    }

    public final void testStartStatementsForParseTreeNodeContainer() throws Exception {
        Scope s0 = Scope.fromProgram(this.js(this.fromString("{}")), this.mq);
        Scope s1 = Scope.fromParseTreeNodeContainer(s0, new ParseTreeNodeContainer(new ArrayList()));
        ScopeTest.assertEquals((int)0, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)0, (int)s1.getStartStatements().size());
        s1.addStartStatement(this.js(this.fromString("{}")));
        ScopeTest.assertEquals((int)0, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)1, (int)s1.getStartStatements().size());
        s1.addStartOfScopeStatement(this.js(this.fromString("{}")));
        ScopeTest.assertEquals((int)1, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)1, (int)s1.getStartStatements().size());
        s1.declareStartOfScopeTempVariable();
        ScopeTest.assertEquals((int)2, (int)s0.getStartStatements().size());
        ScopeTest.assertEquals((int)1, (int)s1.getStartStatements().size());
    }

    public final void testUnmaskableIdentifiersInCatch() throws Exception {
        Block b = this.js(this.fromString("try {} catch (Object) {}"));
        TryStmt tryStmt = (TryStmt)b.children().get(0);
        Scope top = Scope.fromProgram(b, this.mq);
        Scope.fromCatchStmt(top, tryStmt.getCatchClause());
        this.assertMessage(RewriterMessageType.CANNOT_MASK_IDENTIFIER, MessageLevel.FATAL_ERROR, MessagePart.Factory.valueOf("Object"));
    }

    public final void testUnmaskableIdentifiersInDeclarations() throws Exception {
        Block b = this.js(this.fromString("var Array, undefined;"));
        Scope.fromProgram(b, this.mq);
        this.assertMessage(RewriterMessageType.CANNOT_MASK_IDENTIFIER, MessageLevel.FATAL_ERROR, MessagePart.Factory.valueOf("Array"));
    }

    public final void testUnmaskableFormals() throws Exception {
        Block b = this.js(this.fromString("function NaN(Infinity, arguments) {}"));
        Scope top = Scope.fromProgram(b, this.mq);
        FunctionDeclaration fn = (FunctionDeclaration)b.children().get(0);
        Scope.fromFunctionConstructor(top, fn.getInitializer());
        this.assertMessage(RewriterMessageType.CANNOT_MASK_IDENTIFIER, MessageLevel.FATAL_ERROR, MessagePart.Factory.valueOf("NaN"));
        this.assertMessage(RewriterMessageType.CANNOT_MASK_IDENTIFIER, MessageLevel.FATAL_ERROR, MessagePart.Factory.valueOf("Infinity"));
        this.assertMessage(RewriterMessageType.CANNOT_MASK_IDENTIFIER, MessageLevel.FATAL_ERROR, MessagePart.Factory.valueOf("arguments"));
    }

    private FunctionConstructor findFunctionConstructor(ParseTreeNode root, String name) {
        return this.findNodeWithIdentifier(root, FunctionConstructor.class, name);
    }

    private <T extends ParseTreeNode> T findNodeWithIdentifier(ParseTreeNode root, final Class<T> clazz, final String identifierValue) {
        final Holder result = new Holder();
        root.acceptPreOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> chain) {
                if (clazz.isAssignableFrom(chain.node.getClass()) && chain.node.children().size() > 0 && chain.node.children().get(0) instanceof Identifier) {
                    Identifier id = (Identifier)chain.node.children().get(0);
                    if (identifierValue == null && id.getValue() == null || identifierValue != null && identifierValue.equals(id.getValue())) {
                        Assert.assertNull(result.value);
                        result.value = chain.node;
                        return false;
                    }
                }
                return true;
            }
        }, null);
        ScopeTest.assertNotNull(result.value);
        return (T)((ParseTreeNode)result.value);
    }

    private void assertMsgType(MessageType type, Message message) {
        ScopeTest.assertEquals((Object)type, (Object)message.getMessageType());
    }

    private void assertMsgLevel(MessageLevel level, Message message) {
        ScopeTest.assertTrue((level.compareTo(message.getMessageLevel()) <= 0 ? 1 : 0) != 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Holder<T> {
        T value;

        private Holder() {
        }
    }
}

