/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.stages.EmbeddedContent;
import com.google.caja.plugin.stages.HtmlEmbeddedContentFinder;
import com.google.caja.util.CajaTestCase;
import java.util.Iterator;

public final class HtmlEmbeddedContentFinderTest
extends CajaTestCase {
    public final void testFilePositionOfAttrib() throws Exception {
        String htmlText = "<hr onclick='foo()'>";
        HtmlEmbeddedContentFinder f = new HtmlEmbeddedContentFinder(HtmlSchema.getDefault(this.mq), this.is.getUri(), this.mq, this.mc);
        Iterator<EmbeddedContent> iterator = f.findEmbeddedContent(this.htmlFragment(this.fromString(htmlText))).iterator();
        HtmlEmbeddedContentFinderTest.assertTrue((boolean)iterator.hasNext());
        EmbeddedContent content = iterator.next();
        CharProducer cp = content.getContent(UriFetcher.NULL_NETWORK);
        FilePosition pos = content.getPosition();
        HtmlEmbeddedContentFinderTest.assertEquals((String)" foo() ", (String)cp.toString());
        HtmlEmbeddedContentFinderTest.assertEquals((String)"testFilePositionOfAttrib:1+13@13 - 20@20", (String)pos.toString());
        HtmlEmbeddedContentFinderTest.assertFalse((boolean)iterator.hasNext());
    }

    public final void testFilePositionOfJsUrl() throws Exception {
        String htmlText = "<a href='javascript:foo()'>Foo</a>";
        HtmlEmbeddedContentFinder f = new HtmlEmbeddedContentFinder(HtmlSchema.getDefault(this.mq), this.is.getUri(), this.mq, this.mc);
        Iterator<EmbeddedContent> iterator = f.findEmbeddedContent(this.htmlFragment(this.fromString(htmlText))).iterator();
        HtmlEmbeddedContentFinderTest.assertTrue((boolean)iterator.hasNext());
        EmbeddedContent content = iterator.next();
        CharProducer cp = content.getContent(UriFetcher.NULL_NETWORK);
        FilePosition pos = content.getPosition();
        HtmlEmbeddedContentFinderTest.assertEquals((String)"            foo() ", (String)cp.toString());
        HtmlEmbeddedContentFinderTest.assertEquals((String)"testFilePositionOfJsUrl:1+9@9 - 27@27", (String)pos.toString());
        HtmlEmbeddedContentFinderTest.assertFalse((boolean)iterator.hasNext());
    }
}

