/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.util.Pipeline;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InferFilePositionsStage
implements Pipeline.Stage<Jobs> {
    @Override
    public boolean apply(Jobs jobs) {
        for (Job job : jobs.getJobs()) {
            InferFilePositionsStage.inferFilePositions(job.getRoot());
            InferFilePositionsStage.inferFilePositions(job.getRoot());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static List<FilePosition> inferFilePositions(ParseTreeNode node) {
        if (InferFilePositionsStage.hasFilePosition(node)) {
            for (ParseTreeNode parseTreeNode : node.children()) {
                InferFilePositionsStage.inferFilePositions(parseTreeNode);
            }
            return Collections.singletonList(node.getFilePosition());
        }
        if (!node.children().isEmpty()) {
            void var3_17;
            void var2_10;
            FilePosition filePosition;
            List<FilePosition> positions = new ArrayList<FilePosition>();
            for (ParseTreeNode parseTreeNode : node.children()) {
                positions.addAll(InferFilePositionsStage.inferFilePositions(parseTreeNode));
            }
            if (positions.isEmpty()) {
                return Collections.emptyList();
            }
            Collections.sort(positions, new Comparator<FilePosition>(){

                @Override
                public int compare(FilePosition a, FilePosition b) {
                    return a.source().getUri().compareTo(b.source().getUri());
                }
            });
            if (!((FilePosition)positions.get(0)).source().equals(((FilePosition)positions.get(positions.size() - 1)).source())) {
                int n;
                Object var2_5 = null;
                int n2 = -1;
                int runStart = 0;
                int bestRun = 0;
                int n3 = positions.size();
                for (int i = 0; i < n3; ++i) {
                    void var2_6;
                    InputSource is = ((FilePosition)positions.get(i)).source();
                    if (is.equals(var2_6)) continue;
                    if (i - runStart > bestRun) {
                        int n4 = runStart;
                        bestRun = i - runStart;
                    }
                    InputSource inputSource = is;
                    runStart = i;
                }
                if (n3 - runStart > bestRun) {
                    n = runStart;
                    bestRun = n3 - runStart;
                }
                positions = positions.subList(n, n + bestRun);
            }
            FilePosition filePosition2 = filePosition = (FilePosition)positions.get(0);
            for (FilePosition pos : positions.subList(1, positions.size())) {
                if (var2_10.startCharInFile() > pos.startCharInFile()) {
                    FilePosition filePosition3 = pos;
                }
                if (var3_17.endCharInFile() >= pos.endCharInFile()) continue;
                FilePosition filePosition4 = pos;
            }
            FilePosition span = FilePosition.span((FilePosition)var2_10, (FilePosition)var3_17);
            InferFilePositionsStage.setFilePosition(node, span);
            return Collections.singletonList(span);
        }
        return Collections.emptyList();
    }

    private static void setFilePosition(ParseTreeNode node, FilePosition pos) {
        ((AbstractParseTreeNode)node).setFilePosition(pos);
    }

    private static boolean hasFilePosition(ParseTreeNode node) {
        FilePosition pos = node.getFilePosition();
        return !InputSource.UNKNOWN.equals(pos.source());
    }
}

