/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.js.Block;
import com.google.caja.plugin.ExtractedHtmlContent;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.stages.PipelineStageTestCase;
import com.google.caja.plugin.stages.ResolveUriStage;
import com.google.caja.plugin.stages.RewriteHtmlStage;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class RewriteHtmlStageTest
extends PipelineStageTestCase {
    public final void testScriptExtraction() throws Exception {
        this.assertPipeline(RewriteHtmlStageTest.job("foo<script>extracted();</script>baz", ContentType.HTML), RewriteHtmlStageTest.job("foo<span jobnum=\"1\"></span>baz", ContentType.HTML), RewriteHtmlStageTest.job("{ extracted(); }", ContentType.JS));
        this.assertNoErrors();
        this.assertPipeline(RewriteHtmlStageTest.job("foo<script type=text/vbscript>deleted()</script>baz", ContentType.HTML), RewriteHtmlStageTest.job("foobaz", ContentType.HTML));
        this.assertMessage(PluginMessageType.UNRECOGNIZED_CONTENT_TYPE, MessageLevel.WARNING, new MessagePart[0]);
        this.assertPipeline(RewriteHtmlStageTest.job("foo<script type=\"text/javascript\">var x = 1;</script>baz", ContentType.HTML), RewriteHtmlStageTest.job("foo<span jobnum=\"1\"></span>baz", ContentType.HTML), RewriteHtmlStageTest.job("{\n  var x = 1;\n}", ContentType.JS));
        this.assertNoErrors();
        this.assertPipeline(RewriteHtmlStageTest.job("foo<script type=\"text/javascript\">useXml(<xml>foo</xml>);</script>baz", ContentType.HTML), RewriteHtmlStageTest.job("foobaz", ContentType.HTML));
        this.assertMessage(MessageType.UNEXPECTED_TOKEN, MessageLevel.ERROR, FilePosition.instance(this.is, 1, 42, 42, 1), MessagePart.Factory.valueOf("<"));
        this.assertPipeline(RewriteHtmlStageTest.job("foo<script type=text/javascript>extracted();</script>baz", ContentType.HTML), RewriteHtmlStageTest.job("foo<span jobnum=\"1\"></span>baz", ContentType.HTML), RewriteHtmlStageTest.job("{ extracted(); }", ContentType.JS));
        this.assertNoErrors();
        this.assertPipeline(RewriteHtmlStageTest.job("foo<script></script>baz", ContentType.HTML), RewriteHtmlStageTest.job("foobaz", ContentType.HTML));
        this.assertNoErrors();
    }

    public final void testDataUris() throws Exception {
        this.assertPipeline(RewriteHtmlStageTest.job("foo<script src='data:text/javascript,extracted();'>bar</script>baz", ContentType.HTML), RewriteHtmlStageTest.job("foo<span jobnum=\"1\"></span>baz", ContentType.HTML), RewriteHtmlStageTest.job("{ extracted(); }", ContentType.JS));
        this.assertNoErrors();
        this.assertPipeline(RewriteHtmlStageTest.job("foo<script src='data:,extracted();'>bar</script>baz", ContentType.HTML), RewriteHtmlStageTest.job("foo<span jobnum=\"1\"></span>baz", ContentType.HTML), RewriteHtmlStageTest.job("{ extracted(); }", ContentType.JS));
        this.assertNoErrors();
        this.assertPipeline(RewriteHtmlStageTest.job("foo<script src='data:iso-8859-7;charset=utf-8,extracted%28%29%3B'>bar</script>baz", ContentType.HTML), RewriteHtmlStageTest.job("foo<span jobnum=\"1\"></span>baz", ContentType.HTML), RewriteHtmlStageTest.job("{ extracted(); }", ContentType.JS));
        this.assertNoErrors();
        this.assertPipeline(RewriteHtmlStageTest.job("foo<script src='data:text/javascript;charset=utf-8;base64,ZXh0cmFjdGVkKCk7'>bar</script>baz", ContentType.HTML), RewriteHtmlStageTest.job("foo<span jobnum=\"1\"></span>baz", ContentType.HTML), RewriteHtmlStageTest.job("{ extracted(); }", ContentType.JS));
        this.assertNoErrors();
    }

    public final void testStyleExtraction() throws Exception {
        this.assertPipeline(RewriteHtmlStageTest.job("Foo<style>p { color: blue }</style><p>Bar", ContentType.HTML), RewriteHtmlStageTest.job("Foo<p>Bar</p>", ContentType.HTML), RewriteHtmlStageTest.job("p {\n  color: blue\n}", ContentType.CSS));
        this.assertNoErrors();
        this.assertPipeline(RewriteHtmlStageTest.job("Foo<link rel=stylesheet href=content:p+%7Bcolor%3A+blue%7D><p>Bar", ContentType.HTML), RewriteHtmlStageTest.job("Foo<p>Bar</p>", ContentType.HTML), RewriteHtmlStageTest.job("p {\n  color: blue\n}", ContentType.CSS));
        this.assertNoErrors();
        this.assertPipeline(RewriteHtmlStageTest.job("Foo<style></style><p>Bar", ContentType.HTML), RewriteHtmlStageTest.job("Foo<p>Bar</p>", ContentType.HTML));
        this.assertNoErrors();
    }

    public final void testOnLoadHandlers() throws Exception {
        this.assertPipeline(RewriteHtmlStageTest.job("<body onload=init();>Foo</body>", ContentType.HTML), RewriteHtmlStageTest.job("<html><head></head><body>Foo<span jobnum=\"1\"></span></body></html>", ContentType.HTML), RewriteHtmlStageTest.job("{ init(); }", ContentType.JS));
        this.assertNoErrors();
    }

    public final void testImportedStyles() throws Exception {
        this.assertPipeline(RewriteHtmlStageTest.job("<style>@import 'styles.css';</style>", ContentType.HTML), RewriteHtmlStageTest.job("", ContentType.HTML), RewriteHtmlStageTest.job("@import url('styles.css');", ContentType.CSS));
        this.assertNoErrors();
    }

    public final void testTypeAndMediaAttributes() throws Exception {
        this.assertPipeline(RewriteHtmlStageTest.job("<link rel=stylesheet media=screen href=content:p+%7B%7D>", ContentType.HTML), RewriteHtmlStageTest.job("", ContentType.HTML), RewriteHtmlStageTest.job("@media screen {\n  p {\n  }\n}", ContentType.CSS));
        this.assertNoErrors();
        this.assertPipeline(RewriteHtmlStageTest.job("<link rel=stylesheet type=text/css href=content:p+%7B%7D>", ContentType.HTML), RewriteHtmlStageTest.job("", ContentType.HTML), RewriteHtmlStageTest.job("p {\n}", ContentType.CSS));
        this.assertNoErrors();
        this.assertPipeline(RewriteHtmlStageTest.job("<link rel=stylesheet media=all href=content:p+%7B%7D>", ContentType.HTML), RewriteHtmlStageTest.job("", ContentType.HTML), RewriteHtmlStageTest.job("p {\n}", ContentType.CSS));
        this.assertNoErrors();
        this.assertPipeline(RewriteHtmlStageTest.job("<link rel=stylesheet media=braille,tty type=text/css href=content:p+%7B%7D>", ContentType.HTML), RewriteHtmlStageTest.job("", ContentType.HTML), RewriteHtmlStageTest.job("@media braille, tty {\n  p {\n  }\n}", ContentType.CSS));
        this.assertNoErrors();
    }

    public final void testDeferredScripts() throws Exception {
        this.assertPipeline(RewriteHtmlStageTest.job("<script src=content:a();></script><script defer>b();</script><script src=content:c(); defer=defer></script><script src=content:d(); defer=no></script><br>", ContentType.HTML), RewriteHtmlStageTest.job("<span jobnum=\"1\"></span><span jobnum=\"2\"></span><br /><span jobnum=\"3\"></span><span jobnum=\"4\"></span>", ContentType.HTML), RewriteHtmlStageTest.job("{ a(); }", ContentType.JS), RewriteHtmlStageTest.job("{ d(); }", ContentType.JS), RewriteHtmlStageTest.job("{ b(); }", ContentType.JS), RewriteHtmlStageTest.job("{ c(); }", ContentType.JS));
        this.assertNoErrors();
    }

    public final void testUnloadableScripts() throws Exception {
        this.assertPipeline(RewriteHtmlStageTest.job("<script src=content:onerror=panic;></script><script src=\"http://bogus.com/bogus.js#'!\"></script><script src=content:foo()></script>", ContentType.HTML), RewriteHtmlStageTest.job("<span jobnum=\"1\"></span><span jobnum=\"2\"></span><span jobnum=\"3\"></span>", ContentType.HTML), RewriteHtmlStageTest.job("{ onerror = panic; }", ContentType.JS), RewriteHtmlStageTest.job("{\n  throw new Error('Failed to load bogus.js#%27%21');\n}", ContentType.JS), RewriteHtmlStageTest.job("{ foo(); }", ContentType.JS));
        this.assertNoErrors();
    }

    public final void testBodyClasses() throws Exception {
        this.assertPipeline(RewriteHtmlStageTest.job("<body class=foo><b>Hello, World!</b></body>", ContentType.HTML), RewriteHtmlStageTest.job("<html><head></head><body><b>Hello, World!</b></body></html>", ContentType.HTML), RewriteHtmlStageTest.job("IMPORTS___.htmlEmitter___.addBodyClasses('foo')", ContentType.JS));
    }

    protected boolean runPipeline(Jobs jobs) throws Exception {
        this.mq.getMessages().clear();
        HtmlSchema schema = HtmlSchema.getDefault(this.mq);
        boolean result = new ResolveUriStage(schema).apply(jobs) && new RewriteHtmlStage(schema).apply(jobs);
        for (Job job : Lists.newArrayList(jobs.getJobsByType(ContentType.HTML, new ContentType[0]))) {
            this.extractScripts(((Dom)job.getRoot()).getValue(), jobs);
        }
        return result;
    }

    private void extractScripts(Node node, Jobs jobs) {
        switch (node.getNodeType()) {
            case 1: {
                Element el = (Element)node;
                Block extracted = ExtractedHtmlContent.getExtractedScriptFor(el);
                if (extracted != null) {
                    int jobNum = jobs.getJobs().size();
                    el.setAttributeNS("http://www.w3.org/1999/xhtml", "jobnum", "" + jobNum);
                    jobs.getJobs().add(Job.jsJob(null, extracted, null));
                }
                for (Node c = el.getFirstChild(); c != null; c = c.getNextSibling()) {
                    this.extractScripts(c, jobs);
                }
                break;
            }
            case 9: 
            case 11: {
                for (Node c = node.getFirstChild(); c != null; c = c.getNextSibling()) {
                    this.extractScripts(c, jobs);
                }
                break;
            }
        }
    }
}

