/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.parser.html.Dom;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.templates.TemplateSanitizer;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pipeline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SanitizeHtmlStage
implements Pipeline.Stage<Jobs> {
    private final HtmlSchema htmlSchema;

    public SanitizeHtmlStage(HtmlSchema htmlSchema) {
        if (null == htmlSchema) {
            throw new NullPointerException();
        }
        this.htmlSchema = htmlSchema;
    }

    @Override
    public boolean apply(Jobs jobs) {
        TemplateSanitizer s = new TemplateSanitizer(this.htmlSchema, jobs.getMessageQueue());
        boolean valid = true;
        for (Job job : jobs.getJobsByType(ContentType.HTML, new ContentType[0])) {
            if (s.sanitize(((Dom)job.getRoot()).getValue())) continue;
            valid = false;
        }
        return valid;
    }
}

