/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.TokenStream;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.reporting.DevNullMessageQueue;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public final class LocalizedHtml {
    private final String name;
    private final String xhtml;
    private final FilePosition pos;
    private List<Token<HtmlTokenType>> tokens;

    private static InputSource makeInputSource(String name) {
        try {
            return new InputSource(new URI("message", null, "/" + name, null, null));
        }
        catch (URISyntaxException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
    }

    public LocalizedHtml(String name, String html) {
        this(name, html, FilePosition.startOfFile(LocalizedHtml.makeInputSource(name)));
    }

    public LocalizedHtml(String name, String html, FilePosition pos) {
        this.name = name;
        this.xhtml = html;
        this.pos = pos;
    }

    public String getName() {
        return this.name;
    }

    public String getSerializedForm() {
        return this.xhtml;
    }

    public DocumentFragment substitute(Document sourceDoc, final PlaceholderHandler handler) throws ParseException {
        if (this.tokens == null) {
            ArrayList<Token<HtmlTokenType>> toks = new ArrayList<Token<HtmlTokenType>>();
            HtmlLexer lexer = new HtmlLexer(CharProducer.Factory.create(new StringReader(this.xhtml), this.pos));
            lexer.setTreatedAsXml(true);
            while (lexer.hasNext()) {
                toks.add(lexer.next());
            }
            this.tokens = toks;
        }
        TokenStream<HtmlTokenType> str = new TokenStream<HtmlTokenType>(){
            Iterator<Token<HtmlTokenType>> mainIt;
            Iterator<Token<HtmlTokenType>> placeholderIt;
            Token<HtmlTokenType> pending;
            {
                this.mainIt = LocalizedHtml.this.tokens.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.fetch();
            }

            @Override
            public Token<HtmlTokenType> next() {
                if (!this.fetch()) {
                    throw new NoSuchElementException();
                }
                Token<HtmlTokenType> t = this.pending;
                this.pending = null;
                return t;
            }

            private boolean fetch() {
                if (this.pending != null) {
                    return true;
                }
                while (true) {
                    if (this.placeholderIt != null) {
                        if (this.placeholderIt.hasNext()) {
                            this.pending = this.placeholderIt.next();
                            return true;
                        }
                        this.placeholderIt = null;
                    }
                    if (!this.mainIt.hasNext()) {
                        return false;
                    }
                    Token<HtmlTokenType> t = this.mainIt.next();
                    if (t.type != HtmlTokenType.TAGBEGIN || !"<ihtml:ph".equals(t.text)) {
                        this.pending = t;
                        return true;
                    }
                    String name = null;
                    FilePosition placeholderPos = null;
                    while (this.mainIt.hasNext()) {
                        t = this.mainIt.next();
                        if (t.type == HtmlTokenType.ATTRNAME && "name".equals(t.text) && this.mainIt.hasNext()) {
                            t = this.mainIt.next();
                            if (t.type == HtmlTokenType.ATTRVALUE) {
                                name = LocalizedHtml.this.decodeAttrValue(t.text);
                                placeholderPos = t.pos;
                            }
                        }
                        if (t.type != HtmlTokenType.TAGEND) continue;
                    }
                    if (name == null) continue;
                    this.placeholderIt = handler.substitutePlaceholder(name, placeholderPos);
                }
            }
        };
        TokenQueue<HtmlTokenType> tq = new TokenQueue<HtmlTokenType>(str, this.pos.source(), DomParser.SKIP_COMMENTS);
        tq.setInputRange(this.pos);
        return new DomParser(tq, true, DevNullMessageQueue.singleton()).parseFragment(sourceDoc);
    }

    private String decodeAttrValue(String tokenText) {
        char ch0;
        int len = tokenText.length();
        if (len >= 2 && ((ch0 = tokenText.charAt(0)) == '\"' || ch0 == '\'' || ch0 == tokenText.charAt(len - 1))) {
            tokenText = tokenText.substring(1, len - 1);
        }
        return Nodes.decode(tokenText);
    }

    public String toString() {
        return this.xhtml;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PlaceholderHandler {
        public Iterator<Token<HtmlTokenType>> substitutePlaceholder(String var1, FilePosition var2);
    }
}

