/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.TranslatedCode;
import com.google.caja.plugin.CssRuleRewriter;
import com.google.caja.plugin.ExtractedHtmlContent;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.plugin.UriPolicyHintKey;
import com.google.caja.plugin.templates.IhtmlMessageType;
import com.google.caja.plugin.templates.TemplateCompiler;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCompilerTest
extends CajaTestCase {
    private PluginMeta meta;
    private static String HTML_NS = "http://www.w3.org/1999/xhtml";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.meta = new PluginMeta(UriFetcher.NULL_NETWORK, UriPolicy.IDENTITY);
    }

    public final void testEmptyModule() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("")), this.htmlFragment(this.fromString("")), new Block());
    }

    public final void testTopLevelTextNodes() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("Hello, <b title=howdy>World</b>!!!")), this.htmlFragment(this.fromString("Hello, <b title=howdy>World</b>!!!")), new Block());
    }

    public final void testSafeHtmlWithDynamicModuleId() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromResource("template-compiler-input1.html", this.is)), this.htmlFragment(this.fromResource("template-compiler-golden1-dynamic.html")), this.js(this.fromResource("template-compiler-golden1-dynamic.js")));
    }

    public final void testSafeHtmlWithStaticModuleId() throws Exception {
        this.meta.setIdClass("xyz___");
        this.assertSafeHtml(this.htmlFragment(this.fromResource("template-compiler-input1.html", this.is)), this.htmlFragment(this.fromResource("template-compiler-golden1-static.html")), this.js(this.fromResource("template-compiler-golden1-static.js")));
    }

    public final void testSignalLoadedAtEnd() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<p id=\"a\">a</p><script type=\"text/javascript\">1;</script>")), this.htmlFragment(this.fromString("<p id=\"id_1___\">a</p>")), this.js(this.fromString("function module() {  'use cajita';  {    var el___;    var emitter___ = IMPORTS___.htmlEmitter___;    el___ = emitter___.byId('id_1___');    emitter___.setAttr(        el___, 'id', 'a-' + IMPORTS___.getIdClass___());    el___ = emitter___.finish();  }}function module() {  try {    { 1; }  } catch (ex___) {    ___.getNewModuleHandler().handleUncaughtException(ex___,        onerror, 'testSignalLoadedAtEnd', '1');  }}function module() {  'use cajita';  {    IMPORTS___.htmlEmitter___.signalLoaded();  }}")));
    }

    public final void testTargetsRewritten() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<a href='foo' target='_self'>hello</a>")), this.htmlFragment(this.fromString("<a href='foo' target='_blank'>hello</a>")), new Block());
    }

    public final void testFormRewritten() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<form></form>")), this.htmlFragment(this.fromString("<form action='test://example.org/testFormRewritten' autocomplete='off' target='_blank'></form>")), new Block());
    }

    public final void testNamesRewritten() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<a name='hi'></a>")), this.htmlFragment(this.fromString("<a id='id_1___' target='_blank'></a>")), this.js(this.fromString("function module() {  'use cajita';  {    var el___; var emitter___ = IMPORTS___.htmlEmitter___;    el___ = emitter___.byId('id_1___');    emitter___.setAttr(        el___, 'name', 'hi-' + IMPORTS___.getIdClass___());    el___.removeAttribute('id');    el___ = emitter___.finish();    emitter___.signalLoaded();  }}")));
        this.meta.setIdClass("xyz___");
        this.assertSafeHtml(this.htmlFragment(this.fromString("<a name='hi'></a>")), this.htmlFragment(this.fromString("<a name='hi-xyz___' target='_blank'></a>")), new Block());
    }

    public final void testSanityCheck() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<p name='hi'>Howdy</p>")), this.htmlFragment(this.fromString("<p>Howdy</p>")), new Block());
    }

    public final void testFormName() throws Exception {
        this.meta.setIdClass("suffix___");
        this.assertSafeHtml(this.htmlFragment(this.fromString("<form name='hi'></form>")), this.htmlFragment(this.fromString("<form action='test://example.org/testFormName' autocomplete='off' name='hi-suffix___' target=_blank></form>")), new Block());
    }

    public final void testFormOnSubmitTrue() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<form onsubmit='alert(&quot;hi&quot;); return true;'></form>")), this.htmlFragment(this.fromString("<form action='test://example.org/testFormOnSubmitTrue' autocomplete='off' id=id_2___ target='_blank'></form>")), this.js(this.fromString("function module() {  ;  {    var el___; var emitter___ = IMPORTS___.htmlEmitter___;    el___ = emitter___.byId('id_2___');    var c_1___ = ___.markFuncFreeze(        function(event, thisNode___) {          alert('hi');          return true;        });    el___.onsubmit = function (event) {      return plugin_dispatchEvent___(          this, event, ___.getId(IMPORTS___), c_1___);    };    el___.removeAttribute('id');    el___ = emitter___.finish();    emitter___.signalLoaded();  }}")));
    }

    public final void testJavascriptUrl() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<a href='javascript:alert(1+1)'>Two!!</a>")), this.htmlFragment(this.fromString("<a id=\"id_2___\" target=\"_blank\">Two!!</a>")), this.js(this.fromString("function module() {  ;  {    var el___;    var emitter___ = IMPORTS___.htmlEmitter___;    el___ = emitter___.byId('id_2___');    var c_1___ = IMPORTS___.handlers___.push(___.markFuncFreeze(        function() { alert(1 + 1); })) - 1;    emitter___.setAttr(el___, 'href', 'javascript:'      + encodeURIComponent(          'try{void plugin_dispatchToHandler___('          + ___.getId(IMPORTS___) + ',' + c_1___          + ',[{}])}catch(_){}'));    el___.removeAttribute('id');    el___ = emitter___.finish();    emitter___.signalLoaded();  }}")));
    }

    public final void testJavascriptUrlWithUseCajita() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<a href='javascript:%22use%20cajita%22;alert(1+1)'>Two!!</a>")), this.htmlFragment(this.fromString("<a id=\"id_2___\" target=\"_blank\">Two!!</a>")), this.js(this.fromString("function module() {  'use cajita';  {    var el___; var emitter___ = IMPORTS___.htmlEmitter___;    el___ = emitter___.byId('id_2___');    var c_1___ = IMPORTS___.handlers___.push(___.markFuncFreeze(        function () {          'use cajita';          alert(1 + 1);        })) - 1;    emitter___.setAttr(el___, 'href', 'javascript:'      + encodeURIComponent(          'try{void plugin_dispatchToHandler___('          + ___.getId(IMPORTS___) + ',' + c_1___          + ',[{}])}catch(_){}'));    el___.removeAttribute('id');    el___ = emitter___.finish();    emitter___.signalLoaded();  }}")));
    }

    public final void testFormOnSubmitEmpty() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<form onsubmit=''></form>")), this.htmlFragment(this.fromString("<form action='test://example.org/testFormOnSubmitEmpty' autocomplete='off' target='_blank'></form>")), new Block());
    }

    public final void testImageSrc() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<img src='blank.gif' width='20'/>")), this.htmlFragment(this.fromString("<img src='blank.gif' width='20'/>")), new Block());
    }

    public final void testStyleRewriting() throws Exception {
        InputSource is = new InputSource(URI.create("file:///" + this.getName()));
        this.assertSafeHtml(this.htmlFragment(this.fromString("<div style=\"position: absolute; background: url('bg-image')\">\nHello\n</div>\n", is)), this.htmlFragment(this.fromString("<div style=\"position: absolute; background: url('file:/bg-image')\">\nHello\n</div>")), new Block());
    }

    public final void testEmptyStyleRewriting() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<div style=>\nHello\n</div>\n")), this.htmlFragment(this.fromString("<div>\nHello\n</div>")), new Block());
        this.assertSafeHtml(this.htmlFragment(this.fromString("<div style=''>\nHello\n</div>\n")), this.htmlFragment(this.fromString("<div>\nHello\n</div>")), new Block());
    }

    public final void testEmptyScriptRewriting() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<div onclick=''>\nHello\n</div>\n")), this.htmlFragment(this.fromString("<div>\nHello\n</div>")), new Block());
    }

    public final void testDeferredScripts() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("Hi<script>alert('howdy');</script>\n")), this.htmlFragment(this.fromString("Hi")), this.js(this.fromString("function module() {  try {    { alert('howdy'); }  } catch (ex___) {    ___.getNewModuleHandler().handleUncaughtException(        ex___, onerror, 'testDeferredScripts', '1');  }}function module() {  'use cajita';  {    IMPORTS___.htmlEmitter___.signalLoaded();  }}")));
    }

    public final void testMailto() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<a href='mailto:x@y' target='_blank'>z</a>")), this.htmlFragment(this.fromString("<a href='mailto:x%40y' target='_blank'>z</a>")), new Block());
    }

    public final void testComplexUrl() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<a href='http://b/c;_d=e?f=g&i=%26' target='_blank'>z</a>")), this.htmlFragment(this.fromString("<a href='http://b/c%3b%5fd%3de?f=g&i=%26' target='_blank'>z</a>")), new Block());
    }

    public final void testTextAreas() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<textarea>Howdy!</textarea><script>alert('Howdy yourself!');</script><textarea>Bye!</textarea>")), this.htmlFragment(this.fromString("<textarea>Howdy!</textarea><span id=\"id_1___\"></span><textarea>Bye!</textarea>")), this.js(this.fromString("function module() {  'use cajita';  {    var el___; var emitter___ = IMPORTS___.htmlEmitter___;    emitter___.discard(emitter___.attach('id_1___'));  }}function module() {  try {    { alert('Howdy yourself!'); }  }catch (ex___) {    ___.getNewModuleHandler().handleUncaughtException(        ex___, onerror, 'testTextAreas', '1');  }}function module() {  'use cajita';  {    var el___; var emitter___ = IMPORTS___.htmlEmitter___;    el___ = emitter___.finish();    emitter___.signalLoaded();  }}")));
    }

    public final void testUriAttributeResolution() throws Exception {
        final Holder savedRef = new Holder();
        this.meta = new PluginMeta(UriFetcher.NULL_NETWORK, new UriPolicy(){

            @Override
            public String rewriteUri(ExternalReference u, UriPolicy.UriEffect effect, UriPolicy.LoaderType loader, Map<String, ?> hints) {
                Assert.assertEquals((String)"a::href", (String)UriPolicyHintKey.XML_ATTR.valueFrom(hints));
                savedRef.value = u;
                return "rewritten";
            }
        });
        DocumentFragment htmlInput = this.htmlFragment(this.fromString("<a href=\"x.html\"></a>"));
        this.assertSafeHtml(htmlInput, this.htmlFragment(this.fromString("<a href=\"rewritten\" target=\"_blank\"></a>")), new Block());
        TemplateCompilerTest.assertEquals((Object)Nodes.getFilePositionFor(htmlInput).source(), (Object)((ExternalReference)savedRef.value).getReferencePosition().source());
        TemplateCompilerTest.assertEquals((Object)new URI("x.html"), (Object)((ExternalReference)savedRef.value).getUri());
    }

    public final void testFinishCalledAtEnd() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<div id=\"a\"></div><div id=\"b\"></div><script>1</script>")), this.htmlFragment(this.fromString("<div id=\"id_1___\"></div><div id=\"id_2___\"></div>")), this.js(this.fromString("function module() {  'use cajita';  {    var el___;    var emitter___ = IMPORTS___.htmlEmitter___;    el___ = emitter___.byId('id_1___');    emitter___.setAttr(el___, 'id',      'a-' + IMPORTS___.getIdClass___());    el___ = emitter___.byId('id_2___');    emitter___.setAttr(el___, 'id',      'b-' + IMPORTS___.getIdClass___());    el___ = emitter___.finish();  }}function module() {  try {    {      1;    }  } catch (ex___) {    ___.getNewModuleHandler().handleUncaughtException(ex___,      onerror, 'testFinishCalledAtEnd', '1');  }}function module() {  'use cajita';  {    IMPORTS___.htmlEmitter___.signalLoaded();  }}")));
    }

    public final void testBareTextarea() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<textarea></textarea>")), this.htmlFragment(this.fromString("<textarea></textarea>")), new Block());
    }

    public final void testValidClassNames() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<div class='$-.:;()[]='></div>")), this.htmlFragment(this.fromString("<div class='$-.:;()[]='></div>")), new Block());
        this.assertNoWarnings();
        this.assertSafeHtml(this.htmlFragment(this.fromString("<div class='!@{} ok__1'></div>")), this.htmlFragment(this.fromString("<div class='!@{} ok__1'></div>")), new Block());
        this.assertNoWarnings();
    }

    public final void testValidIdNames() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<input name='tag[]'>")), this.htmlFragment(this.fromString("<input autocomplete='off' name='tag[]'>")), new Block());
        this.assertNoWarnings();
        this.assertSafeHtml(this.htmlFragment(this.fromString("<input name='form$location'>")), this.htmlFragment(this.fromString("<input autocomplete='off' name='form$location'>")), new Block());
        this.assertNoWarnings();
        this.assertSafeHtml(this.htmlFragment(this.fromString("<input name='$-.:;()[]='>")), this.htmlFragment(this.fromString("<input autocomplete='off' name='$-.:;()[]='>")), new Block());
        this.assertNoWarnings();
        this.assertSafeHtml(this.htmlFragment(this.fromString("<div id='23skiddoo'></div><div id='8675309'></div><div id='$-.:;()[]='></div>")), this.htmlFragment(this.fromString("<div id='id_1___'></div><div id='id_2___'></div><div id='id_3___'></div>")), this.js(this.fromString("function module() {  'use cajita';  {    var el___;    var emitter___ = IMPORTS___.htmlEmitter___;    el___ = emitter___.byId('id_1___');    emitter___.setAttr(el___, 'id',      '23skiddoo-' + IMPORTS___.getIdClass___());    el___ = emitter___.byId('id_2___');    emitter___.setAttr(el___, 'id',      '8675309-' + IMPORTS___.getIdClass___());    el___ = emitter___.byId('id_3___');    emitter___.setAttr(el___, 'id',      '$-.:;()[]=-' + IMPORTS___.getIdClass___());    el___ = emitter___.finish();    emitter___.signalLoaded();  }}")));
        this.assertNoWarnings();
    }

    public final void testInvalidClassNames() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<div class='ok bad__'></div>")), this.htmlFragment(this.fromString("<div></div>")), new Block());
        this.assertMessage(true, IhtmlMessageType.ILLEGAL_NAME, MessageLevel.WARNING, MessagePart.Factory.valueOf("bad__"));
        this.assertNoWarnings();
        this.assertSafeHtml(this.htmlFragment(this.fromString("<div class='ok bad__ '></div>")), this.htmlFragment(this.fromString("<div></div>")), new Block());
        this.assertMessage(true, IhtmlMessageType.ILLEGAL_NAME, MessageLevel.WARNING, MessagePart.Factory.valueOf("bad__"));
        this.assertNoWarnings();
        this.assertSafeHtml(this.htmlFragment(this.fromString("<div class='bad__ ok'></div>")), this.htmlFragment(this.fromString("<div></div>")), new Block());
        this.assertMessage(true, IhtmlMessageType.ILLEGAL_NAME, MessageLevel.WARNING, MessagePart.Factory.valueOf("bad__"));
        this.assertNoWarnings();
    }

    public final void testInvalidIdNames() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<input id='bad1__' name='bad2__'>")), this.htmlFragment(this.fromString("<input autocomplete='off'>")), new Block());
        this.assertMessage(true, IhtmlMessageType.ILLEGAL_NAME, MessageLevel.WARNING, MessagePart.Factory.valueOf("bad1__"));
        this.assertMessage(true, IhtmlMessageType.ILLEGAL_NAME, MessageLevel.WARNING, MessagePart.Factory.valueOf("bad2__"));
        this.assertNoWarnings();
        this.assertSafeHtml(this.htmlFragment(this.fromString("<input id='bad1__ ' name='bad2__ '>")), this.htmlFragment(this.fromString("<input autocomplete='off'>")), new Block());
        this.assertMessage(true, IhtmlMessageType.ILLEGAL_NAME, MessageLevel.WARNING, MessagePart.Factory.valueOf("bad1__ "));
        this.assertMessage(true, IhtmlMessageType.ILLEGAL_NAME, MessageLevel.WARNING, MessagePart.Factory.valueOf("bad2__ "));
        this.assertNoWarnings();
        this.assertSafeHtml(this.htmlFragment(this.fromString("<input id='b__ c'>")), this.htmlFragment(this.fromString("<input autocomplete='off'>")), new Block(), false);
        this.assertMessage(true, IhtmlMessageType.ILLEGAL_NAME, MessageLevel.ERROR, MessagePart.Factory.valueOf("b__ c"));
        this.assertNoWarnings();
        this.assertSafeHtml(this.htmlFragment(this.fromString("<input name='d__ e'>")), this.htmlFragment(this.fromString("<input autocomplete='off'>")), new Block(), false);
        this.assertMessage(true, IhtmlMessageType.ILLEGAL_NAME, MessageLevel.ERROR, MessagePart.Factory.valueOf("d__ e"));
        this.assertNoWarnings();
    }

    public final void testIdRefsRewriting() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<table><tr><td headers='a b'></td></tr></table>")), this.htmlFragment(this.fromString("<table><tr><td id='id_1___'></td></tr></table>")), this.js(this.fromString("function module() {  'use cajita';  {    var el___;    var emitter___ = IMPORTS___.htmlEmitter___;    el___ = emitter___.byId('id_1___');    emitter___.setAttr(el___, 'headers',      'a-' + IMPORTS___.getIdClass___()      + ' b-' + IMPORTS___.getIdClass___());    el___.removeAttribute('id');    el___ = emitter___.finish();    emitter___.signalLoaded();  }}")));
    }

    public final void testMultiDocs() throws Exception {
        this.assertSafeHtml(Arrays.asList(this.htmlFragment(this.fromString("Hello")), this.htmlFragment(this.fromString(", World!"))), this.htmlFragment(this.fromString("Hello, World!")), new Block());
    }

    public final void testUsemapSanitized() throws Exception {
        this.meta.setIdClass("suffix___");
        this.assertSafeHtml(this.htmlFragment(this.fromString("<map name=foo><area href=foo.html></map><img usemap=#foo src=pic.gif>")), this.htmlFragment(this.fromString("<map name='foo-suffix___'><area target=_blank href=foo.html /></map><img usemap=#foo-suffix___ src=pic.gif>")), new Block());
    }

    public final void testBadUriFragments() throws Exception {
        this.meta.setIdClass("suffix___");
        this.assertSafeHtml(this.htmlFragment(this.fromString("<map name=foo><area href=foo.html></map><img usemap=foo src=foo.gif><img usemap=##foo src=bar.gif>")), this.htmlFragment(this.fromString("<map name='foo-suffix___'><area target=_blank href=foo.html /></map><img src=foo.gif><img src=bar.gif>")), new Block(), false);
    }

    public final void testSingleValueAttrs() throws Exception {
        this.assertSafeHtml(this.htmlFragment(this.fromString("<input type=\"text\">")), this.htmlFragment(this.fromString("<input autocomplete=\"off\" type=\"text\">")), new Block(), false);
        this.assertSafeHtml(this.htmlFragment(this.fromString("<input autocomplete=\"on\" type=\"text\">")), this.htmlFragment(this.fromString("<input autocomplete=\"off\" type=\"text\">")), new Block(), false);
    }

    private void assertSafeHtml(DocumentFragment input, DocumentFragment htmlGolden, Block jsGolden) throws ParseException {
        this.assertSafeHtml(input, htmlGolden, jsGolden, true);
    }

    private void assertSafeHtml(DocumentFragment input, DocumentFragment htmlGolden, Block jsGolden, boolean checkErrors) throws ParseException {
        this.assertSafeHtml(Collections.singletonList(input), htmlGolden, jsGolden, checkErrors);
    }

    private void assertSafeHtml(List<DocumentFragment> inputs, DocumentFragment htmlGolden, Block jsGolden) throws ParseException {
        this.assertSafeHtml(inputs, htmlGolden, jsGolden, true);
    }

    private void assertSafeHtml(List<DocumentFragment> inputs, DocumentFragment htmlGolden, Block jsGolden, boolean checkErrors) throws ParseException {
        List<Pair<Node, URI>> html = Lists.newArrayList();
        List<CssTree.StyleSheet> css = Lists.newArrayList();
        for (DocumentFragment input : inputs) {
            this.extractScriptsAndStyles(input, URI.create("file:///"), html, css);
        }
        TemplateCompiler tc = new TemplateCompiler(html, css, CssSchema.getDefaultCss21Schema(this.mq), HtmlSchema.getDefault(this.mq), this.meta, this.mc, this.mq);
        Document doc = DomParser.makeDocument(null, null);
        Pair<Node, List<Block>> safeContent = tc.getSafeHtml(doc);
        if (checkErrors) {
            this.assertNoErrors();
        }
        TemplateCompilerTest.assertEquals((Object)((Node)safeContent.a).getOwnerDocument(), (Object)doc);
        TemplateCompilerTest.assertEquals((String)Nodes.render((Node)htmlGolden, true), (String)Nodes.render((Node)safeContent.a, true));
        TemplateCompilerTest.assertEquals((String)TemplateCompilerTest.renderProgram(jsGolden), (String)TemplateCompilerTest.renderProgram(this.consolidate((List)safeContent.b)));
    }

    private void extractScriptsAndStyles(Node n, URI baseUri, List<Pair<Node, URI>> htmlOut, List<CssTree.StyleSheet> cssOut) throws ParseException {
        n = this.extractScripts(n);
        htmlOut.add(Pair.pair(n, baseUri));
        this.extractStyles(n, cssOut);
    }

    private Node extractScripts(Node n) throws ParseException {
        if (n instanceof Element && "script".equals(n.getLocalName()) && HTML_NS.equals(n.getNamespaceURI())) {
            Element span = n.getOwnerDocument().createElementNS(HTML_NS, "span");
            if (n.getParentNode() != null) {
                n.getParentNode().replaceChild(span, n);
            }
            FilePosition filePosition = Nodes.getFilePositionFor(n);
            String text = n.getFirstChild().getNodeValue();
            Block js = this.js(this.fromString(text, filePosition));
            ExtractedHtmlContent.setExtractedScriptFor(span, js);
            Nodes.setFilePositionFor(span, Nodes.getFilePositionFor(n));
            return span;
        }
        for (Node node : Nodes.childrenOf(n)) {
            this.extractScripts(node);
        }
        return n;
    }

    private void extractStyles(Node n, List<CssTree.StyleSheet> styles) throws ParseException {
        if (n instanceof Element && "style".equals(n.getNodeName()) && HTML_NS.equals(n.getNamespaceURI())) {
            FilePosition pos = Nodes.getFilePositionFor(n);
            if (n.getFirstChild() != null) {
                String string = n.getFirstChild().getNodeValue();
                CssTree.StyleSheet css = this.css(this.fromString(string, pos));
                CssRuleRewriter rrw = new CssRuleRewriter(this.meta);
                rrw.rewriteCss(css);
                this.assertMessagesLessSevereThan(MessageLevel.ERROR);
                styles.add(css);
            }
            n.getParentNode().removeChild(n);
            return;
        }
        for (Node node : Nodes.childrenOf(n)) {
            this.extractStyles(node, styles);
        }
    }

    private Block consolidate(List<Block> blocks) {
        Block consolidated = new Block();
        MutableParseTreeNode.Mutation mut = consolidated.createMutation();
        FilePosition unk = FilePosition.UNKNOWN;
        for (Block bl : blocks) {
            Identifier ident = new Identifier(unk, "module");
            mut.appendChild(new FunctionDeclaration(new FunctionConstructor(unk, ident, Collections.<FormalParam>emptyList(), bl)));
        }
        mut.execute();
        TemplateCompilerTest.stripTranslatedCode(consolidated);
        return consolidated;
    }

    private static void stripTranslatedCode(ParseTreeNode node) {
        node.acceptPostOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ac) {
                Object node = ac.node;
                if (node instanceof TranslatedCode) {
                    ((MutableParseTreeNode)ac.parent.node).replaceChild(((TranslatedCode)node).getTranslation(), (ParseTreeNode)node);
                }
                return true;
            }
        }, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Holder<T> {
        T value;

        private Holder() {
        }
    }
}

