/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.render.Concatenator;
import com.google.caja.render.CssMinimalPrinter;
import junit.framework.TestCase;

public class CssMinimalPrinterTest
extends TestCase {
    public final void testRender() {
        this.assertTokens("p{color:red;background:blue}", "p", "{", "color", ":", " ", "red", ";", "background", ":", " ", "blue", "}");
        this.assertTokens("ul li{color:red;background:blue}", "ul", " ", "li", "{", "color", ":", " ", "red", ";", "background", ":", " ", "blue", "}");
    }

    public final void testDeclarationGroup() {
        this.assertTokens("color:red;background:blue", "color", ":", " ", "red", ";", "background", ":", " ", "blue");
    }

    private void assertTokens(String golden, String ... input) {
        StringBuilder out = new StringBuilder();
        CssMinimalPrinter pp = new CssMinimalPrinter(new Concatenator(out));
        for (String token : input) {
            pp.consume(token);
        }
        pp.noMoreTokens();
        CssMinimalPrinterTest.assertEquals((String)golden, (String)out.toString());
    }
}

