/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.render.AbstractRenderer;
import com.google.caja.render.Concatenator;

public class JsLinePreservingPrinter
extends AbstractRenderer {
    private final InputSource is;
    private int lineNumber = 1;
    private String pendingSpace;

    public JsLinePreservingPrinter(InputSource is, Concatenator out) {
        super(out);
        if (is == null) {
            throw new NullPointerException();
        }
        this.is = is;
    }

    public void consume(String text) {
        if ("".equals(text.trim())) {
            return;
        }
        if (this.pendingSpace != null) {
            this.out.consume(this.pendingSpace);
        }
        this.out.consume(text);
        this.pendingSpace = " ";
    }

    public void mark(FilePosition pos) {
        if (this.is.equals(pos.source())) {
            int line = pos.startLineNo();
            StringBuilder sb = new StringBuilder();
            while (this.lineNumber < line) {
                sb.append('\n');
                ++this.lineNumber;
            }
            if (sb.length() != 0) {
                this.pendingSpace = sb.toString();
            }
        }
    }
}

