/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.lexer.TokenConsumer;
import com.google.caja.reporting.MarkupRenderMode;

public class RenderContext {
    private final boolean embeddable;
    private final boolean asciiOnly;
    private final boolean json;
    private final MarkupRenderMode markupMode;
    private final boolean rawObjKeys;
    private final TokenConsumer out;

    public RenderContext(TokenConsumer out) {
        this(true, false, false, MarkupRenderMode.HTML, false, out);
    }

    private RenderContext(boolean asciiOnly, boolean embeddable, boolean json, MarkupRenderMode markupMode, boolean rawObjKeys, TokenConsumer out) {
        if (null == out) {
            throw new NullPointerException();
        }
        this.embeddable = embeddable;
        this.asciiOnly = asciiOnly;
        this.json = json;
        this.markupMode = markupMode;
        this.rawObjKeys = rawObjKeys;
        this.out = out;
    }

    public final boolean isEmbeddable() {
        return this.embeddable;
    }

    public final boolean isAsciiOnly() {
        return this.asciiOnly;
    }

    public final boolean asJson() {
        return this.json;
    }

    public final boolean asXml() {
        return this.markupMode == MarkupRenderMode.XML;
    }

    public final MarkupRenderMode markupRenderMode() {
        return this.markupMode;
    }

    public final boolean rawObjKeys() {
        return this.rawObjKeys;
    }

    public final TokenConsumer getOut() {
        return this.out;
    }

    public RenderContext withAsciiOnly(boolean b) {
        return b != this.asciiOnly ? new RenderContext(b, this.embeddable, this.json, this.markupMode, this.rawObjKeys, this.out) : this;
    }

    public RenderContext withEmbeddable(boolean b) {
        return b != this.embeddable ? new RenderContext(this.asciiOnly, b, this.json, this.markupMode, this.rawObjKeys, this.out) : this;
    }

    public RenderContext withJson(boolean b) {
        return b != this.json ? new RenderContext(this.asciiOnly, this.embeddable, b, this.markupMode, this.rawObjKeys, this.out) : this;
    }

    public RenderContext withMarkupRenderMode(MarkupRenderMode markupMode) {
        return markupMode != this.markupMode ? new RenderContext(this.asciiOnly, this.embeddable, this.json, markupMode, this.rawObjKeys, this.out) : this;
    }

    @Deprecated
    public RenderContext withAsXml(boolean b) {
        return this.withMarkupRenderMode(b ? MarkupRenderMode.XML : MarkupRenderMode.HTML);
    }

    public RenderContext withRawObjKeys(boolean b) {
        return b != this.rawObjKeys ? new RenderContext(this.asciiOnly, this.embeddable, this.json, this.markupMode, b, this.out) : this;
    }
}

