/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.service.CajaArguments;
import com.google.caja.service.ContentHandler;
import com.google.caja.service.ContentHandlerArgs;
import com.google.caja.service.ContentTypeCheck;
import com.google.caja.service.GadgetHandler;
import com.google.caja.service.HtmlHandler;
import com.google.caja.service.ImageHandler;
import com.google.caja.service.InnocentHandler;
import com.google.caja.service.JsHandler;
import com.google.caja.service.LooseContentTypeCheck;
import com.google.caja.service.ServiceMessageType;
import com.google.caja.service.UnsupportedContentTypeException;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CajolingService {
    static final String DEFAULT_HOST = "http://caja.appspot.com/cajole";
    private final List<ContentHandler> handlers = new Vector<ContentHandler>();
    private final ContentTypeCheck typeCheck = new LooseContentTypeCheck();
    private final String host;
    private final UriFetcher uriFetcher;

    public CajolingService() {
        this(BuildInfo.getInstance());
    }

    public CajolingService(BuildInfo buildInfo) {
        this(buildInfo, null);
    }

    public CajolingService(BuildInfo buildInfo, String host) {
        this(buildInfo, host, new UriFetcher(){

            public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
                try {
                    return FetchedData.fromConnection(ref.getUri().toURL().openConnection());
                }
                catch (IOException ex) {
                    throw new UriFetcher.UriFetchException(ref, mimeType, ex);
                }
            }
        });
    }

    public CajolingService(BuildInfo buildInfo, String host, UriFetcher fetcher) {
        this.host = host != null ? host : DEFAULT_HOST;
        this.uriFetcher = fetcher;
        this.registerHandlers(buildInfo);
    }

    public FetchedData handle(FetchedData inputFetchedData, ContentHandlerArgs args, MessageQueue mq) {
        Pair<String, String> contentInfo;
        URI inputUri;
        String inputUrlString = CajaArguments.URL.get(args);
        if (inputUrlString == null && inputFetchedData == null) {
            mq.addMessage((MessageTypeInt)ServiceMessageType.MISSING_ARGUMENT, MessagePart.Factory.valueOf(CajaArguments.URL.toString()));
            return null;
        }
        if (inputUrlString == null) {
            inputUri = InputSource.UNKNOWN.getUri();
        } else {
            try {
                inputUri = new URI(inputUrlString);
            }
            catch (URISyntaxException ex) {
                mq.addMessage((MessageTypeInt)ServiceMessageType.INVALID_INPUT_URL, MessagePart.Factory.valueOf(inputUrlString));
                return null;
            }
        }
        String expectedInputContentType = CajaArguments.INPUT_MIME_TYPE.get(args);
        if (expectedInputContentType == null) {
            expectedInputContentType = CajaArguments.OLD_INPUT_MIME_TYPE.get(args);
        }
        if (expectedInputContentType == null) {
            mq.addMessage((MessageTypeInt)ServiceMessageType.MISSING_ARGUMENT, MessagePart.Factory.valueOf(CajaArguments.INPUT_MIME_TYPE.toString()));
            return null;
        }
        if (inputFetchedData == null) {
            try {
                inputFetchedData = this.uriFetcher.fetch(new ExternalReference(inputUri, FilePosition.UNKNOWN), expectedInputContentType);
            }
            catch (UriFetcher.UriFetchException ex) {
                ex.toMessageQueue(mq);
                return null;
            }
        }
        if (!this.typeCheck.check(expectedInputContentType, inputFetchedData.getContentType())) {
            mq.addMessage((MessageTypeInt)ServiceMessageType.UNEXPECTED_INPUT_MIME_TYPE, MessagePart.Factory.valueOf(expectedInputContentType), MessagePart.Factory.valueOf(inputFetchedData.getContentType()));
            return null;
        }
        String outputContentType = CajaArguments.OUTPUT_MIME_TYPE.get(args);
        if (outputContentType == null) {
            outputContentType = "*/*";
        }
        String transformName = CajaArguments.TRANSFORM.get(args);
        Transform transform = null;
        if (transformName != null) {
            try {
                transform = Transform.valueOf(transformName);
            }
            catch (Exception e) {
                mq.addMessage((MessageTypeInt)ServiceMessageType.INVALID_ARGUMENT, MessagePart.Factory.valueOf(transformName), MessagePart.Factory.valueOf(CajaArguments.TRANSFORM.toString()));
                return null;
            }
        }
        String directiveName = CajaArguments.DIRECTIVE.get(args);
        List<Directive> directive = Lists.newArrayList();
        if (directiveName != null) {
            try {
                directive.add(Directive.valueOf(directiveName));
            }
            catch (Exception e) {
                mq.addMessage((MessageTypeInt)ServiceMessageType.INVALID_ARGUMENT, MessagePart.Factory.valueOf(directiveName), MessagePart.Factory.valueOf(CajaArguments.DIRECTIVE.toString()));
                return null;
            }
        }
        ByteArrayOutputStream intermediateResponse = new ByteArrayOutputStream();
        try {
            contentInfo = this.applyHandler(inputUri, transform, directive, args, inputFetchedData.getContentType(), outputContentType, inputFetchedData, intermediateResponse, mq);
        }
        catch (UnsupportedContentTypeException e) {
            mq.addMessage((MessageTypeInt)ServiceMessageType.UNSUPPORTED_CONTENT_TYPES, new MessagePart[0]);
            return null;
        }
        catch (RuntimeException e) {
            mq.addMessage((MessageTypeInt)ServiceMessageType.EXCEPTION_IN_SERVICE, MessagePart.Factory.valueOf(e.toString()));
            return null;
        }
        return FetchedData.fromBytes(intermediateResponse.toByteArray(), (String)contentInfo.a, (String)contentInfo.b, new InputSource(inputUri));
    }

    private void registerHandlers(BuildInfo buildInfo) {
        this.handlers.add(new JsHandler(buildInfo));
        this.handlers.add(new ImageHandler());
        this.handlers.add(new GadgetHandler(buildInfo, this.uriFetcher));
        this.handlers.add(new InnocentHandler());
        this.handlers.add(new HtmlHandler(buildInfo, this.host, this.uriFetcher));
    }

    private Pair<String, String> applyHandler(URI uri, Transform t, List<Directive> d, ContentHandlerArgs args, String inputContentType, String outputContentType, FetchedData input, OutputStream response, MessageQueue mq) throws UnsupportedContentTypeException {
        for (ContentHandler handler : this.handlers) {
            if (!handler.canHandle(uri, t, d, inputContentType, outputContentType, this.typeCheck)) continue;
            return handler.apply(uri, t, d, args, inputContentType, outputContentType, this.typeCheck, input, response, mq);
        }
        throw new UnsupportedContentTypeException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Transform {
        INNOCENT,
        CAJOLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Directive {
        CAJITA,
        STRICT,
        ES53;

    }
}

