/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.reporting.MessageLevel;
import com.google.caja.service.ServiceTestCase;
import com.google.caja.util.Join;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class HtmlHandlerTest
extends ServiceTestCase {
    private String requestString(String inputMimeType, String outputMimeType, String moduleCallback) {
        String result = "?url=http://foo/bar.html";
        if (inputMimeType != null) {
            result = result + "&mime-type=" + inputMimeType;
        }
        if (outputMimeType != null) {
            result = result + "&output-mime-type=" + outputMimeType;
        }
        if (moduleCallback != null) {
            result = result + "&module-callback=" + moduleCallback;
        }
        return result;
    }

    private String moduleCallbackPrefix(String moduleCallback) {
        return moduleCallback == null ? "___.loadModule(" : moduleCallback + "(___.prepareModule(";
    }

    private String moduleCallbackSuffix(String moduleCallback) {
        return moduleCallback == null ? ")" : "))";
    }

    private void assertHtml2Html(String inputMimeType, String outputMimeType, String moduleCallback) throws Exception {
        String htmlEnvelope = "<html><head><title>Caja Test</title></head><body>%s</body></html>";
        this.registerUri("http://foo/bar.js", "foo()", "text/javascript");
        this.registerUri("http://foo/bar.html", String.format(htmlEnvelope, "<p>Hello, World!</p><script src=bar.js></script>"), "text/html");
        this.assertMessagesLessSevereThan(MessageLevel.WARNING);
        HtmlHandlerTest.assertEquals((String)("<p>Hello, World!</p><script type=\"text/javascript\">{" + this.moduleCallbackPrefix(moduleCallback) + "{" + "'instantiate':function(___,IMPORTS___){" + "return ___.prepareModule({" + "'instantiate':function(___,IMPORTS___){" + "var\n$v=___.readImport(IMPORTS___,'$v',{" + "'getOuters':{'()':{}}," + "'initOuter':{'()':{}}," + "'cf':{'()':{}}," + "'ro':{'()':{}}" + "});" + "var\nmoduleResult___,$dis;" + "moduleResult___=___.NO_RESULT;" + "$dis=$v.getOuters();" + "$v.initOuter('onerror');" + "try{" + "{moduleResult___=$v.cf($v.ro('foo'),[])}" + "}catch(ex___){" + "___.getNewModuleHandler().handleUncaughtException(" + "ex___,$v.ro('onerror'),'bar.js','1')" + "}" + "return moduleResult___" + "}," + "'cajolerName':'com.google.caja'," + "'cajolerVersion':'testBuildVersion'," + "'cajoledDate':0" + "})(IMPORTS___),___.prepareModule({" + "'instantiate':function(___,IMPORTS___){" + "var\nmoduleResult___;" + "moduleResult___=___.NO_RESULT;" + "{" + "IMPORTS___.htmlEmitter___.signalLoaded()" + "}" + "return moduleResult___" + "}," + "'cajolerName':'com.google.caja'," + "'cajolerVersion':'testBuildVersion'," + "'cajoledDate':0" + "})(IMPORTS___)" + "}," + "'cajolerName':'com.google.caja'," + "'cajolerVersion':'testBuildVersion'," + "'cajoledDate':0" + "}" + this.moduleCallbackSuffix(moduleCallback) + "}</script>"), (String)((String)this.requestGet(this.requestString(inputMimeType, outputMimeType, moduleCallback))));
    }

    public final void testHtml2Html() throws Exception {
        this.assertHtml2Html("*/*", "text/html", null);
        this.assertHtml2Html("*/*", "*/*", null);
        this.assertHtml2Html("text/html", "text/html", null);
        this.assertHtml2Html("text/html", "text/html", "foo.bar.baz");
    }

    public final void testHtml2Json() throws Exception {
        this.assertHtml2Json("*/*", "application/json", null);
        this.assertHtml2Json("text/html", "application/json", null);
        this.assertHtml2Json("text/html", "application/json", "foo.bar.baz");
    }

    public final void testSandboxedLink() throws Exception {
        this.registerUri("http://foo/bar.css", "a { background-image: url(baz.png) }", "text/css");
        this.registerUri("http://foo/index.html", "<link rel=stylesheet href=bar.css><a href=\"shizzle.html\">Clicky</a>", "text/html");
        String result = (String)this.requestGet("?url=http://foo/index.html&mime-type=text/html&output-mime-type=text/html&sext=true&idclass=foo___");
        HtmlHandlerTest.assertEquals((String)Join.join((CharSequence)"", "<style type=\"text/css\">\n", ".foo___ a {\n", "  background-image: url('http://caja.appspot.com/cajole?url=http%3a%2f%2fcaja.appspot.com%2fcajole%3furl%3dhttp%253a%252f%252ffoo%252fbaz.png%26effect%3dSAME%5fDOCUMENT%26loader%3dSANDBOXED%26sext%3dtrue&effect=SAME%5fDOCUMENT&loader=SANDBOXED&sext=true')\n", "}</style>", "<a href=\"http://caja.appspot.com/cajole", "?url=http%3a%2f%2ffoo%2fshizzle.html&amp;effect=NEW_DOCUMENT", "&amp;loader=UNSANDBOXED&amp;sext=true\" target=\"_blank\">", "Clicky", "</a>", "<script type=\"text/javascript\">{", "___.loadModule({", "'instantiate':function(___,IMPORTS___){return},", "'cajolerName':'com.google.caja',", "'cajolerVersion':'testBuildVersion',", "'cajoledDate':0})", "}", "</script>"), (String)result);
    }

    public final void testUnsandboxedLink() throws Exception {
        this.registerUri("http://foo/bar.css", "a { background-image: url(baz.png) }", "text/css");
        this.registerUri("http://foo/index.html", "<link rel=stylesheet href=bar.css><a href=\"shizzle.html\">Clicky</a>", "text/html");
        String result = (String)this.requestGet("?url=http://foo/index.html&mime-type=text/html&output-mime-type=text/html&sext=false&idclass=foo___");
        HtmlHandlerTest.assertEquals((String)Join.join((CharSequence)"", "<style type=\"text/css\">\n", ".foo___ a {\n", "  background-image: url('http://foo/baz.png')\n", "}</style>", "<a href=\"http://foo/shizzle.html\" target=\"_blank\">", "Clicky", "</a>", "<script type=\"text/javascript\">{", "___.loadModule({", "'instantiate':function(___,IMPORTS___){return},", "'cajolerName':'com.google.caja',", "'cajolerVersion':'testBuildVersion',", "'cajoledDate':0})", "}", "</script>"), (String)result);
    }

    private void assertHtml2Json(String inputMimeType, String outputMimeType, String moduleCallback) throws Exception {
        this.registerUri("http://foo/bar.html", "<p>hi</p><script>42;</script><p>bye</p>", "text/html");
        Object result = this.json((String)this.requestGet(this.requestString(inputMimeType, outputMimeType, moduleCallback)));
        HtmlHandlerTest.assertTrue((boolean)(result instanceof JSONObject));
        JSONObject json = (JSONObject)result;
        HtmlHandlerTest.assertEquals((String)"<p>hi<span id=\"id_1___\"></span></p><p>bye</p>", (String)((String)json.get((Object)"html")));
        HtmlHandlerTest.assertEquals((String)("{" + this.moduleCallbackPrefix(moduleCallback) + "{" + "'instantiate':function(___,IMPORTS___){" + "return ___.prepareModule({" + "'instantiate':function(___,IMPORTS___){" + "var\nmoduleResult___,el___,emitter___;" + "moduleResult___=___.NO_RESULT;" + "{" + "emitter___=IMPORTS___.htmlEmitter___;" + "emitter___.discard(emitter___.attach('id_1___'))" + "}" + "return moduleResult___" + "}," + "'cajolerName':'com.google.caja'," + "'cajolerVersion':'testBuildVersion'," + "'cajoledDate':0})(IMPORTS___)," + "___.prepareModule({" + "'instantiate':function(___,IMPORTS___){var\n" + "$v=___.readImport(IMPORTS___,'$v',{" + "'getOuters':{'()':{}}," + "'initOuter':{'()':{}}," + "'ro':{'()':{}}" + "});" + "var\nmoduleResult___,$dis;" + "moduleResult___=___.NO_RESULT;" + "$dis=$v.getOuters();" + "$v.initOuter('onerror');" + "try{" + "{moduleResult___=42}" + "}catch(ex___){" + "___.getNewModuleHandler().handleUncaughtException(" + "ex___,$v.ro('onerror'),'bar.html','1')" + "}" + "return moduleResult___" + "}," + "'cajolerName':'com.google.caja'," + "'cajolerVersion':'testBuildVersion'," + "'cajoledDate':0" + "})(IMPORTS___),___.prepareModule({" + "'instantiate':function(___,IMPORTS___){" + "var\nmoduleResult___,el___,emitter___;" + "moduleResult___=___.NO_RESULT;" + "{" + "emitter___=IMPORTS___.htmlEmitter___;" + "el___=emitter___.finish();" + "emitter___.signalLoaded()" + "}" + "return moduleResult___" + "}," + "'cajolerName':'com.google.caja'," + "'cajolerVersion':'testBuildVersion'," + "'cajoledDate':0" + "})(IMPORTS___)" + "}," + "'cajolerName':'com.google.caja'," + "'cajolerVersion':'testBuildVersion'," + "'cajoledDate':0" + "}" + this.moduleCallbackSuffix(moduleCallback) + "}"), (String)((String)json.get((Object)"js")));
        HtmlHandlerTest.assertTrue((boolean)(json.get((Object)"messages") instanceof JSONArray));
        JSONArray messages = (JSONArray)json.get((Object)"messages");
        this.assertMessagesLessSevereThan(messages, MessageLevel.ERROR);
    }

    private void assertHtml2Js(String inputMimeType, String outputMimeType, String moduleCallback) throws Exception {
        this.registerUri("http://foo/bar.html", "<p>hi</p><script>42;</script><p>bye</p>", "text/html");
        String escapedHtmlString = "'<p>hi<span id=\\\"id_1___\\\"></span></p><p>bye</p>'".replace("<", "\\x3c").replace(">", "\\x3e");
        HtmlHandlerTest.assertEquals((String)("{" + this.moduleCallbackPrefix(moduleCallback) + "{" + "'instantiate':function(___,IMPORTS___){" + "return ___.prepareModule({" + "'instantiate':function(___,IMPORTS___){" + "var\nmoduleResult___;moduleResult___=___.NO_RESULT;" + "{IMPORTS___.htmlEmitter___.emitStatic(" + escapedHtmlString + ")}" + "return moduleResult___" + "}," + "'cajolerName':'com.google.caja'," + "'cajolerVersion':'testBuildVersion'," + "'cajoledDate':0" + "})(IMPORTS___),___.prepareModule({" + "'instantiate':function(___,IMPORTS___){" + "var\nmoduleResult___,el___,emitter___;" + "moduleResult___=___.NO_RESULT;" + "{" + "emitter___=IMPORTS___.htmlEmitter___;" + "emitter___.discard(emitter___.attach('id_1___'))" + "}" + "return moduleResult___" + "}," + "'cajolerName':'com.google.caja'," + "'cajolerVersion':'testBuildVersion'," + "'cajoledDate':0" + "})(IMPORTS___),___.prepareModule({" + "'instantiate':function(___,IMPORTS___){" + "var\n$v=___.readImport(IMPORTS___,'$v',{" + "'getOuters':{'()':{}}," + "'initOuter':{'()':{}}," + "'ro':{'()':{}}" + "});" + "var\nmoduleResult___,$dis;" + "moduleResult___=___.NO_RESULT;" + "$dis=$v.getOuters();" + "$v.initOuter('onerror');" + "try{" + "{moduleResult___=42}" + "}catch(ex___){" + "___.getNewModuleHandler().handleUncaughtException(" + "ex___,$v.ro('onerror'),'bar.html','1')" + "}" + "return moduleResult___" + "}," + "'cajolerName':'com.google.caja'," + "'cajolerVersion':'testBuildVersion'," + "'cajoledDate':0" + "})(IMPORTS___),___.prepareModule({" + "'instantiate':function(___,IMPORTS___){" + "var\nmoduleResult___,el___,emitter___;" + "moduleResult___=___.NO_RESULT;" + "{" + "emitter___=IMPORTS___.htmlEmitter___;" + "el___=emitter___.finish();" + "emitter___.signalLoaded()" + "}" + "return moduleResult___" + "}," + "'cajolerName':'com.google.caja'," + "'cajolerVersion':'testBuildVersion'," + "'cajoledDate':0" + "})(IMPORTS___)" + "}," + "'cajolerName':'com.google.caja'," + "'cajolerVersion':'testBuildVersion'," + "'cajoledDate':0" + "}" + this.moduleCallbackSuffix(moduleCallback) + "}"), (String)((String)this.requestGet(this.requestString(inputMimeType, outputMimeType, moduleCallback))));
    }

    public final void testHtml2Js() throws Exception {
        this.assertHtml2Js("*/*", "text/javascript", null);
        this.assertHtml2Js("*/*", "application/javascript", null);
        this.assertHtml2Js("text/html", "application/javascript", null);
        this.assertHtml2Js("text/html", "text/javascript", null);
        this.assertHtml2Js("text/html", "text/javascript", "foo.bar.baz");
    }

    public final void testErrors2Js() throws Exception {
        String testWithError = "<script>with(foo){}</script>";
        String charSet = "UTF-8";
        byte[] content = testWithError.getBytes(charSet);
        HtmlHandlerTest.assertEquals((String)"", (String)((String)this.requestPost(this.requestString("text/html", "text/javascript", null), content, "text/html", charSet)));
    }

    public final void testErrors2Json() throws Exception {
        this.registerUri("http://foo/bar.html", "<script>with(foo){}</script>", "text/html");
        Object result = this.json((String)this.requestGet(this.requestString("text/html", "application/json", null)));
        HtmlHandlerTest.assertTrue((boolean)(result instanceof JSONObject));
        JSONObject json = (JSONObject)result;
        HtmlHandlerTest.assertTrue((boolean)json.containsKey((Object)"messages"));
        JSONArray messages = (JSONArray)json.get((Object)"messages");
        boolean containsError = false;
        for (Object msg : messages) {
            JSONObject jsonMsg = (JSONObject)msg;
            containsError = containsError || jsonMsg.get((Object)"name").equals("ERROR");
        }
        HtmlHandlerTest.assertTrue((boolean)containsError);
    }
}

