/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.util.Maps;
import com.google.caja.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestHttpServletResponse
implements HttpServletResponse {
    private int status = 200;
    private Map<String, String> headers = Maps.newLinkedHashMap();
    private Object output;

    public void addCookie(Cookie a) {
        throw new UnsupportedOperationException();
    }

    public boolean containsHeader(String n) {
        return this.headers.containsKey(n);
    }

    public String encodeRedirectURL(String arg0) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String arg0) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void sendError(int code) {
        this.setStatus(code);
        this.setContentType("text/html");
        this.getWriter().write("ERROR");
    }

    public void sendError(int code, String desc) {
        this.setStatus(code, desc);
        this.setContentType("text/html");
        this.getWriter().write("ERROR");
    }

    public void sendRedirect(String arg0) {
        throw new UnsupportedOperationException();
    }

    public void setDateHeader(String arg0, long arg1) {
        this.setHeader(arg0, new Date(arg1).toString());
    }

    public void setHeader(String k, String v) {
        if (this.output != null) {
            throw new IllegalStateException();
        }
        this.headers.put(Strings.toLowerCase(k), v);
    }

    public void setIntHeader(String arg0, int arg1) {
        this.setHeader(arg0, "" + arg1);
    }

    public void setStatus(int status) {
        if (this.output != null) {
            throw new IllegalStateException();
        }
        this.status = status;
    }

    @Deprecated
    public void setStatus(int status, String desc) {
        assert (!desc.matches("\\s"));
        this.setStatus(status);
    }

    public int getStatus() {
        return this.status;
    }

    private String getSpecifiedCharacterEncoding() {
        Matcher m;
        String contentType = this.headers.get("content-type");
        if (contentType != null && (m = Pattern.compile(";\\s*charset=(\\S+)").matcher(contentType)).find()) {
            return m.group(1);
        }
        return null;
    }

    public String getCharacterEncoding() {
        String enc = this.getSpecifiedCharacterEncoding();
        return enc != null ? enc : "UTF-8";
    }

    public ServletOutputStream getOutputStream() {
        if (this.output == null) {
            this.output = new ByteArrayOutputStream();
        }
        final OutputStream out = (OutputStream)this.output;
        return new ServletOutputStream(){

            public void write(int arg0) throws IOException {
                out.write(arg0);
            }
        };
    }

    public PrintWriter getWriter() {
        if (this.output == null) {
            this.output = new StringWriter();
        }
        return new PrintWriter((Writer)this.output);
    }

    public void setContentLength(int arg0) {
        assert (arg0 >= 0);
        this.setHeader("Content-length", "" + arg0);
    }

    public void setContentType(String arg0) {
        this.setHeader("Content-type", arg0);
    }

    public Object getOutputObject() {
        if (this.output == null) {
            return null;
        }
        if (this.output instanceof ByteArrayOutputStream) {
            String enc = this.getSpecifiedCharacterEncoding();
            byte[] bytes = ((ByteArrayOutputStream)this.output).toByteArray();
            if (enc != null) {
                try {
                    return new String(bytes, enc);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new SomethingWidgyHappenedError(ex);
                }
            }
            return bytes;
        }
        return ((StringWriter)this.output).toString();
    }

    public void addDateHeader(String arg0, long arg1) {
        this.addHeader(arg0, "" + new Date(arg1));
    }

    public void addHeader(String arg0, String arg1) {
        this.headers.put(arg0, arg1);
    }

    public void addIntHeader(String arg0, int arg1) {
        this.addHeader(arg0, "" + arg1);
    }

    public void flushBuffer() {
        throw new UnsupportedOperationException();
    }

    public int getBufferSize() {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        throw new UnsupportedOperationException();
    }

    public boolean isCommitted() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void resetBuffer() {
        throw new UnsupportedOperationException();
    }

    public void setBufferSize(int arg0) {
        throw new UnsupportedOperationException();
    }

    public void setLocale(Locale arg0) {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        throw new UnsupportedOperationException();
    }

    public void setCharacterEncoding(String charset) {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

