/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.util.Maps;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bag<T> {
    private final Map<T, Integer> counts;

    public static <T> Bag<T> newHashBag() {
        return new Bag(Maps.newLinkedHashMap());
    }

    public static <T extends Comparable<T>> Bag<T> newTreeBag() {
        return new Bag(Maps.newTreeMap());
    }

    public static <T> Bag<T> newTreeBag(Comparator<T> cmp) {
        return new Bag<T>(Maps.newTreeMap(cmp));
    }

    public static <T> Bag<T> newIdentityHashBag() {
        return new Bag(Maps.newIdentityHashMap());
    }

    private Bag(Map<T, Integer> counts) {
        this.counts = counts;
    }

    public int incr(T k) {
        return this.incr(k, 1);
    }

    public int incr(T k, int delta) {
        int next;
        Integer i = this.counts.get(k);
        if (i == null) {
            i = 0;
        }
        if ((next = i + delta) < 0) {
            throw new ArithmeticException();
        }
        if (next == 0) {
            this.counts.remove(k);
        } else {
            this.counts.put(k, i + delta);
        }
        return i;
    }

    public int get(T k) {
        Integer i = this.counts.get(k);
        return i == null ? 0 : i;
    }

    public int reset(T k) {
        Integer i = this.counts.remove(k);
        return i == null ? 0 : i;
    }

    public Set<T> nonZeroCounts() {
        return this.counts.keySet();
    }

    public void clear() {
        this.counts.clear();
    }

    public int hashCode() {
        return ((Object)this.counts).hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Bag && ((Object)this.counts).equals(((Bag)o).counts);
    }

    public String toString() {
        return this.counts.toString();
    }
}

