/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.HashMap;
import java.util.Map;
import org.jgroups.Header;

public class Headers {
    private Object[] data;
    private static final int RESIZE_INCR = 6;

    public Headers(int initial_capacity) {
        this.data = new Object[initial_capacity << 1];
    }

    public Headers(Headers hdrs) {
        this.data = new Object[hdrs.data.length];
        System.arraycopy(hdrs.data, 0, this.data, 0, hdrs.data.length);
    }

    public Object[] getRawData() {
        return this.data;
    }

    public Header getHeader(String key) {
        for (int i = 0; i < this.data.length; i += 2) {
            if (this.data[i] == null) {
                return null;
            }
            if (!this.data[i].equals(key)) continue;
            return (Header)this.data[i + 1];
        }
        return null;
    }

    public Map<String, Header> getHeaders() {
        HashMap<String, Header> retval = new HashMap<String, Header>(this.data.length / 2);
        for (int i = 0; i < this.data.length && this.data[i] != null; i += 2) {
            retval.put((String)this.data[i], (Header)this.data[i + 1]);
        }
        return retval;
    }

    public String printHeaders() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.data.length && this.data[i] != null; i += 2) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.data[i]).append(": ").append(this.data[i + 1]);
        }
        return sb.toString();
    }

    public void putHeader(String key, Header hdr) {
        this._putHeader(key, hdr, 0, true);
    }

    public Header putHeaderIfAbsent(String key, Header hdr) {
        return this._putHeader(key, hdr, 0, false);
    }

    public Header removeHeader(String key) {
        return this.getHeader(key);
    }

    public Headers copy() {
        return new Headers(this);
    }

    public int marshalledSize() {
        int retval = 0;
        for (int i = 0; i < this.data.length && this.data[i] != null; i += 2) {
            retval += ((String)this.data[i]).length() + 2;
            retval += 4;
            retval += ((Header)this.data[i + 1]).size();
        }
        return retval;
    }

    public int size() {
        int retval = 0;
        for (int i = 0; i < this.data.length && this.data[i] != null; i += 2) {
            ++retval;
        }
        return retval;
    }

    public int capacity() {
        return this.data.length / 2;
    }

    public String printObjectHeaders() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.data.length && this.data[i] != null; i += 2) {
            sb.append(this.data[i]).append(": ").append(this.data[i + 1]).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        return this.printHeaders();
    }

    private void resize() {
        int new_size = this.data.length + 6;
        Object[] new_data = new Object[new_size];
        System.arraycopy(this.data, 0, new_data, 0, this.data.length);
        this.data = new_data;
    }

    private Header _putHeader(String key, Header hdr, int start_index, boolean replace_if_present) {
        int i = start_index;
        while (i < this.data.length) {
            if (this.data[i] == null) {
                this.data[i] = key;
                this.data[i + 1] = hdr;
                return null;
            }
            if (this.data[i].equals(key)) {
                Header retval = (Header)this.data[i + 1];
                if (replace_if_present) {
                    this.data[i + 1] = hdr;
                }
                return retval;
            }
            if ((i += 2) < this.data.length) continue;
            this.resize();
        }
        throw new IllegalStateException("unable to add element " + key + ", index=" + i);
    }
}

