/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.groovy;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.rest.ext.groovy.DefaultGroovyResourceLoader;
import org.exoplatform.services.rest.ext.groovy.ExtendedGroovyClassLoader;
import org.exoplatform.services.rest.ext.groovy.SourceFolder;

public class GroovyClassLoaderProvider {
    private ExtendedGroovyClassLoader defaultClassLoader;

    public GroovyClassLoaderProvider() {
        this((ExtendedGroovyClassLoader)((Object)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<ExtendedGroovyClassLoader>(){

            @Override
            public ExtendedGroovyClassLoader run() {
                return new ExtendedGroovyClassLoader(GroovyClassLoaderProvider.class.getClassLoader());
            }
        })));
    }

    protected GroovyClassLoaderProvider(ExtendedGroovyClassLoader defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
    }

    public ExtendedGroovyClassLoader getGroovyClassLoader() {
        return this.defaultClassLoader;
    }

    public ExtendedGroovyClassLoader getGroovyClassLoader(SourceFolder[] sources) throws MalformedURLException {
        if (sources == null || sources.length == 0) {
            return this.getGroovyClassLoader();
        }
        URL[] roots = new URL[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            roots[i] = sources[i].getPath();
        }
        final ExtendedGroovyClassLoader parent = this.getGroovyClassLoader();
        ExtendedGroovyClassLoader classLoader = (ExtendedGroovyClassLoader)((Object)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<ExtendedGroovyClassLoader>(){

            @Override
            public ExtendedGroovyClassLoader run() {
                return new ExtendedGroovyClassLoader(parent);
            }
        }));
        classLoader.setResourceLoader(new DefaultGroovyResourceLoader(roots));
        return classLoader;
    }
}

