/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.serialization.api.annotations.Converted;
import org.exoplatform.webui.Util;
import org.exoplatform.webui.config.ComponentConfigConverter;
import org.exoplatform.webui.config.ComponentHandle;
import org.exoplatform.webui.config.Event;
import org.exoplatform.webui.config.EventInterceptor;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.Validator;
import org.exoplatform.webui.config.metadata.ComponentMetaData;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Converted(value=ComponentConfigConverter.class)
public class Component {
    final ComponentHandle handle;
    private final String id;
    private final String type;
    private final String lifecycle;
    private final String template;
    private final String decorator;
    private final InitParams initParams;
    private final List<Validator> validators;
    private final List<Event> events;
    private final List<EventInterceptor> eventInterceptors;
    private volatile Map<String, Event> eventMap;
    private Lifecycle<UIComponent> componentLifecycle;

    public Component(ComponentMetaData metaData) {
        this(new ComponentHandle(null, metaData.getId() == null ? metaData.getType() : metaData.getType() + metaData.getId()), metaData.getId(), metaData.getType(), metaData.getLifecycle(), metaData.getTemplate(), metaData.getDecorator(), metaData.getInitParams(), metaData.getValidators(), metaData.getEvents(), metaData.getEventInterceptors());
    }

    public Component(Class<?> owner, String id, String type, String lifecycle, String template, String decorator, InitParams initParams, List<Validator> validators, List<Event> events, List<EventInterceptor> eventInterceptors) {
        this(new ComponentHandle(owner, id == null ? type : type + ":" + id), id, type, lifecycle, template, decorator, initParams, validators, events, eventInterceptors);
    }

    private Component(ComponentHandle handle, String id, String type, String lifecycle, String template, String decorator, InitParams initParams, List<Validator> validators, List<Event> events, List<EventInterceptor> eventInterceptors) {
        this.handle = handle;
        this.id = id;
        this.type = type;
        this.lifecycle = lifecycle;
        this.template = template;
        this.decorator = decorator;
        this.initParams = initParams;
        this.validators = validators;
        this.events = events;
        this.eventInterceptors = eventInterceptors;
    }

    public String getKey() {
        return this.handle.getKey();
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getDecorator() {
        return this.decorator;
    }

    public InitParams getInitParams() {
        return this.initParams;
    }

    public List<Validator> getValidators() {
        return this.validators;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public List<EventInterceptor> getEventInterceptors() {
        return this.eventInterceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event getUIComponentEventConfig(String eventName) throws Exception {
        if (this.eventMap == null) {
            Component component = this;
            synchronized (component) {
                if (this.eventMap == null) {
                    HashMap<String, Event> temporaryMap = new HashMap<String, Event>();
                    if (this.events == null) {
                        this.eventMap = temporaryMap;
                        return null;
                    }
                    for (Event event : this.events) {
                        this.createCachedEventListeners(event);
                        temporaryMap.put(event.getName(), event);
                    }
                    this.eventMap = temporaryMap;
                }
                return this.eventMap.get(eventName);
            }
        }
        return this.eventMap.get(eventName);
    }

    public List<EventListener> getUIComponentEventListeners(String eventName) throws Exception {
        Event event = this.getUIComponentEventConfig(eventName);
        if (event == null) {
            return null;
        }
        List<EventListener> cachedListeners = event.getCachedEventListeners();
        if (cachedListeners != null) {
            return cachedListeners;
        }
        cachedListeners = new ArrayList<EventListener>();
        for (String listener : event.getListeners()) {
            if (listener.indexOf(".") < 0) {
                listener = this.type + "$" + listener;
            }
            EventListener eventListener = (EventListener)Util.createObject(listener, event.getInitParams());
            cachedListeners.add(eventListener);
        }
        event.setCachedEventListeners(cachedListeners);
        return cachedListeners;
    }

    private void createCachedEventListeners(Event event) throws Exception {
        ArrayList<EventListener> cachedListeners = new ArrayList<EventListener>();
        for (String listener : event.getListeners()) {
            if (listener.indexOf(".") < 0) {
                listener = this.type + "$" + listener;
            }
            EventListener eventListener = (EventListener)Util.createObject(listener, event.getInitParams());
            cachedListeners.add(eventListener);
        }
        event.setCachedEventListeners(cachedListeners);
    }

    public Lifecycle<UIComponent> getUIComponentLifecycle() throws Exception {
        if (this.componentLifecycle != null) {
            return this.componentLifecycle;
        }
        this.componentLifecycle = this.lifecycle != null ? (Lifecycle)Util.createObject(this.lifecycle, null) : Util.createObject(Lifecycle.class, null);
        return this.componentLifecycle;
    }
}

