/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class PropertyConfigurator
implements Startable {
    private static final Log LOG = ExoLogger.getExoLogger(PropertyConfigurator.class);

    public PropertyConfigurator(ConfigurationManager confManager) {
        this(null, confManager);
    }

    public PropertyConfigurator(InitParams params, ConfigurationManager confManager) {
        String systemPath;
        String path = null;
        if (params != null) {
            ValueParam pathParam;
            PropertiesParam propertiesParam = params.getPropertiesParam("properties");
            if (propertiesParam != null) {
                LOG.debug((Object)"Going to initialize properties from init param");
                Iterator<Property> i = propertiesParam.getPropertyIterator();
                while (i.hasNext()) {
                    Property property = i.next();
                    String name = property.getName();
                    String value = property.getValue();
                    LOG.debug((Object)("Adding property from init param " + name + " = " + value));
                    PropertyManager.setProperty((String)name, (String)value);
                }
            }
            if ((pathParam = params.getValueParam("properties.url")) != null) {
                path = pathParam.getValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Using file path " + path + " found from configuration"));
                }
            }
        }
        if ((systemPath = PropertyManager.getProperty((String)"exo.properties.url")) != null) {
            path = systemPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using file path " + path + " found from system properties"));
            }
        }
        if (path != null) {
            LOG.debug((Object)("Found property file path " + path));
            try {
                URL url = confManager.getURL(path);
                Map<String, String> props = ContainerUtil.loadProperties(url);
                if (props != null) {
                    for (Map.Entry<String, String> entry : props.entrySet()) {
                        String propertyName = entry.getKey();
                        String propertyValue = entry.getValue();
                        PropertyManager.setProperty((String)propertyName, (String)propertyValue);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot load property file " + path), (Throwable)e);
            }
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

