/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.commons.utils.PropertiesLoader;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.container.ContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentLifecyclePlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerUtil {
    private static final Log LOG = ExoLogger.getExoLogger(ContainerUtil.class);

    public static Constructor<?>[] getSortedConstructors(Class<?> clazz) throws NoClassDefFoundError {
        Constructor<?>[] constructors = clazz.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            for (int j = i + 1; j < constructors.length; ++j) {
                if (constructors[i].getParameterTypes().length >= constructors[j].getParameterTypes().length) continue;
                Constructor<?> tmp = constructors[i];
                constructors[i] = constructors[j];
                constructors[j] = tmp;
            }
        }
        return constructors;
    }

    public static Collection<URL> getConfigurationURL(final String configuration) throws Exception {
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Collection c = (Collection)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection>(){

            @Override
            public Collection run() throws IOException {
                return Collections.list(cl.getResources(configuration));
            }
        });
        HashMap<String, URL> map = new HashMap<String, URL>();
        Iterator<Object> i = c.iterator();
        String forbiddenSuffix = "WEB-INF/" + configuration;
        while (i.hasNext()) {
            int index2;
            int index;
            URL url = (URL)i.next();
            String key = url.toString();
            if (key.endsWith(forbiddenSuffix)) continue;
            int index1 = key.lastIndexOf("exo-");
            int n = index = index1 < (index2 = key.lastIndexOf("exo.")) ? index2 : index1;
            if (index >= 0) {
                key = key.substring(index);
            }
            map.put(key, url);
        }
        i = map.values().iterator();
        return map.values();
    }

    public static void addContainerLifecyclePlugin(ExoContainer container, ConfigurationManager conf) {
        Iterator<org.exoplatform.container.xml.ContainerLifecyclePlugin> i = conf.getConfiguration().getContainerLifecyclePluginIterator();
        while (i.hasNext()) {
            org.exoplatform.container.xml.ContainerLifecyclePlugin plugin = i.next();
            ContainerUtil.addContainerLifecyclePlugin(container, plugin);
        }
    }

    private static void addContainerLifecyclePlugin(ExoContainer container, org.exoplatform.container.xml.ContainerLifecyclePlugin plugin) {
        try {
            Class<?> clazz = Class.forName(plugin.getType());
            ContainerLifecyclePlugin cplugin = (ContainerLifecyclePlugin)container.createComponent(clazz, plugin.getInitParams());
            cplugin.setName(plugin.getName());
            cplugin.setDescription(plugin.getDescription());
            container.addContainerLifecylePlugin(cplugin);
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to instanciate plugin " + plugin.getType() + ": " + ex.getMessage()), (Throwable)ex);
        }
    }

    public static void addComponentLifecyclePlugin(ExoContainer container, ConfigurationManager conf) {
        Collection plugins = conf.getConfiguration().getComponentLifecyclePlugins();
        Iterator i = plugins.iterator();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while (i.hasNext()) {
            org.exoplatform.container.xml.ComponentLifecyclePlugin plugin = (org.exoplatform.container.xml.ComponentLifecyclePlugin)i.next();
            try {
                Class<?> classType = loader.loadClass(plugin.getType());
                ComponentLifecyclePlugin instance = (ComponentLifecyclePlugin)classType.newInstance();
                container.addComponentLifecylePlugin(instance);
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to instanciate plugin " + plugin.getType() + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public static void addComponents(ExoContainer container, ConfigurationManager conf) {
        Collection components = conf.getComponents();
        if (components == null) {
            return;
        }
        Iterator i = components.iterator();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            String type = component.getType();
            String key = component.getKey();
            try {
                Class<?> classType = loader.loadClass(type);
                if (key == null) {
                    if (component.isMultiInstance()) {
                        container.registerComponent((ComponentAdapter)new ConstructorInjectionComponentAdapter(classType, classType));
                        LOG.debug((Object)("===>>> Thread local component " + classType.getName() + " registered."));
                        continue;
                    }
                    container.registerComponentImplementation(classType);
                    continue;
                }
                try {
                    Class<?> keyType = loader.loadClass(key);
                    if (component.isMultiInstance()) {
                        container.registerComponent((ComponentAdapter)new ConstructorInjectionComponentAdapter(keyType, classType));
                        LOG.debug((Object)("===>>> Thread local component " + classType.getName() + " registered."));
                        continue;
                    }
                    container.registerComponentImplementation(keyType, classType);
                }
                catch (Exception ex) {
                    container.registerComponentImplementation(key, classType);
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.error((Object)("Cannot register the component corresponding to key = '" + key + "' and type = '" + type + "'"), (Throwable)ex);
            }
        }
    }

    public static Map<String, String> loadProperties(URL url) {
        return ContainerUtil.loadProperties(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadProperties(URL url, boolean resolveVariables) {
        LinkedHashMap props = null;
        String path = null;
        InputStream in = null;
        try {
            if (url != null) {
                path = url.getPath();
                in = url.openStream();
            }
            if (in != null) {
                String fileName = url.getFile();
                if (Tools.endsWithIgnoreCase((String)path, (String)".properties")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Attempt to load property file " + path));
                    }
                    props = PropertiesLoader.load((InputStream)in);
                } else if (Tools.endsWithIgnoreCase((String)fileName, (String)".xml")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Attempt to load property file " + path + " with XML format"));
                    }
                    props = PropertiesLoader.loadFromXML((InputStream)in);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Will not load property file" + path + " because its format is not recognized"));
                }
                if (props != null && resolveVariables) {
                    HashMap<String, Object> currentProps = new HashMap<String, Object>();
                    for (Map.Entry entry : props.entrySet()) {
                        String propertyName = (String)entry.getKey();
                        String propertyValue = (String)entry.getValue();
                        propertyValue = Deserializer.resolveVariables(propertyValue, currentProps);
                        props.put(propertyName, propertyValue);
                        currentProps.put(propertyName, propertyValue);
                    }
                }
            } else {
                LOG.error((Object)("Could not load property file " + path));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot load property file " + path), (Throwable)e);
        }
        finally {
            block25: {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {
                        if (!LOG.isTraceEnabled()) break block25;
                        LOG.trace((Object)("An exception occurred: " + ignore.getMessage()));
                    }
                }
            }
        }
        return props;
    }
}

