/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.PathParamDescriptor;
import org.exoplatform.web.controller.metadata.RequestParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteParamDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteDescriptor {
    private final String path;
    private final Map<QualifiedName, RouteParamDescriptor> routeParams;
    private final Map<QualifiedName, PathParamDescriptor> pathParams;
    private final Map<String, RequestParamDescriptor> requestParams;
    private final List<RouteDescriptor> children;

    public RouteDescriptor(String path) {
        if (path == null) {
            throw new NullPointerException("Was not expecting a null path");
        }
        this.path = path;
        this.routeParams = new HashMap<QualifiedName, RouteParamDescriptor>();
        this.pathParams = new HashMap<QualifiedName, PathParamDescriptor>();
        this.requestParams = new HashMap<String, RequestParamDescriptor>();
        this.children = new ArrayList<RouteDescriptor>();
    }

    public String getPath() {
        return this.path;
    }

    public Set<QualifiedName> getRouteParamNames() {
        return this.routeParams.keySet();
    }

    public Collection<RouteParamDescriptor> getRouteParams() {
        return this.routeParams.values();
    }

    public RouteParamDescriptor getRouteParam(QualifiedName name) {
        return this.routeParams.get(name);
    }

    public RouteDescriptor with(ParamDescriptor ... params) {
        if (params == null) {
            throw new NullPointerException();
        }
        for (ParamDescriptor param : params) {
            if (param == null) {
                throw new IllegalArgumentException();
            }
            if (param instanceof RouteParamDescriptor) {
                RouteParamDescriptor routeParam = (RouteParamDescriptor)param;
                this.routeParams.put(routeParam.getQualifiedName(), routeParam);
            } else if (param instanceof RequestParamDescriptor) {
                RequestParamDescriptor requestParam = (RequestParamDescriptor)param;
                this.requestParams.put(requestParam.getName(), requestParam);
            }
            if (!(param instanceof PathParamDescriptor)) continue;
            PathParamDescriptor pathParam = (PathParamDescriptor)param;
            this.pathParams.put(pathParam.getQualifiedName(), pathParam);
        }
        return this;
    }

    public Collection<RequestParamDescriptor> getRequestParams() {
        return this.requestParams.values();
    }

    public Set<String> getRequestParamMatchNames() {
        return this.requestParams.keySet();
    }

    public RequestParamDescriptor getRequestParam(String matchName) {
        return this.requestParams.get(matchName);
    }

    public Map<QualifiedName, PathParamDescriptor> getPathParams() {
        return this.pathParams;
    }

    public RouteDescriptor sub(RouteDescriptor child) {
        this.children.add(child);
        return this;
    }

    public List<RouteDescriptor> getChildren() {
        return this.children;
    }
}

