/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.util;

import java.net.URL;
import org.exoplatform.services.common.ServiceConfig;

@ServiceConfig(type=ServiceConfig.ServiceType.SINGLE_FINAL)
public class URLCreator {
    public synchronized String createURL(URL url, String link) {
        link = this.createURL(url.getFile(), link);
        return this.createURL(url.getHost(), url.getPort(), url.getProtocol(), link);
    }

    public synchronized String createURL(String host, int port, String protocol, String link) {
        if (link.startsWith("http") || link.startsWith("https") || link.startsWith("ftp")) {
            return link;
        }
        StringBuffer url = new StringBuffer();
        url.append(protocol).append("://").append(host);
        if (port >= 0 && port != 80) {
            url.append(":").append(String.valueOf(port));
        }
        url.append(link);
        return url.toString();
    }

    public synchronized String createURL(String address, String link) {
        if (link.startsWith("http") || link.startsWith("https") || link.startsWith("ftp") || link.startsWith("/")) {
            return link;
        }
        String file = "";
        try {
            file = new URL(address).getFile();
        }
        catch (Exception exp) {
            file = address;
        }
        if (file.trim().length() < 1) {
            return '/' + link;
        }
        StringBuffer buf = new StringBuffer();
        if (file.endsWith("/")) {
            buf.append(file).append(link);
        } else if (file.endsWith("?") || link.startsWith("?")) {
            buf.append(file).append(link);
        } else {
            buf.append(file.trim().substring(0, file.lastIndexOf("/") + 1)).append(link);
        }
        buf.toString().trim();
        if (buf.charAt(0) != '/') {
            buf.insert(0, '/');
        }
        return buf.toString();
    }
}

