/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.serialize;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.exoplatform.services.common.ThreadSoftRef;
import org.exoplatform.services.token.attribute.Attribute;
import org.exoplatform.services.token.attribute.AttributeParser;
import org.exoplatform.services.token.attribute.Attributes;
import org.exoplatform.services.xml.parser.XMLDocument;
import org.exoplatform.services.xml.parser.XMLNode;
import org.exoplatform.services.xml.serialize.BeanMapper;
import org.exoplatform.services.xml.serialize.NodeMap;
import org.exoplatform.services.xml.serialize.NodesMap;
import org.exoplatform.services.xml.serialize.XMLSerialize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XML2Bean
implements BeanMapper {
    static ThreadSoftRef<XML2Bean> MAPPER = new ThreadSoftRef(XML2Bean.class);

    public static final XML2Bean getInstance() {
        return MAPPER.getRef();
    }

    @Override
    public <T> T toBean(Class<T> clazz, XMLDocument document) throws Exception {
        NodeMap map = clazz.getAnnotation(NodeMap.class);
        if (map == null) {
            return null;
        }
        String name = map.value();
        T object = clazz.newInstance();
        XMLNode node = this.searchNode(document.getRoot(), name);
        if (node == null) {
            return null;
        }
        this.toBean(clazz, object, node);
        return object;
    }

    private XMLNode searchNode(XMLNode node, String name) {
        if (node.isNode(name)) {
            return node;
        }
        List<XMLNode> children = node.getChildren();
        if (children == null) {
            return null;
        }
        for (XMLNode ele : children) {
            XMLNode value = this.searchNode(ele, name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public <T> T toBean(Class<T> clazz, XMLNode node) throws Exception {
        T object = clazz.newInstance();
        this.toBean(clazz, object, node);
        return object;
    }

    @Override
    public <T> void toBean(Class<T> clazz, T object, XMLNode node) throws Exception {
        if (clazz != object.getClass()) {
            throw new Exception("Incompatipable type for object and class");
        }
        NodeMap map = clazz.getAnnotation(NodeMap.class);
        if (map == null) {
            return;
        }
        this.toXMLValue(clazz, object, node);
    }

    private void toXMLValue(Class<?> clazz, Object bean, XMLNode node) throws Exception {
        Object data;
        Attributes attrs = AttributeParser.getAttributes(node);
        for (Attribute attr : attrs) {
            Class<?> type;
            Field field = this.getField(attr.getName(), clazz);
            if (field == null || !(type = field.getType()).isPrimitive() && !XMLSerialize.REFLECT_UTIL.getRef().isPrimitiveType(type)) continue;
            data = this.toValue(type, attr.getValue());
            this.putField(bean, field, data);
        }
        List<XMLNode> children = node.getChildren();
        if (children == null) {
            return;
        }
        for (XMLNode ele : children) {
            if (node.getChildren() == null || node.getChildren().size() < 1) {
                return;
            }
            Field field = this.getField(ele.getName(), clazz);
            if (field == null || (data = this.toValue(bean, field, ele)) == null) continue;
            this.putField(bean, field, data);
        }
    }

    private void putField(Object bean, Field field, Object data) throws Exception {
        try {
            Method method = XMLSerialize.REFLECT_UTIL.getRef().getSetterMethod(bean.getClass(), field);
            method.setAccessible(true);
            method.invoke(bean, data);
        }
        catch (Exception e) {
            // empty catch block
        }
        field.setAccessible(true);
        field.set(bean, data);
    }

    private Object toValue(Object bean, Field field, XMLNode node) throws Exception {
        Class<?> type = field.getType();
        field.setAccessible(true);
        Object current = field.get(bean);
        if (current != null) {
            type = current.getClass();
        }
        if (Collection.class.isAssignableFrom(type)) {
            Object eleParamType = Object.class;
            ParameterizedType paramType = (ParameterizedType)field.getGenericType();
            if (paramType.getActualTypeArguments().length > 0) {
                eleParamType = paramType.getActualTypeArguments()[0];
            }
            Object[] array = (Object[])this.toArrayValues((Class<?>)eleParamType, node);
            Collection collection = null;
            collection = current != null && current instanceof Collection ? (ArrayList)current : (type.isInterface() ? new ArrayList() : (Collection)type.newInstance());
            Collections.addAll(collection, array);
            return collection;
        }
        if (type.isArray()) {
            return this.toArrayValues(type, node);
        }
        return this.toValue(type, node);
    }

    private Object toArrayValues(Class<?> type, XMLNode node) throws Exception {
        List<XMLNode> children = node.getChildren();
        if (children == null) {
            return new Object[0];
        }
        Class<?> elementType = type;
        if (type.isArray()) {
            elementType = type.getComponentType();
        }
        Object array = Array.newInstance(elementType, children.size());
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i).getChildren() == null || children.get(i).getChildren().size() < 1) {
                Array.set(array, i, null);
                continue;
            }
            XMLNode elementNode = children.get(i);
            if (elementType.isPrimitive() || XMLSerialize.REFLECT_UTIL.getRef().isPrimitiveType(elementType)) {
                Array.set(array, i, this.toValue(elementType, new String(elementNode.getChild(0).getValue())));
                continue;
            }
            Array.set(array, i, this.toValue(elementType, elementNode));
        }
        return array;
    }

    private Object toValue(Class<?> type, XMLNode node) throws Exception {
        if (type.isPrimitive() || XMLSerialize.REFLECT_UTIL.getRef().isPrimitiveType(type)) {
            String value = new String(node.getChild(0).getValue());
            return this.toValue(type, value);
        }
        NodeMap valueMap = type.getAnnotation(NodeMap.class);
        Object newBean = type.newInstance();
        this.toXMLValue(type, newBean, valueMap == null ? node : node.getChild(0));
        return newBean;
    }

    private Object toValue(Class<?> type, String value) {
        if (type == String.class || value == null) {
            return value;
        }
        if (type == StringBuffer.class) {
            return new StringBuffer(value);
        }
        if (type == StringBuilder.class) {
            return new StringBuilder(value);
        }
        value = value.trim();
        if (type == Character.TYPE || type == Character.class) {
            if (value.length() < 1) {
                return new Character(' ');
            }
            return new Character(value.trim().charAt(0));
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return new Byte(value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return new Boolean(value);
        }
        if (type == Short.TYPE || type == Short.class) {
            return new Short(value);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return new Integer(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return new Long(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return new Float(value);
        }
        if (type == Double.TYPE || type == Double.class) {
            return new Double(value);
        }
        return value;
    }

    private Field getField(String name, Class<?> clazz) throws Exception {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            NodeMap map = field.getAnnotation(NodeMap.class);
            if (map != null && name.equals(map.value())) {
                return field;
            }
            NodesMap maps = field.getAnnotation(NodesMap.class);
            if (maps == null || !name.equals(maps.value())) continue;
            return field;
        }
        if (clazz.getSuperclass() == null) {
            return null;
        }
        return this.getField(name, clazz.getSuperclass());
    }
}

