/*
 * Decompiled with CFR 0.152.
 */
package org.staxnav;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.staxnav.Axis;
import org.staxnav.Naming;
import org.staxnav.StaxNavException;
import org.staxnav.StaxNavigator;
import org.staxnav.TypeConversionException;
import org.staxnav.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StaxNavigatorImpl<N>
implements StaxNavigator<N> {
    private final Naming<N> naming;
    private Entry current;
    private final int depth;
    private boolean trimContent;

    StaxNavigatorImpl(Naming<N> naming, XMLStreamReader stream) throws XMLStreamException {
        if (naming == null) {
            throw new NullPointerException();
        }
        if (stream == null) {
            throw new NullPointerException();
        }
        this.naming = naming;
        this.current = new HeadEntry(stream);
        this.depth = 0;
        this.trimContent = false;
    }

    private StaxNavigatorImpl(Naming<N> naming, Entry current, boolean trimContent) {
        this.naming = naming;
        this.current = current;
        this.depth = current.getElement().getDepth();
        this.trimContent = trimContent;
    }

    @Override
    public N getName() throws StaxNavException {
        return this.current.getElement().getName(this.naming);
    }

    @Override
    public Naming<N> getNaming() {
        return this.naming;
    }

    @Override
    public String getLocalName() throws StaxNavException {
        return this.current.getElement().getName().getLocalPart();
    }

    @Override
    public QName getQName() throws StaxNavException {
        return this.current.getElement().getName();
    }

    @Override
    public Location getLocation() throws StaxNavException {
        return this.current.getElement().getLocation();
    }

    @Override
    public int getDepth() throws StaxNavException {
        return this.current.getElement().getDepth();
    }

    @Override
    public void setTrimContent(boolean trimContent) {
        this.trimContent = trimContent;
    }

    @Override
    public boolean getTrimContent() {
        return this.trimContent;
    }

    @Override
    public String getContent() throws StaxNavException {
        return this.current.getElement().getContent(this.trimContent);
    }

    @Override
    public <V> V parseContent(ValueType<V> valueType) throws IllegalStateException, NullPointerException, StaxNavException {
        if (valueType == null) {
            throw new NullPointerException();
        }
        Entry element = this.current;
        String content = element.getElement().getContent(true);
        if (content == null) {
            throw new IllegalStateException("No content available for parsing");
        }
        try {
            return valueType.parse(content);
        }
        catch (Exception e) {
            if (e instanceof TypeConversionException) {
                throw (TypeConversionException)e;
            }
            throw new TypeConversionException(element.getElement().getLocation(), e, "Could not parse string value " + content);
        }
    }

    @Override
    public String getAttribute(String name) throws NullPointerException, IllegalStateException, StaxNavException {
        Map<String, String> attributes = this.current.getElement().getAttributes();
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes.get(name);
    }

    @Override
    public StaxNavigator<N> fork() throws StaxNavException {
        return this.fork(Axis.SELF);
    }

    @Override
    public StaxNavigator<N> fork(Axis axis) throws StaxNavException {
        if (axis == null) {
            throw new NullPointerException("No null axis accepted");
        }
        StaxNavigatorImpl<N> fork = new StaxNavigatorImpl<N>(this.naming, this.current, this.trimContent);
        Entry next = this._navigate(this.current, axis, null);
        if (next != null) {
            this.current = next;
        }
        return fork;
    }

    @Override
    public Iterable<StaxNavigator<N>> fork(N name) {
        return this.fork(Axis.FOLLOWING_SIBLING, name);
    }

    @Override
    public Iterable<StaxNavigator<N>> fork(Axis axis, N name) {
        List elements;
        if (axis == null) {
            throw new NullPointerException("No null axis accepted");
        }
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (name.equals(this.getName())) {
            elements = new ArrayList();
            elements.add(this.current);
        } else {
            elements = Collections.emptyList();
        }
        while (this.navigate(axis, name)) {
            if (elements.isEmpty()) {
                elements = new LinkedList();
            }
            elements.add(this.current);
        }
        final List a = elements;
        final boolean trimContent = this.trimContent;
        return new Iterable<StaxNavigator<N>>(){

            @Override
            public Iterator<StaxNavigator<N>> iterator() {
                return new Iterator<StaxNavigator<N>>(){
                    Iterator<Entry> i;
                    {
                        this.i = a.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public StaxNavigator<N> next() {
                        Entry next = this.i.next();
                        return new StaxNavigatorImpl(StaxNavigatorImpl.this.naming, next, trimContent);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public String getAttribute(QName name) throws NullPointerException, IllegalStateException, StaxNavException {
        if (name == null) {
            throw new NullPointerException("No null attribute name expected");
        }
        if ("".equals(name.getNamespaceURI())) {
            return this.getAttribute(name.getLocalPart());
        }
        Map<QName, String> qualifiedAttributes = this.current.getElement().getQualifiedAttributes();
        if (qualifiedAttributes.isEmpty()) {
            return null;
        }
        return qualifiedAttributes.get(name);
    }

    @Override
    public Map<String, String> getAttributes() throws NullPointerException, IllegalStateException, StaxNavException {
        Map<String, String> attributes = this.current.getElement().getAttributes();
        if (attributes.isEmpty()) {
            return Collections.emptyMap();
        }
        return attributes;
    }

    @Override
    public Map<QName, String> getQualifiedAttributes() throws NullPointerException, IllegalStateException, StaxNavException {
        Map<QName, String> qualifiedAttributes = this.current.getElement().getQualifiedAttributes();
        Map<String, String> attributes = this.getAttributes();
        if (!attributes.isEmpty()) {
            if (qualifiedAttributes.isEmpty()) {
                qualifiedAttributes = new HashMap<QName, String>(qualifiedAttributes);
            }
            for (String key : attributes.keySet()) {
                qualifiedAttributes.put(new QName(key), attributes.get(key));
            }
        }
        if (qualifiedAttributes.isEmpty()) {
            return Collections.emptyMap();
        }
        return qualifiedAttributes;
    }

    @Override
    public String getNamespaceByPrefix(String prefix) throws NullPointerException, StaxNavException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        return this.current.getElement().getNamespaceByPrefix(prefix);
    }

    @Override
    public N next() throws StaxNavException {
        return this.navigate(Axis.NEXT);
    }

    @Override
    public boolean next(N name) throws StaxNavException {
        return this.navigate(Axis.NEXT, name);
    }

    @Override
    public N child() throws StaxNavException {
        return this.navigate(Axis.CHILD);
    }

    @Override
    public boolean child(N name) throws NullPointerException, StaxNavException {
        return this.navigate(Axis.CHILD, name);
    }

    @Override
    public N sibling() throws StaxNavException {
        return this.navigate(Axis.FOLLOWING_SIBLING);
    }

    @Override
    public boolean sibling(N name) throws NullPointerException, StaxNavException {
        return this.navigate(Axis.FOLLOWING_SIBLING, name);
    }

    @Override
    public N navigate(Axis axis) throws StaxNavException {
        Entry entry = this._navigate(this.current, axis, null);
        if (entry != null) {
            this.current = entry;
            return this.getName();
        }
        return null;
    }

    @Override
    public boolean navigate(Axis axis, N name) throws StaxNavException {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        Entry entry = this._navigate(this.current, axis, name);
        if (entry != null) {
            this.current = entry;
            return true;
        }
        return false;
    }

    private Entry _navigate(Entry current, Axis axis, N name) {
        switch (axis) {
            case SELF: {
                return this._current(current, name);
            }
            case NEXT: {
                return this._next(current, name);
            }
            case CHILD: {
                return this._child(current, name);
            }
            case FOLLOWING_SIBLING: {
                return this._sibling(current, name);
            }
            case FOLLOWING: {
                return this._following(current, name);
            }
        }
        throw new AssertionError();
    }

    private Entry _current(Entry current, N name) throws StaxNavException {
        if (current != null && (name == null || name.equals(this.naming.getName(current.getElement().getName())))) {
            return current;
        }
        return null;
    }

    private Entry _next(Entry current, N name) throws StaxNavException {
        Entry next;
        if (current != null && (next = current.next(this.depth)) != null && (name == null || name.equals(this.naming.getName(next.getElement().getName())))) {
            current = next;
            return current;
        }
        return null;
    }

    private Entry _child(Entry current, N name) throws StaxNavException {
        if (current != null) {
            Entry next;
            Entry element = current;
            while ((next = element.next()) != null && next.getElement().getDepth() > current.getElement().getDepth()) {
                if (next.getElement().getDepth() == current.getElement().getDepth() + 1) {
                    N nextName = this.naming.getName(next.getElement().getName());
                    if (name == null) {
                        current = next;
                        return current;
                    }
                    if (name.equals(nextName)) {
                        current = next;
                        return current;
                    }
                    element = next;
                    continue;
                }
                element = next;
            }
        }
        return null;
    }

    private Entry _sibling(Entry current, N name) throws StaxNavException {
        if (current != null) {
            Entry next;
            Entry element = current;
            while ((next = element.next()) != null && next.getElement().getDepth() >= current.getElement().getDepth()) {
                if (next.getElement().getDepth() == current.getElement().getDepth()) {
                    if (name == null) {
                        current = next;
                        return current;
                    }
                    N siblingName = this.naming.getName(next.getElement().getName());
                    if (name.equals(siblingName)) {
                        current = next;
                        return current;
                    }
                    element = next;
                    continue;
                }
                element = next;
            }
        }
        return null;
    }

    private Entry _following(Entry current, N name) throws StaxNavException {
        if (name == null) {
            throw new UnsupportedOperationException("todo");
        }
        if (current != null) {
            for (Entry entry = current.next(); entry != null; entry = entry.next()) {
                N findName = this.naming.getName(entry.getElement().getName());
                if (!name.equals(findName)) continue;
                current = entry;
                return current;
            }
        }
        return null;
    }

    @Override
    public boolean find(N name) throws StaxNavException {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (name.equals(this.naming.getName(this.current.getElement().getName()))) {
            return true;
        }
        return this.navigate(Axis.FOLLOWING, name);
    }

    @Override
    public N next(Set<N> names) throws StaxNavException {
        N name;
        if (names == null) {
            throw new NullPointerException();
        }
        Entry next = this.current.next(this.depth);
        if (next != null && names.contains(name = this.naming.getName(next.getElement().getName()))) {
            this.current = next;
            return name;
        }
        return null;
    }

    @Override
    public int descendant(N name) throws NullPointerException, StaxNavException {
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        return this._descendant(name);
    }

    private int _descendant(N name) throws StaxNavException {
        Entry next;
        Entry element = this.current;
        while ((next = element.next()) != null && next.getElement().getDepth() >= this.current.getElement().getDepth()) {
            N descendantName = this.naming.getName(next.getElement().getName());
            if (name.equals(descendantName)) {
                int diff = next.getElement().getDepth() - this.current.getElement().getDepth();
                this.current = next;
                return diff;
            }
            element = next;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Element {
        private final Element parent;
        private final QName name;
        private final int depth;
        private final Object content;
        private final Location location;
        private final Map<String, String> attributes;
        private final Map<QName, String> qualifiedAttributes;
        private final Map<String, String> namespaces;

        private Element(XMLStreamReader stream, Element parent) throws XMLStreamException {
            CharSequence content;
            Map<String, String> namespaces;
            Map<QName, String> qualifiedAttributes;
            Map<String, String> attributes;
            Location location;
            QName name;
            block13: {
                if (stream.getEventType() != 1) {
                    throw new AssertionError();
                }
                name = stream.getName();
                location = stream.getLocation();
                attributes = Collections.emptyMap();
                qualifiedAttributes = Collections.emptyMap();
                int attributeCount = stream.getAttributeCount();
                for (int i = 0; i < attributeCount; ++i) {
                    String attributeValue = stream.getAttributeValue(i);
                    QName attributeName = stream.getAttributeName(i);
                    if ("".equals(attributeName.getNamespaceURI())) {
                        if (attributes.isEmpty()) {
                            attributes = new HashMap();
                        }
                        attributes.put(attributeName.getLocalPart(), attributeValue);
                        continue;
                    }
                    if (qualifiedAttributes.isEmpty()) {
                        qualifiedAttributes = new HashMap();
                    }
                    qualifiedAttributes.put(attributeName, attributeValue);
                }
                int namespaceCount = stream.getNamespaceCount();
                if (namespaceCount > 0) {
                    namespaces = new HashMap();
                    for (int i = 0; i < namespaceCount; ++i) {
                        String namespacePrefix = stream.getNamespacePrefix(i);
                        if (namespacePrefix == null) {
                            namespacePrefix = "";
                        }
                        String namespaceURI = stream.getNamespaceURI(i);
                        namespaces.put(namespacePrefix, namespaceURI);
                    }
                } else {
                    namespaces = Collections.emptyMap();
                }
                CharSequence sb = null;
                String chunk = null;
                content = null;
                while (true) {
                    stream.next();
                    int type = stream.getEventType();
                    if (type == 8 || type == 1) break block13;
                    if (type == 4) {
                        if (chunk == null) {
                            chunk = stream.getText();
                            continue;
                        }
                        if (sb == null) {
                            sb = new StringBuilder(chunk);
                        }
                        ((StringBuilder)sb).append(stream.getText());
                        continue;
                    }
                    if (type == 2) break;
                }
                content = sb != null ? sb : chunk;
            }
            int depth = 1 + (parent != null ? parent.getDepth() : 0);
            this.parent = parent;
            this.name = name;
            this.depth = depth;
            this.content = content;
            this.attributes = attributes;
            this.qualifiedAttributes = qualifiedAttributes;
            this.namespaces = namespaces;
            this.location = location;
        }

        protected Element getParent() {
            return this.parent;
        }

        protected <N> N getName(Naming<N> naming) {
            return naming.getName(this.getName());
        }

        protected String getNamespaceByPrefix(String namespacePrefix) {
            for (Element current = this; current != null; current = current.getParent()) {
                String namespaceURI = current.getNamespaces().get(namespacePrefix);
                if (namespaceURI == null) continue;
                return namespaceURI;
            }
            return null;
        }

        protected String getContent(boolean trim) {
            if (this.content != null) {
                String s = this.content.toString();
                if (trim) {
                    s = s.trim();
                }
                return s;
            }
            return null;
        }

        protected QName getName() {
            return this.name;
        }

        protected int getDepth() {
            return this.depth;
        }

        protected Location getLocation() {
            return this.location;
        }

        protected Map<String, String> getAttributes() {
            return this.attributes;
        }

        protected Map<QName, String> getQualifiedAttributes() {
            return this.qualifiedAttributes;
        }

        protected Map<String, String> getNamespaces() {
            return this.namespaces;
        }

        public String toString() {
            return "Element[name=" + this.name + ",location=" + this.location + "]";
        }
    }

    private static class StreamEntry
    extends Entry {
        private final XMLStreamReader stream;
        private final Element element;
        private StreamEntry next;

        private StreamEntry(XMLStreamReader stream, Element element) {
            this.stream = stream;
            this.next = null;
            this.element = element;
        }

        protected Element getElement() throws StaxNavException {
            return this.element;
        }

        protected boolean hasNext(int depth) throws StaxNavException {
            return this.next(depth) != null;
        }

        protected Entry next(int depth) throws StaxNavException {
            Entry next = this.next();
            if (next != null && next.getElement().getDepth() > depth) {
                return next;
            }
            return null;
        }

        protected Entry next() throws StaxNavException {
            try {
                if (this.next == null) {
                    Element parent = this.element;
                    while (true) {
                        int type;
                        if ((type = this.stream.getEventType()) == 1) {
                            this.next = new StreamEntry(this.stream, new Element(this.stream, parent));
                            break;
                        }
                        if (type == 2) {
                            parent = parent.getParent();
                            this.stream.next();
                            continue;
                        }
                        if (type == 8) break;
                        this.stream.next();
                    }
                }
                return this.next;
            }
            catch (XMLStreamException e) {
                throw new StaxNavException(e);
            }
        }

        public String toString() {
            return "StreamEntry[element=" + this.element + "]";
        }
    }

    private static class HeadEntry
    extends Entry {
        private final XMLStreamReader stream;
        private Entry root;

        private HeadEntry(XMLStreamReader stream) {
            this.stream = stream;
            this.root = null;
        }

        private Entry get() {
            if (this.root == null) {
                try {
                    while (this.stream.hasNext()) {
                        int type = this.stream.getEventType();
                        if (type == 1) {
                            this.root = new StreamEntry(this.stream, new Element(this.stream, null));
                            break;
                        }
                        this.stream.next();
                    }
                }
                catch (XMLStreamException e) {
                    throw new StaxNavException(e);
                }
            }
            if (this.root == null) {
                throw new StaxNavException(this.stream.getLocation(), "No head!!!!");
            }
            return this.root;
        }

        protected boolean hasNext(int depth) throws StaxNavException {
            return this.get().hasNext(depth);
        }

        protected Entry next(int depth) throws StaxNavException {
            return this.get().next(depth);
        }

        protected Entry next() throws StaxNavException {
            return this.get().next();
        }

        protected Element getElement() throws StaxNavException {
            return this.get().getElement();
        }

        public String toString() {
            return "HeadEntry";
        }
    }

    private static abstract class Entry {
        private Entry() {
        }

        protected abstract Element getElement() throws StaxNavException;

        protected abstract boolean hasNext(int var1) throws StaxNavException;

        protected abstract Entry next(int var1) throws StaxNavException;

        protected abstract Entry next() throws StaxNavException;
    }
}

